/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.CRC32;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;

public class CrcUtil {
    private static final int BUF_SIZE = 16384;

    public static long computeFileCrc(File file, ProgressMonitor progressMonitor) {
        if (file == null || !file.exists() || !file.canRead()) {
            throw new ZipException("input file is null or does not exist or cannot read. Cannot calculate CRC for the file");
        }
        byte[] byArray = new byte[16384];
        CRC32 cRC32 = new CRC32();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n2;
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                cRC32.update(byArray, 0, n2);
                if (progressMonitor == null) continue;
                progressMonitor.updateWorkCompleted(n2);
                if (!progressMonitor.isCancelAllTasks()) continue;
                progressMonitor.setResult(ProgressMonitor.Result.CANCELLED);
                progressMonitor.setState(ProgressMonitor.State.READY);
                long l2 = 0L;
                return l2;
            }
            long l3 = cRC32.getValue();
            return l3;
        }
    }
}

