/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.model.ExcludeFileFilter;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.util.BitUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.InternalZipConstants;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class FileUtils {
    public static final byte[] DEFAULT_POSIX_FILE_ATTRIBUTES = new byte[]{0, 0, -92, -127};
    public static final byte[] DEFAULT_POSIX_FOLDER_ATTRIBUTES = new byte[]{0, 0, -19, 65};

    public static void setFileAttributes(Path path, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        if (FileUtils.isWindows()) {
            FileUtils.applyWindowsFileAttributes(path, byArray);
        } else if (FileUtils.isMac() || FileUtils.isUnix()) {
            FileUtils.applyPosixFileAttributes(path, byArray);
        }
    }

    public static void setFileLastModifiedTime(Path path, long l2) {
        if (l2 <= 0L || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.setLastModifiedTime(path, FileTime.fromMillis(Zip4jUtil.dosToExtendedEpochTme(l2)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFileLastModifiedTimeWithoutNio(File file, long l2) {
        file.setLastModified(Zip4jUtil.dosToExtendedEpochTme(l2));
    }

    public static byte[] getFileAttributes(File file) {
        try {
            if (file == null || !Files.isSymbolicLink(file.toPath()) && !file.exists()) {
                return new byte[4];
            }
            Path path = file.toPath();
            if (FileUtils.isWindows()) {
                return FileUtils.getWindowsFileAttributes(path);
            }
            if (FileUtils.isMac() || FileUtils.isUnix()) {
                return FileUtils.getPosixFileAttributes(path);
            }
            return new byte[4];
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return new byte[4];
        }
    }

    public static List<File> getFilesInDirectoryRecursive(File file, boolean bl2, boolean bl3) {
        return FileUtils.getFilesInDirectoryRecursive(file, bl2, bl3, null);
    }

    public static List<File> getFilesInDirectoryRecursive(File file, boolean bl2, boolean bl3, ExcludeFileFilter excludeFileFilter) {
        if (file == null) {
            throw new ZipException("input path is null, cannot read files in the directory");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (!file.isDirectory() || !file.canRead() || fileArray == null) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            if (excludeFileFilter != null && excludeFileFilter.isExcluded(file2) || file2.isHidden() && (file2.isDirectory() ? !bl3 : !bl2)) continue;
            arrayList.add(file2);
            if (!file2.isDirectory()) continue;
            arrayList.addAll(FileUtils.getFilesInDirectoryRecursive(file2, bl2, bl3, excludeFileFilter));
        }
        return arrayList;
    }

    public static String getFileNameWithoutExtension(String string) {
        int n2 = string.lastIndexOf(".");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String getZipFileNameWithoutExtension(String string) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("zip file name is empty or null, cannot determine zip file name");
        }
        String string2 = string;
        if (string.contains(System.getProperty("file.separator"))) {
            string2 = string.substring(string.lastIndexOf(System.getProperty("file.separator")) + 1);
        }
        if (string2.endsWith(".zip")) {
            string2 = string2.substring(0, string2.lastIndexOf("."));
        }
        return string2;
    }

    public static List<File> getSplitZipFiles(ZipModel zipModel) {
        if (zipModel == null) {
            throw new ZipException("cannot get split zip files: zipmodel is null");
        }
        if (zipModel.getEndOfCentralDirectoryRecord() == null) {
            return null;
        }
        if (!zipModel.getZipFile().exists()) {
            throw new ZipException("zip file does not exist");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = zipModel.getZipFile();
        if (!zipModel.isSplitArchive()) {
            arrayList.add(file);
            return arrayList;
        }
        int n2 = zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk();
        if (n2 == 0) {
            arrayList.add(file);
            return arrayList;
        }
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 == n2) {
                arrayList.add(zipModel.getZipFile());
                continue;
            }
            String string = ".z0";
            if (i2 >= 9) {
                string = ".z";
            }
            String string2 = file.getName().contains(".") ? file.getPath().substring(0, file.getPath().lastIndexOf(".")) : file.getPath();
            string2 = string2 + string + (i2 + 1);
            arrayList.add(new File(string2));
        }
        return arrayList;
    }

    public static String getRelativeFileName(File file, ZipParameters zipParameters) {
        String string;
        Object object;
        String string2;
        try {
            string2 = file.getCanonicalPath();
            if (Zip4jUtil.isStringNotNullAndNotEmpty(zipParameters.getDefaultFolderPath())) {
                String string3;
                Object object2;
                object = new File(zipParameters.getDefaultFolderPath());
                String string4 = ((File)object).getCanonicalPath();
                if (!string4.endsWith(InternalZipConstants.FILE_SEPARATOR)) {
                    string4 = string4 + InternalZipConstants.FILE_SEPARATOR;
                }
                if (FileUtils.isSymbolicLink(file)) {
                    object2 = new File(file.getParentFile().getCanonicalFile().getPath() + File.separator + file.getCanonicalFile().getName()).getPath();
                    string3 = ((String)object2).substring(string4.length());
                } else {
                    string3 = string2.substring(string4.length());
                }
                if (string3.startsWith(System.getProperty("file.separator"))) {
                    string3 = string3.substring(1);
                }
                if (((File)(object2 = new File(string2))).isDirectory()) {
                    string3 = string3.replaceAll("\\\\", "/");
                    string3 = string3 + "/";
                } else {
                    String string5 = string3.substring(0, string3.lastIndexOf(((File)object2).getName()));
                    string5 = string5.replaceAll("\\\\", "/");
                    string3 = string5 + FileUtils.getNameOfFileInZip((File)object2, zipParameters.getFileNameInZip());
                }
                string = string3;
            } else {
                object = new File(string2);
                string = FileUtils.getNameOfFileInZip((File)object, zipParameters.getFileNameInZip());
                if (((File)object).isDirectory()) {
                    string = string + "/";
                }
            }
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
        string2 = zipParameters.getRootFolderNameInZip();
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            if (!string2.endsWith("\\") && !string2.endsWith("/")) {
                string2 = string2 + InternalZipConstants.FILE_SEPARATOR;
            }
            string2 = string2.replaceAll("\\\\", "/");
            string = string2 + string;
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            object = "fileName to add to zip is empty or null. fileName: '" + string + "' DefaultFolderPath: '" + zipParameters.getDefaultFolderPath() + "' FileNameInZip: " + zipParameters.getFileNameInZip();
            if (FileUtils.isSymbolicLink(file)) {
                object = (String)object + "isSymlink: true ";
            }
            if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
                object = "rootFolderNameInZip: '" + string2 + "' ";
            }
            throw new ZipException((String)object);
        }
        return string;
    }

    private static String getNameOfFileInZip(File file, String string) {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            return string;
        }
        if (FileUtils.isSymbolicLink(file)) {
            return file.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString();
        }
        return file.getName();
    }

    public static boolean isZipEntryDirectory(String string) {
        return string.endsWith("/") || string.endsWith("\\");
    }

    public static void copyFile(RandomAccessFile randomAccessFile, OutputStream outputStream, long l2, long l3, ProgressMonitor progressMonitor, int n2) {
        if (l2 < 0L || l3 < 0L || l2 > l3) {
            throw new ZipException("invalid offsets");
        }
        if (l2 == l3) {
            return;
        }
        try {
            int n3;
            randomAccessFile.seek(l2);
            long l4 = 0L;
            long l5 = l3 - l2;
            byte[] byArray = l3 - l2 < (long)n2 ? new byte[(int)l5] : new byte[n2];
            while ((n3 = randomAccessFile.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n3);
                progressMonitor.updateWorkCompleted(n3);
                if (progressMonitor.isCancelAllTasks()) {
                    progressMonitor.setResult(ProgressMonitor.Result.CANCELLED);
                    return;
                }
                if ((l4 += (long)n3) != l5) {
                    if (l4 + (long)byArray.length <= l5) continue;
                    byArray = new byte[(int)(l5 - l4)];
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    public static void assertFilesExist(List<File> list, ZipParameters.SymbolicLinkAction symbolicLinkAction) {
        for (File file : list) {
            if (FileUtils.isSymbolicLink(file)) {
                if (!symbolicLinkAction.equals((Object)ZipParameters.SymbolicLinkAction.INCLUDE_LINK_AND_LINKED_FILE) && !symbolicLinkAction.equals((Object)ZipParameters.SymbolicLinkAction.INCLUDE_LINKED_FILE_ONLY)) continue;
                FileUtils.assertSymbolicLinkTargetExists(file);
                continue;
            }
            FileUtils.assertFileExists(file);
        }
    }

    public static boolean isNumberedSplitFile(File file) {
        return file.getName().endsWith(".zip.001");
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        if (!string.contains(".")) {
            return "";
        }
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static File[] getAllSortedNumberedSplitFiles(File file2) {
        String string = FileUtils.getFileNameWithoutExtension(file2.getName());
        Object[] objectArray = file2.getParentFile().listFiles((file, string2) -> string2.startsWith(string + "."));
        if (objectArray == null) {
            return new File[0];
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static String getNextNumberedSplitFileCounterAsExtension(int n2) {
        return "." + FileUtils.getExtensionZerosPrefix(n2) + (n2 + 1);
    }

    public static boolean isSymbolicLink(File file) {
        try {
            return Files.isSymbolicLink(file.toPath());
        }
        catch (Error | Exception throwable) {
            return false;
        }
    }

    public static String readSymbolicLink(File file) {
        try {
            return Files.readSymbolicLink(file.toPath()).toString();
        }
        catch (Error | Exception throwable) {
            return "";
        }
    }

    public static byte[] getDefaultFileAttributes(boolean bl2) {
        byte[] byArray = new byte[4];
        if (FileUtils.isUnix() || FileUtils.isMac()) {
            if (bl2) {
                System.arraycopy(DEFAULT_POSIX_FOLDER_ATTRIBUTES, 0, byArray, 0, byArray.length);
            } else {
                System.arraycopy(DEFAULT_POSIX_FILE_ATTRIBUTES, 0, byArray, 0, byArray.length);
            }
        } else if (FileUtils.isWindows() && bl2) {
            byArray[0] = BitUtils.setBit(byArray[0], 4);
        }
        return byArray;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.contains("win");
    }

    public static boolean isMac() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.contains("mac");
    }

    public static boolean isUnix() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.contains("nux");
    }

    private static String getExtensionZerosPrefix(int n2) {
        if (n2 < 9) {
            return "00";
        }
        if (n2 < 99) {
            return "0";
        }
        return "";
    }

    private static void applyWindowsFileAttributes(Path path, byte[] byArray) {
        if (byArray[0] == 0) {
            return;
        }
        DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            dosFileAttributeView.setReadOnly(BitUtils.isBitSet(byArray[0], 0));
            dosFileAttributeView.setHidden(BitUtils.isBitSet(byArray[0], 1));
            dosFileAttributeView.setSystem(BitUtils.isBitSet(byArray[0], 2));
            dosFileAttributeView.setArchive(BitUtils.isBitSet(byArray[0], 5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void applyPosixFileAttributes(Path path, byte[] byArray) {
        if (byArray[2] == 0 && byArray[3] == 0) {
            return;
        }
        try {
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
            FileUtils.addIfBitSet(byArray[3], 0, hashSet, PosixFilePermission.OWNER_READ);
            FileUtils.addIfBitSet(byArray[2], 7, hashSet, PosixFilePermission.OWNER_WRITE);
            FileUtils.addIfBitSet(byArray[2], 6, hashSet, PosixFilePermission.OWNER_EXECUTE);
            FileUtils.addIfBitSet(byArray[2], 5, hashSet, PosixFilePermission.GROUP_READ);
            FileUtils.addIfBitSet(byArray[2], 4, hashSet, PosixFilePermission.GROUP_WRITE);
            FileUtils.addIfBitSet(byArray[2], 3, hashSet, PosixFilePermission.GROUP_EXECUTE);
            FileUtils.addIfBitSet(byArray[2], 2, hashSet, PosixFilePermission.OTHERS_READ);
            FileUtils.addIfBitSet(byArray[2], 1, hashSet, PosixFilePermission.OTHERS_WRITE);
            FileUtils.addIfBitSet(byArray[2], 0, hashSet, PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(path, hashSet);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static byte[] getWindowsFileAttributes(Path path) {
        byte[] byArray = new byte[4];
        try {
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            DosFileAttributes dosFileAttributes = dosFileAttributeView.readAttributes();
            byte by2 = 0;
            by2 = FileUtils.setBitIfApplicable(dosFileAttributes.isReadOnly(), by2, 0);
            by2 = FileUtils.setBitIfApplicable(dosFileAttributes.isHidden(), by2, 1);
            by2 = FileUtils.setBitIfApplicable(dosFileAttributes.isSystem(), by2, 2);
            by2 = FileUtils.setBitIfApplicable(dosFileAttributes.isDirectory(), by2, 4);
            byArray[0] = by2 = FileUtils.setBitIfApplicable(dosFileAttributes.isArchive(), by2, 5);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    private static void assertFileExists(File file) {
        if (!file.exists()) {
            throw new ZipException("File does not exist: " + file);
        }
    }

    private static void assertSymbolicLinkTargetExists(File file) {
        if (!file.exists()) {
            throw new ZipException("Symlink target '" + FileUtils.readSymbolicLink(file) + "' does not exist for link '" + file + "'");
        }
    }

    private static byte[] getPosixFileAttributes(Path path) {
        byte[] byArray = new byte[4];
        try {
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            Set<PosixFilePermission> set = posixFileAttributeView.readAttributes().permissions();
            byArray[3] = FileUtils.setBitIfApplicable(Files.isRegularFile(path, new LinkOption[0]), byArray[3], 7);
            byArray[3] = FileUtils.setBitIfApplicable(Files.isDirectory(path, new LinkOption[0]), byArray[3], 6);
            byArray[3] = FileUtils.setBitIfApplicable(Files.isSymbolicLink(path), byArray[3], 5);
            byArray[3] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OWNER_READ), byArray[3], 0);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OWNER_WRITE), byArray[2], 7);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OWNER_EXECUTE), byArray[2], 6);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.GROUP_READ), byArray[2], 5);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.GROUP_WRITE), byArray[2], 4);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.GROUP_EXECUTE), byArray[2], 3);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OTHERS_READ), byArray[2], 2);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OTHERS_WRITE), byArray[2], 1);
            byArray[2] = FileUtils.setBitIfApplicable(set.contains((Object)PosixFilePermission.OTHERS_EXECUTE), byArray[2], 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    private static byte setBitIfApplicable(boolean bl2, byte by2, int n2) {
        if (bl2) {
            by2 = BitUtils.setBit(by2, n2);
        }
        return by2;
    }

    private static void addIfBitSet(byte by2, int n2, Set<PosixFilePermission> set, PosixFilePermission posixFilePermission) {
        if (BitUtils.isBitSet(by2, n2)) {
            set.add(posixFilePermission);
        }
    }
}

