/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ClassTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

class TransformerClassWriter
extends ClassWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<String, String> classParents = new HashMap();
    private static final HashMap<String, Set<String>> classHierarchies = new HashMap();
    private static final HashMap<String, Boolean> isInterface = new HashMap();
    private ClassTransformer classTransformer;
    private final ClassNode clazzAccessor;

    public TransformerClassWriter(ClassTransformer classTransformer, ClassNode clazzAccessor) {
        super(458754);
        this.classTransformer = classTransformer;
        this.clazzAccessor = clazzAccessor;
        if (!classParents.containsKey(clazzAccessor.name)) {
            this.computeHierarchy(clazzAccessor);
        }
    }

    private Set<String> getSupers(String typeName) {
        if (!classParents.containsKey(typeName)) {
            this.computeHierarchy(typeName, this.classTransformer);
        }
        return classHierarchies.get(typeName);
    }

    private boolean isIntf(String typeName) {
        if (!classParents.containsKey(typeName)) {
            this.computeHierarchy(typeName, this.classTransformer);
        }
        return isInterface.get(typeName);
    }

    private String getSuper(String typeName) {
        if (!classParents.containsKey(typeName)) {
            this.computeHierarchy(typeName, this.classTransformer);
        }
        return classParents.get(typeName);
    }

    private void computeHierarchy(ClassNode clazzNode) {
        clazzNode.accept((ClassVisitor)new SuperCollectingVisitor(this.classTransformer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeHierarchy(String className, ClassTransformer classTransformer) {
        String target = className.replace('.', '/').concat(".class");
        InputStream resource = null;
        try {
            resource = classTransformer.getTransformingClassLoader().getResourceAsStream(target);
            ClassReader classReader = new ClassReader(resource);
            classReader.accept((ClassVisitor)new SuperCollectingVisitor(classTransformer), 7);
        }
        catch (IOException e) {
            LOGGER.fatal("Class {} unable to find resource {}", (Object)className, (Object)resource);
            throw new RuntimeException("Failed to load hierarchy member " + className, e);
        }
        catch (NullPointerException e) {
            classParents.put(className, "java/lang/Object");
            classHierarchies.put(className, Stream.of(className, "java/lang/Object").collect(Collectors.toSet()));
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (this.getSupers(type2).contains(type1)) {
            return type1;
        }
        if (this.getSupers(type1).contains(type2)) {
            return type2;
        }
        if (this.isIntf(type1) || this.isIntf(type2)) {
            return "java/lang/Object";
        }
        String type = type1;
        do {
            type = this.getSuper(type);
        } while (!this.getSupers(type2).contains(type));
        return type;
    }

    private class SuperCollectingVisitor
    extends ClassVisitor {
        private final ClassTransformer classTransformer;

        public SuperCollectingVisitor(ClassTransformer classTransformer) {
            super(458752);
            this.classTransformer = classTransformer;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            classParents.put(name, superName);
            if (superName != null) {
                TransformerClassWriter.this.computeHierarchy(superName, this.classTransformer);
                classHierarchies.put(name, Stream.concat(Stream.of(name), ((Set)classHierarchies.get(superName)).stream()).collect(Collectors.toSet()));
            } else {
                classHierarchies.put(name, Collections.singleton("java/lang/Object"));
            }
            isInterface.put(name, (access & 0x200) != 0);
            Arrays.stream(interfaces).forEach(n -> {
                TransformerClassWriter.this.computeHierarchy(n, this.classTransformer);
                ((Set)classHierarchies.get(name)).add(n);
                ((Set)classHierarchies.get(name)).addAll((Collection)classHierarchies.get(n));
            });
        }
    }
}

