/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.base.Preconditions;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.UnsortedRemappingMethodAdapter;
import net.md_5.specialsource.repo.ClassRepo;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.FieldRemapper;
import org.objectweb.asm.commons.Remapper;

public class RemappingClassAdapter
extends ClassRemapper {
    protected final CustomRemapper remapper;
    protected ClassRepo repo;

    public RemappingClassAdapter(ClassVisitor cv, CustomRemapper remapper, ClassRepo repo) {
        super(cv, (Remapper)remapper);
        Preconditions.checkArgument((cv != null ? 1 : 0) != 0, (Object)"cv");
        this.repo = repo;
        this.remapper = remapper;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String newDesc = this.remapper.mapMethodDesc(desc);
        MethodVisitor mv = this.cv.visitMethod(access, this.remapper.mapMethodName(this.className, name, desc, access), newDesc, this.remapper.mapSignature(signature, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return mv == null ? null : this.createMethodRemapper(mv);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fv = this.cv.visitField(access, this.remapper.mapFieldName(this.className, name, desc, access), this.remapper.mapDesc(desc), this.remapper.mapSignature(signature, true), this.remapper.mapValue(value));
        return fv == null ? null : this.createFieldRemapper(fv);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String newName = this.remapper.mapType(name);
        this.cv.visitInnerClass(newName, outerName == null ? null : this.remapper.mapType(outerName), innerName == null ? null : newName.substring(newName.lastIndexOf(newName.contains("$") ? 36 : 47) + 1), access);
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fv) {
        return new FieldRemapper(fv, this.remapper){

            public void visitAttribute(Attribute attr) {
                if (SpecialSource.kill_lvt && attr.type.equals("LocalVariableTable")) {
                    return;
                }
                if (SpecialSource.kill_generics && attr.type.equals("LocalVariableTypeTable")) {
                    return;
                }
                super.visitAttribute(attr);
            }
        };
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor mv) {
        return new UnsortedRemappingMethodAdapter(mv, this.remapper, this.repo){

            public void visitAttribute(Attribute attr) {
                if (SpecialSource.kill_lvt && attr.type.equals("LocalVariableTable")) {
                    return;
                }
                if (SpecialSource.kill_generics && attr.type.equals("LocalVariableTypeTable")) {
                    return;
                }
                super.visitAttribute(attr);
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                if (!SpecialSource.kill_lvt) {
                    super.visitLocalVariable(name, desc, signature, start, end, index);
                }
            }
        };
    }

    public void visitSource(String source, String debug) {
        if (!SpecialSource.kill_source) {
            super.visitSource(source, debug);
        }
    }

    public void visitAttribute(Attribute attr) {
        if (SpecialSource.kill_generics && attr.type.equals("Signature")) {
            return;
        }
        super.visitAttribute(attr);
    }
}

