/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.BackgroundScanHandler;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.coremod.ICoreModProvider;

public class LoadingModList {
    private static LoadingModList INSTANCE;
    private final List<ModFileInfo> modFiles;
    private final List<ModInfo> sortedList;
    private final Map<String, ModFileInfo> fileById;
    private BackgroundScanHandler scanner;
    private final List<EarlyLoadingException> preLoadErrors;
    private List<ModFile> brokenFiles;

    private LoadingModList(List<ModFile> modFiles, List<ModInfo> sortedList) {
        this.modFiles = modFiles.stream().map(ModFile::getModFileInfo).map(ModFileInfo.class::cast).collect(Collectors.toList());
        this.sortedList = sortedList.stream().map(ModInfo.class::cast).collect(Collectors.toList());
        this.fileById = this.modFiles.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toMap(ModInfo::getModId, ModInfo::getOwningFile));
        this.preLoadErrors = new ArrayList<EarlyLoadingException>();
    }

    public static LoadingModList of(List<ModFile> modFiles, List<ModInfo> sortedList, EarlyLoadingException earlyLoadingException) {
        INSTANCE = new LoadingModList(modFiles, sortedList);
        if (earlyLoadingException != null) {
            LoadingModList.INSTANCE.preLoadErrors.add(earlyLoadingException);
        }
        return INSTANCE;
    }

    public static LoadingModList get() {
        return INSTANCE;
    }

    public void addCoreMods() {
        this.modFiles.stream().map(ModFileInfo::getFile).map(ModFile::getCoreMods).flatMap(Collection::stream).forEach(arg_0 -> ((ICoreModProvider)FMLLoader.getCoreModProvider()).addCoreMod(arg_0));
    }

    public void addAccessTransformers() {
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(mod -> mod.getAccessTransformer().ifPresent(path -> FMLLoader.addAccessTransformer(path, mod)));
    }

    public void addForScanning(BackgroundScanHandler backgroundScanHandler) {
        this.scanner = backgroundScanHandler;
        backgroundScanHandler.setLoadingModList(this);
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(backgroundScanHandler::submitForScanning);
    }

    public List<ModFileInfo> getModFiles() {
        return this.modFiles;
    }

    public Path findResource(String className) {
        for (ModFileInfo mf : this.modFiles) {
            Path resource = mf.getFile().findResource(className);
            if (!Files.exists(resource, new LinkOption[0])) continue;
            return resource;
        }
        return null;
    }

    public URL findURLForResource(String resourceName) {
        for (ModFileInfo mf : this.modFiles) {
            Path resource;
            if (resourceName.startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            if (!Files.exists(resource = mf.getFile().findResource(resourceName), new LinkOption[0])) continue;
            try {
                return new URL("modjar://" + mf.getMods().get(0).getModId() + "/" + resourceName);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public ModFileInfo getModFileById(String modid) {
        return this.fileById.get(modid);
    }

    public List<ModInfo> getMods() {
        return this.sortedList;
    }

    public List<EarlyLoadingException> getErrors() {
        return this.preLoadErrors;
    }

    public void setBrokenFiles(List<ModFile> brokenFiles) {
        this.brokenFiles = brokenFiles;
    }

    public List<ModFile> getBrokenFiles() {
        return this.brokenFiles;
    }
}

