/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModClassVisitor;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;

public class Scanner {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ModFile fileToScan;

    public Scanner(ModFile fileToScan) {
        this.fileToScan = fileToScan;
    }

    public ModFileScanData scan() {
        ModFileScanData result = new ModFileScanData();
        result.addModFileInfo(this.fileToScan.getModFileInfo());
        this.fileToScan.scanFile(p -> this.fileVisitor((Path)p, result));
        IModLanguageProvider loader = this.fileToScan.getLoader();
        if (loader != null) {
            LOGGER.debug(LogMarkers.SCAN, "Scanning {} with language loader {}", (Object)this.fileToScan.getFilePath(), (Object)loader.name());
            loader.getFileVisitor().accept(result);
        }
        return result;
    }

    private void fileVisitor(Path path, ModFileScanData result) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning {} path {}", (Object)this.fileToScan, (Object)path);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            ModClassVisitor mcv = new ModClassVisitor();
            ClassReader cr = new ClassReader(in);
            cr.accept(mcv, 0);
            mcv.buildData(result.getClasses(), result.getAnnotations());
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
    }
}

