/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.binarypatcher;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TimeZone;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.binarypatcher.Generator;
import net.minecraftforge.binarypatcher.Patcher;

public class ConsoleTool {
    public static final long ZIPTIME = 628041600000L;

    public static void main(String[] args) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec clean = parser.accepts("clean").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec output = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec create = parser.accepts("create").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec patches = parser.accepts("patches").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec srg = parser.accepts("srg").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec apply = parser.accepts("apply").withRequiredArg().ofType(File.class);
        OptionSpecBuilder data = parser.accepts("data");
        OptionSpecBuilder unpatched = parser.accepts("unpatched");
        try {
            OptionSet options = parser.parse(args);
            File clean_jar = (File)options.valueOf((OptionSpec)clean);
            File output_jar = ((File)options.valueOf((OptionSpec)output)).getAbsoluteFile();
            if (output_jar.exists() && !output_jar.delete()) {
                System.out.println("Could not delete output file: " + output_jar);
                return;
            }
            if (!output_jar.getParentFile().exists() && !output_jar.getParentFile().mkdirs()) {
                System.out.println("Could not make output folders: " + output_jar.getParentFile());
                return;
            }
            if (options.has((OptionSpec)create) && options.has((OptionSpec)apply)) {
                System.out.println("Cannot specify --apply and --create at the same time!");
                return;
            }
            if (options.has((OptionSpec)create)) {
                if (options.has((OptionSpec)data)) {
                    System.out.println("Connot specify --data and --create at the same time!");
                    return;
                }
                if (options.has((OptionSpec)unpatched)) {
                    System.out.println("Connot specify --unpatched and --create at the same time!");
                    return;
                }
                File dirty_jar = (File)options.valueOf((OptionSpec)create);
                Generator gen = new Generator(clean_jar, dirty_jar, output_jar);
                ConsoleTool.log("Generating: ");
                ConsoleTool.log("  Clean:   " + clean_jar);
                ConsoleTool.log("  Dirty:   " + dirty_jar);
                ConsoleTool.log("  Output:  " + output_jar);
                if (options.has((OptionSpec)patches)) {
                    for (File dir : options.valuesOf((OptionSpec)patches)) {
                        ConsoleTool.log("  Patches: " + dir);
                        gen.loadPatches(dir);
                    }
                }
                if (options.has((OptionSpec)srg)) {
                    for (File file : options.valuesOf((OptionSpec)srg)) {
                        ConsoleTool.log("  SRG:     " + file);
                        gen.loadMappings(file);
                    }
                }
                gen.create();
            } else if (options.has((OptionSpec)apply)) {
                if (options.has((OptionSpec)srg)) {
                    System.out.println("Connot specify --srg and --apply at the same time!");
                    return;
                }
                if (options.has((OptionSpec)patches)) {
                    System.out.println("Connot specify --patches and --apply at the same time!");
                    return;
                }
                Patcher patcher = new Patcher(clean_jar, output_jar);
                ConsoleTool.log("Applying: ");
                ConsoleTool.log("  Clean:     " + clean_jar);
                ConsoleTool.log("  Output:    " + output_jar);
                ConsoleTool.log("  KeepData:  " + options.has((OptionSpec)data));
                patcher.keepData(options.has((OptionSpec)data));
                ConsoleTool.log("  Unpatched: " + options.has((OptionSpec)unpatched));
                patcher.includeUnpatched(options.has((OptionSpec)unpatched));
                for (File file : options.valuesOf((OptionSpec)apply)) {
                    ConsoleTool.log("  Patches:   " + file);
                    patcher.loadPatches(file);
                }
                patcher.process();
            } else {
                parser.printHelpOn((OutputStream)System.out);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    public static void log(String message) {
        System.out.println(message);
    }
}

