/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.asm;

import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import io.izzel.arclight.common.asm.AsyncCatcher;
import io.izzel.arclight.common.asm.EntityTypePatcher;
import io.izzel.arclight.common.asm.Implementer;
import io.izzel.arclight.common.asm.InventoryImplementer;
import io.izzel.arclight.common.asm.SwitchTableFixer;
import io.izzel.arclight.common.mod.util.log.ArclightI18nLogger;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ArclightImplementer
implements ILaunchPluginService {
    static final Logger LOGGER = ArclightI18nLogger.getLogger("Implementer");
    private static final EnumSet<ILaunchPluginService.Phase> OH_YES_SIR = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NOT_TODAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    private final Map<String, Implementer> implementers = new HashMap<String, Implementer>();
    private volatile Consumer<String[]> auditAcceptor;
    private ILaunchPluginService.ITransformerLoader transformerLoader;

    public String name() {
        return "arclight_implementer";
    }

    public void initializeLaunch(ILaunchPluginService.ITransformerLoader transformerLoader, Path[] specialPaths) {
        this.transformerLoader = transformerLoader;
        this.implementers.put("inventory", new InventoryImplementer());
        this.implementers.put("switch", SwitchTableFixer.INSTANCE);
        this.implementers.put("async", AsyncCatcher.INSTANCE);
        this.implementers.put("entitytype", EntityTypePatcher.INSTANCE);
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty, String reason) {
        if ("mixin".equals(reason)) {
            return NOT_TODAY;
        }
        return isEmpty ? NOT_TODAY : OH_YES_SIR;
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        throw new IllegalStateException("Outdated ModLauncher");
    }

    public void customAuditConsumer(String className, Consumer<String[]> auditDataAcceptor) {
        this.auditAcceptor = auditDataAcceptor;
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        if ("mixin".equals(reason)) {
            return false;
        }
        ArrayList<String> trails = new ArrayList<String>();
        for (Map.Entry<String, Implementer> entry : this.implementers.entrySet()) {
            String key = entry.getKey();
            Implementer implementer = entry.getValue();
            if (!implementer.processClass(classNode, this.transformerLoader)) continue;
            trails.add(key);
        }
        if (this.auditAcceptor != null && !trails.isEmpty()) {
            this.auditAcceptor.accept(new String[]{String.join((CharSequence)",", trails)});
        }
        return !trails.isEmpty();
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType) {
        throw new IllegalStateException("Outdated ModLauncher");
    }

    public static void loadArgs(InsnList list, MethodNode methodNode, Type[] types, int i) {
        if (!Modifier.isStatic(methodNode.access)) {
            list.add((AbstractInsnNode)new VarInsnNode(25, i));
            ++i;
        }
        for (Type type : types) {
            list.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), i));
            i += type.getSize();
        }
    }
}

