/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import io.izzel.arclight.common.mod.server.entity.ArclightFakePlayer;
import io.izzel.arclight.common.mod.server.entity.ArclightModChestedHorse;
import io.izzel.arclight.common.mod.server.entity.ArclightModEntity;
import io.izzel.arclight.common.mod.server.entity.ArclightModHorse;
import io.izzel.arclight.common.mod.server.entity.ArclightModLivingEntity;
import io.izzel.arclight.common.mod.server.entity.ArclightModMinecart;
import io.izzel.arclight.common.mod.server.entity.ArclightModMinecartContainer;
import io.izzel.arclight.common.mod.server.entity.ArclightModMob;
import io.izzel.arclight.common.mod.server.entity.ArclightModProjectile;
import io.izzel.arclight.common.mod.server.entity.ArclightModRaider;
import io.izzel.arclight.common.mod.util.ResourceLocationUtil;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftAgeable;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftFlying;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftGolem;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftTameableAnimal;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftEntity.class}, remap=false)
public abstract class CraftEntityMixin
implements org.bukkit.entity.Entity {
    @Shadow
    protected Entity entity;
    private EntityType arclight$type;

    @Override
    @NotNull
    public EntityType getType() {
        if (this.arclight$type == null) {
            ResourceLocation location = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)this.entity.func_200600_R());
            if (location == null) {
                throw new IllegalArgumentException("Unregistered entity type " + this.entity.func_200600_R());
            }
            this.arclight$type = location.func_110624_b().equals("minecraft") ? Objects.requireNonNull(EntityType.fromName(location.func_110623_a().toUpperCase(Locale.ROOT))) : EntityType.valueOf(ResourceLocationUtil.standardize(location));
        }
        return this.arclight$type;
    }

    @Inject(method={"getEntity"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$fakePlayer(CraftServer server, Entity entity, CallbackInfoReturnable<CraftEntity> cir) {
        if (entity instanceof FakePlayer) {
            cir.setReturnValue((Object)new ArclightFakePlayer(server, (ServerPlayerEntity)((FakePlayer)entity)));
        }
    }

    @Inject(method={"getEntity"}, cancellable=true, at={@At(value="NEW", target="java/lang/AssertionError")})
    private static void arclight$modEntity(CraftServer server, Entity entity, CallbackInfoReturnable<CraftEntity> cir) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof MobEntity) {
                if (entity instanceof AgeableEntity) {
                    if (entity instanceof AbstractHorseEntity) {
                        if (entity instanceof AbstractChestedHorseEntity) {
                            cir.setReturnValue((Object)new ArclightModChestedHorse(server, (AbstractChestedHorseEntity)entity));
                            return;
                        }
                        cir.setReturnValue((Object)new ArclightModHorse(server, (AbstractHorseEntity)entity));
                        return;
                    }
                    if (entity instanceof TameableEntity) {
                        cir.setReturnValue((Object)new CraftTameableAnimal(server, (TameableEntity)entity));
                        return;
                    }
                    cir.setReturnValue((Object)new CraftAgeable(server, (AgeableEntity)entity));
                    return;
                }
                if (entity instanceof FlyingEntity) {
                    cir.setReturnValue((Object)new CraftFlying(server, (FlyingEntity)entity));
                    return;
                }
                if (entity instanceof AbstractRaiderEntity) {
                    cir.setReturnValue((Object)new ArclightModRaider(server, (AbstractRaiderEntity)entity));
                    return;
                }
                if (entity instanceof GolemEntity) {
                    cir.setReturnValue((Object)new CraftGolem(server, (GolemEntity)entity));
                    return;
                }
                cir.setReturnValue((Object)new ArclightModMob(server, (MobEntity)entity));
                return;
            }
            cir.setReturnValue((Object)new ArclightModLivingEntity(server, (LivingEntity)entity));
            return;
        }
        if (entity instanceof AbstractMinecartEntity) {
            if (entity instanceof ContainerMinecartEntity) {
                cir.setReturnValue((Object)new ArclightModMinecartContainer(server, (ContainerMinecartEntity)entity));
                return;
            }
            cir.setReturnValue((Object)new ArclightModMinecart(server, (AbstractMinecartEntity)entity));
            return;
        }
        if (entity instanceof ThrowableEntity) {
            cir.setReturnValue((Object)new ArclightModProjectile(server, entity));
            return;
        }
        cir.setReturnValue((Object)new ArclightModEntity(server, entity));
    }
}

