/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import io.izzel.arclight.common.bridge.bukkit.CraftItemStackBridge;
import io.izzel.arclight.common.bridge.bukkit.ItemMetaBridge;
import io.izzel.arclight.common.bridge.item.ItemStackBridge;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.legacy.CraftLegacy;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftItemStack.class}, remap=false)
public abstract class CraftItemStackMixin
implements CraftItemStackBridge {
    @Shadow
    net.minecraft.item.ItemStack handle;

    @Shadow
    public abstract Material getType();

    @Shadow
    public abstract short getDurability();

    @Shadow
    public abstract boolean hasItemMeta();

    @Inject(method={"getItemMeta(Lnet/minecraft/item/ItemStack;)Lorg/bukkit/inventory/meta/ItemMeta;"}, at={@At(value="RETURN")})
    private static void arclight$offerCaps(net.minecraft.item.ItemStack item, CallbackInfoReturnable<ItemMeta> cir) {
        if (item == null) {
            return;
        }
        ItemMeta meta = (ItemMeta)cir.getReturnValue();
        CompoundNBT tag = item.func_77978_p();
        if (tag != null) {
            ((ItemMetaBridge)((Object)meta)).bridge$offerUnhandledTags(tag);
        }
        ((ItemMetaBridge)((Object)meta)).bridge$setForgeCaps(((ItemStackBridge)item).bridge$getForgeCaps());
    }

    @Inject(method={"setItemMeta(Lnet/minecraft/item/ItemStack;Lorg/bukkit/inventory/meta/ItemMeta;)Z"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/item/ItemStack;func_77973_b()Lnet/minecraft/item/Item;")})
    private static void arclight$setCaps(net.minecraft.item.ItemStack item, ItemMeta itemMeta, CallbackInfoReturnable<Boolean> cir) {
        CompoundNBT forgeCaps = ((ItemMetaBridge)((Object)itemMeta)).bridge$getForgeCaps();
        if (forgeCaps != null) {
            ((ItemStackBridge)item).bridge$setForgeCaps(forgeCaps.func_74737_b());
        }
    }

    @Overwrite
    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar((ItemStack)((Object)this));
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == ((CraftItemStackBridge)((Object)that)).bridge$getHandle()) {
            return true;
        }
        if (this.handle == null || ((CraftItemStackBridge)((Object)that)).bridge$getHandle() == null) {
            return false;
        }
        Material comparisonType = CraftLegacy.fromLegacy(that.getType());
        if (comparisonType != this.getType() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && Objects.equals(this.handle.func_77978_p(), ((CraftItemStackBridge)((Object)that)).bridge$getHandle().func_77978_p()) && Objects.equals(((ItemStackBridge)this.handle).bridge$getForgeCaps(), ((ItemStackBridge)((CraftItemStackBridge)((Object)that)).bridge$getHandle()).bridge$getForgeCaps()) : !that.hasItemMeta();
    }

    @Inject(method={"hasItemMeta(Lnet/minecraft/item/ItemStack;)Z"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$hasMeta(net.minecraft.item.ItemStack item, CallbackInfoReturnable<Boolean> cir) {
        CompoundNBT forgeCaps;
        if (item != null && (forgeCaps = ((ItemStackBridge)item).bridge$getForgeCaps()) != null && !forgeCaps.isEmpty()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public net.minecraft.item.ItemStack bridge$getHandle() {
        return this.handle;
    }
}

