/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import com.google.common.io.ByteStreams;
import io.izzel.arclight.common.asm.SwitchTableFixer;
import io.izzel.arclight.common.bridge.bukkit.JavaPluginLoaderBridge;
import io.izzel.arclight.common.mod.util.remapper.ArclightRemapper;
import io.izzel.arclight.common.mod.util.remapper.ClassLoaderRemapper;
import io.izzel.arclight.common.mod.util.remapper.RemappingClassLoader;
import io.izzel.tools.product.Product2;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.jar.Manifest;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(targets={"org.bukkit.plugin.java.PluginClassLoader"}, remap=false)
public class PluginClassLoaderMixin
extends URLClassLoader
implements RemappingClassLoader {
    @Shadow
    @Final
    private Map<String, Class<?>> classes;
    @Shadow
    @Final
    private JavaPluginLoader loader;
    @Shadow
    @Final
    private PluginDescriptionFile description;
    @Shadow
    @Final
    private Manifest manifest;
    @Shadow
    @Final
    private URL url;
    private ClassLoaderRemapper remapper;

    @Override
    public ClassLoaderRemapper getRemapper() {
        if (this.remapper == null) {
            this.remapper = ArclightRemapper.createClassLoaderRemapper(this);
        }
        return this.remapper;
    }

    public PluginClassLoaderMixin(URL[] urls) {
        super(urls);
    }

    @Overwrite
    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (name.startsWith("org.bukkit.") || name.startsWith("net.minecraft.")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        if (result == null) {
            if (checkGlobal) {
                result = ((JavaPluginLoaderBridge)((Object)this.loader)).bridge$getClassByName(name);
            }
            if (result == null) {
                String path = name.replace('.', '/').concat(".class");
                URL url = this.findResource(path);
                if (url != null) {
                    Product2<byte[], CodeSource> classBytes;
                    block14: {
                        String pkgName;
                        Callable<byte[]> byteSource;
                        URLConnection connection;
                        try {
                            connection = url.openConnection();
                            connection.connect();
                            byteSource = () -> {
                                try (InputStream is = connection.getInputStream();){
                                    byte[] classBytes = ByteStreams.toByteArray(is);
                                    classBytes = SwitchTableFixer.INSTANCE.processClass(classBytes);
                                    byte[] byArray = classBytes = Bukkit.getUnsafe().processClass(this.description, path, classBytes);
                                    return byArray;
                                }
                            };
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                        classBytes = this.getRemapper().remapClass(name, byteSource, connection);
                        int dot = name.lastIndexOf(46);
                        if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                            try {
                                if (this.manifest != null) {
                                    this.definePackage(pkgName, this.manifest, this.url);
                                } else {
                                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                                }
                            }
                            catch (IllegalArgumentException ex) {
                                if (this.getPackage(pkgName) != null) break block14;
                                throw new IllegalStateException("Cannot find package " + pkgName);
                            }
                        }
                    }
                    result = this.defineClass(name, (byte[])classBytes._1, 0, ((byte[])classBytes._1).length, (CodeSource)classBytes._2);
                }
                if (result == null) {
                    result = super.findClass(name);
                }
                if (result != null) {
                    ((JavaPluginLoaderBridge)((Object)this.loader)).bridge$setClass(name, result);
                }
            }
            this.classes.put(name, result);
        }
        return result;
    }
}

