/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PistonBlock.class})
public class PistonBlockMixin {
    @Shadow
    @Final
    private boolean field_150082_a;

    @Inject(method={"checkForMove"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addBlockEvent(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;II)V")})
    public void arclight$pistonRetract(World worldIn, BlockPos pos, BlockState state, CallbackInfo ci, Direction direction) {
        if (!this.field_150082_a) {
            CraftBlock block = CraftBlock.at((IWorld)worldIn, pos);
            BlockPistonRetractEvent event = new BlockPistonRetractEvent(block, ImmutableList.of(), CraftBlock.notchToBlockFace(direction));
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"doMove"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/block/PistonBlockStructureHelper;getBlocksToDestroy()Ljava/util/List;")})
    public void arclight$pistonAction(World worldIn, BlockPos pos, Direction directionIn, boolean extending, CallbackInfoReturnable<Boolean> cir, BlockPos blockPos, PistonBlockStructureHelper helper) {
        final CraftBlock craftBlock = CraftBlock.at((IWorld)worldIn, pos);
        final List moved = helper.func_177254_c();
        final List broken = helper.func_177252_d();
        class BlockList
        extends AbstractList<Block> {
            BlockList() {
            }

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPos pos = index < moved.size() ? (BlockPos)moved.get(index) : (BlockPos)broken.get(index - moved.size());
                return craftBlock.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        BlockList blocks = new BlockList();
        Direction direction = extending ? directionIn : directionIn.func_176734_d();
        BlockPistonEvent event = extending ? new BlockPistonExtendEvent((Block)craftBlock, blocks, CraftBlock.notchToBlockFace(direction)) : new BlockPistonRetractEvent(craftBlock, blocks, CraftBlock.notchToBlockFace(direction));
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            for (BlockPos b : broken) {
                worldIn.func_184138_a(b, Blocks.field_150350_a.func_176223_P(), worldIn.func_180495_p(b), 3);
            }
            for (BlockPos b : moved) {
                worldIn.func_184138_a(b, Blocks.field_150350_a.func_176223_P(), worldIn.func_180495_p(b), 3);
                b = b.func_177972_a(direction);
                worldIn.func_184138_a(b, Blocks.field_150350_a.func_176223_P(), worldIn.func_180495_p(b), 3);
            }
            cir.setReturnValue((Object)false);
        }
    }
}

