/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity;

import com.google.common.base.Preconditions;
import io.izzel.arclight.common.bridge.command.ICommandSourceBridge;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.InternalEntityBridge;
import io.izzel.arclight.common.bridge.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.entity.MobEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.storage.SaveHandlerBridge;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.spigotmc.ActivationRange;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements InternalEntityBridge,
EntityBridge,
ICommandSourceBridge {
    @Shadow
    public float field_70177_z;
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public World field_70170_p;
    @Shadow
    protected int field_184245_j;
    @Shadow
    public double field_70161_v;
    @Shadow
    public float field_70125_A;
    @Shadow
    public int field_190534_ay;
    @Shadow
    public boolean field_70123_F;
    @Shadow
    public int field_70173_aa;
    @Shadow
    private Entity field_184239_as;
    @Shadow
    @Final
    public List<Entity> field_184244_h;
    @Shadow
    public DimensionType field_71093_bK;
    @Shadow
    @Final
    protected EntityDataManager field_70180_af;
    @Shadow
    @Final
    private static DataParameter<Integer> field_184241_ay;
    @Shadow
    @Deprecated
    public boolean field_70128_L;
    @Shadow
    @Final
    protected Random field_70146_Z;
    @Shadow
    public int field_70172_ad;
    @Shadow
    public boolean field_70122_E;
    @Shadow
    public float field_70143_R;
    @Shadow
    public float field_70140_Q;
    @Shadow
    public float field_70141_P;
    @Shadow
    protected UUID field_96093_i;
    @Shadow
    public double field_70169_q;
    @Shadow
    public double field_70167_r;
    @Shadow
    public double field_70166_s;
    @Shadow
    public float field_70126_B;
    private static final int CURRENT_LEVEL = 2;
    public boolean persist;
    public boolean valid;
    public ProjectileSource projectileSource;
    public boolean forceExplosionKnockback;
    public ActivationRange.ActivationType activationType;
    public boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    private CraftEntity bukkitEntity;
    private transient BlockPos arclight$tpPos;

    @Shadow
    public abstract net.minecraft.entity.Pose func_213283_Z();

    @Shadow
    public abstract String func_195047_I_();

    @Shadow
    protected abstract void func_213284_aV();

    @Shadow
    public abstract boolean func_70045_F();

    @Shadow
    public abstract boolean func_70097_a(DamageSource var1, float var2);

    @Shadow
    public abstract void func_70015_d(int var1);

    @Shadow
    protected abstract Vec3d func_213306_e(Vec3d var1);

    @Shadow
    public abstract void func_70106_y();

    @Shadow
    public void func_70029_a(World p_70029_1_) {
    }

    @Shadow
    @Nullable
    public abstract Entity func_184179_bs();

    @Shadow
    public abstract boolean func_203007_ba();

    @Shadow
    public abstract boolean func_70089_S();

    @Shadow
    public abstract void func_213319_R();

    @Shadow
    @Nullable
    public abstract MinecraftServer func_184102_h();

    @Shadow
    public abstract Vec3d func_213322_ci();

    @Shadow
    public abstract EntityType<?> func_200600_R();

    @Shadow(remap=false)
    public abstract void remove(boolean var1);

    @Shadow
    public abstract float func_213311_cf();

    @Shadow
    public abstract float func_213302_cg();

    @Shadow
    public abstract boolean func_82150_aj();

    @Shadow
    public abstract boolean func_180431_b(DamageSource var1);

    @Shadow
    public abstract void func_184185_a(SoundEvent var1, float var2, float var3);

    @Shadow
    public abstract void func_70634_a(double var1, double var3, double var5);

    @Shadow
    @Nullable
    public abstract ItemEntity func_199701_a_(ItemStack var1);

    @Shadow
    public abstract EntityDataManager func_184212_Q();

    @Shadow
    public void func_70071_h_() {
    }

    @Shadow
    public abstract AxisAlignedBB func_174813_aQ();

    @Shadow(remap=false)
    public abstract Collection<ItemEntity> captureDrops();

    @Shadow(remap=false)
    public abstract Collection<ItemEntity> captureDrops(Collection<ItemEntity> var1);

    @Shadow
    public abstract BlockPos func_180425_c();

    @Shadow
    public abstract boolean func_70090_H();

    @Shadow
    public abstract boolean func_184218_aH();

    @Shadow
    public abstract boolean func_70051_ag();

    @Shadow
    public abstract boolean func_184191_r(Entity var1);

    @Shadow
    public abstract void func_213317_d(Vec3d var1);

    @Shadow
    public abstract double func_70068_e(Entity var1);

    @Shadow
    protected abstract void func_70018_K();

    @Shadow
    public abstract void func_184226_ay();

    @Shadow
    public abstract boolean func_145818_k_();

    @Shadow
    protected abstract void func_70076_C();

    @Shadow
    public abstract void func_70107_b(double var1, double var3, double var5);

    @Shadow
    protected abstract void func_70101_b(float var1, float var2);

    @Shadow
    public abstract boolean func_189652_ae();

    @Shadow
    protected abstract void func_145775_I();

    @Shadow
    public abstract boolean func_70072_I();

    @Shadow
    public abstract boolean func_184207_aI();

    @Shadow
    public abstract boolean func_184196_w(Entity var1);

    @Shadow
    public abstract void func_213293_j(double var1, double var3, double var5);

    @Shadow
    public abstract void func_213315_a(MoverType var1, Vec3d var2);

    @Shadow
    @Nullable
    public abstract Entity func_184187_bx();

    @Shadow
    @Nullable
    public abstract Team func_96124_cp();

    @Shadow
    public abstract void func_70066_B();

    @Shadow
    public abstract void func_70052_a(int var1, boolean var2);

    @Shadow
    public abstract void func_70012_b(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    public abstract int func_145782_y();

    @Shadow
    @Nullable
    public abstract ITextComponent func_200201_e();

    @Shadow
    protected abstract void func_174815_a(net.minecraft.entity.LivingEntity var1, Entity var2);

    @Shadow
    @Nullable
    public abstract Entity func_212321_a(DimensionType var1);

    @Shadow
    public abstract boolean func_184223_x(Entity var1);

    @Shadow
    public abstract boolean func_190530_aW();

    @Shadow
    public abstract double func_226277_ct_();

    @Shadow
    public abstract double func_226281_cx_();

    @Shadow
    public abstract Vec3d func_181014_aG();

    @Shadow
    public abstract double func_226278_cu_();

    @Shadow
    public abstract Direction func_181012_aH();

    @Shadow
    public abstract double func_226280_cw_();

    @Shadow
    public abstract Vec3d func_213303_ch();

    @Shadow(remap=false)
    public abstract void revive();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(EntityType<?> entityTypeIn, World worldIn, CallbackInfo ci) {
        this.persist = true;
        this.activationType = ActivationRange.initializeEntityActivationType((Entity)this);
        this.defaultActivationState = worldIn != null ? ActivationRange.initializeEntityActivationState((Entity)this, ((WorldBridge)worldIn).bridge$spigotConfig()) : false;
    }

    public CraftEntity getBukkitEntity() {
        return this.internal$getBukkitEntity();
    }

    public void inactiveTick() {
        this.func_70071_h_();
    }

    @Override
    public void bridge$inactiveTick() {
        this.inactiveTick();
    }

    @Override
    public CommandSender bridge$getBukkitSender(CommandSource wrapper) {
        return this.internal$getBukkitEntity();
    }

    @Override
    public CraftEntity bridge$getBukkitEntity() {
        return this.internal$getBukkitEntity();
    }

    @Override
    public void bridge$setBukkitEntity(CraftEntity bukkitEntity) {
        this.bukkitEntity = bukkitEntity;
    }

    @Override
    public CraftEntity internal$getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity((CraftServer)Bukkit.getServer(), (Entity)this);
        }
        return this.bukkitEntity;
    }

    public float getBukkitYaw() {
        return this.field_70177_z;
    }

    @Override
    public float bridge$getBukkitYaw() {
        return this.getBukkitYaw();
    }

    public boolean isChunkLoaded() {
        return this.field_70170_p.func_217354_b((int)Math.floor(this.field_70165_t) >> 4, (int)Math.floor(this.field_70161_v) >> 4);
    }

    @Override
    public boolean bridge$isChunkLoaded() {
        return this.isChunkLoaded();
    }

    @Inject(method={"setPose"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/datasync/EntityDataManager;set(Lnet/minecraft/network/datasync/DataParameter;Ljava/lang/Object;)V")})
    public void arclight$setPose$EntityPoseChangeEvent(net.minecraft.entity.Pose poseIn, CallbackInfo callbackInfo) {
        if (poseIn == this.func_213283_Z()) {
            callbackInfo.cancel();
            return;
        }
        EntityPoseChangeEvent event = new EntityPoseChangeEvent(this.internal$getBukkitEntity(), Pose.values()[poseIn.ordinal()]);
        Bukkit.getPluginManager().callEvent(event);
    }

    @Inject(method={"setRotation"}, cancellable=true, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;rotationYaw:F")})
    public void arclight$setRotation$InfiniteValueCheck(float yaw, float pitch, CallbackInfo callbackInfo) {
        if (Float.isNaN(yaw)) {
            this.field_70177_z = 0.0f;
            callbackInfo.cancel();
        }
        if (yaw == Float.POSITIVE_INFINITY || yaw == Float.NEGATIVE_INFINITY) {
            if (this instanceof PlayerEntity) {
                Bukkit.getLogger().warning(this.func_195047_I_() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Are you hacking?)");
            }
            this.field_70177_z = 0.0f;
            callbackInfo.cancel();
        }
        if (Float.isNaN(pitch)) {
            this.field_70125_A = 0.0f;
            callbackInfo.cancel();
        }
        if (pitch == Float.POSITIVE_INFINITY || pitch == Float.NEGATIVE_INFINITY) {
            if (this instanceof PlayerEntity) {
                Bukkit.getLogger().warning(this.func_195047_I_() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Are you hacking?)");
            }
            this.field_70125_A = 0.0f;
            callbackInfo.cancel();
        }
    }

    @Override
    public boolean bridge$isPersist() {
        return this.persist;
    }

    @Override
    public void bridge$setPersist(boolean persist) {
        this.persist = persist;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean bridge$isValid() {
        return this.isValid();
    }

    @Override
    public void bridge$setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public ProjectileSource bridge$getProjectileSource() {
        return this.projectileSource;
    }

    @Override
    public void bridge$setProjectileSource(ProjectileSource projectileSource) {
        this.projectileSource = projectileSource;
    }

    @Override
    public boolean bridge$isForceExplosionKnockback() {
        return this.forceExplosionKnockback;
    }

    @Override
    public void bridge$setForceExplosionKnockback(boolean forceExplosionKnockback) {
        this.forceExplosionKnockback = forceExplosionKnockback;
    }

    @Inject(method={"setPosition"}, at={@At(value="RETURN")})
    public void arclight$setPosition$CraftBukkitChunkCheck(double x, double y, double z, CallbackInfo callbackInfo) {
        if (this.valid) {
            ((ServerWorld)this.field_70170_p).func_217464_b((Entity)this);
        }
    }

    public void postTick() {
        if (!(this instanceof PlayerEntity)) {
            this.func_213284_aV();
        }
    }

    @Override
    public void bridge$postTick() {
        this.postTick();
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;updatePortal()V"))
    public void arclight$baseTick$moveToPostTick(Entity entity) {
        if (this instanceof PlayerEntity) {
            this.func_213284_aV();
        }
    }

    @Redirect(method={"setOnFireFromLava"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setFire(I)V"))
    public void arclight$setOnFireFromLava$bukkitEvent(Entity entity, int seconds) {
        if (this instanceof net.minecraft.entity.LivingEntity && this.field_190534_ay <= 0) {
            Block damager = null;
            CraftEntity damagee = this.getBukkitEntity();
            EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent(damager, damagee, 15);
            Bukkit.getPluginManager().callEvent(combustEvent);
            if (!combustEvent.isCancelled()) {
                this.func_70015_d(combustEvent.getDuration());
            }
        } else {
            this.func_70015_d(15);
        }
    }

    public void setOnFire(int seconds, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent(this.getBukkitEntity(), seconds);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            seconds = event.getDuration();
        }
        this.func_70015_d(seconds);
    }

    @Override
    public void bridge$setOnFire(int tick, boolean callEvent) {
        this.setOnFire(tick, callEvent);
    }

    @ModifyArg(method={"move"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onEntityWalk(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V"))
    private BlockPos arclight$captureBlockWalk(BlockPos pos) {
        ArclightCaptures.captureDamageEventBlock(pos);
        return pos;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/block/Block;onEntityWalk(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V")})
    private void arclight$resetBlockWalk(MoverType typeIn, Vec3d pos, CallbackInfo ci) {
        ArclightCaptures.captureDamageEventBlock(null);
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setFire(I)V"))
    public void arclight$move$EntityCombustEvent(Entity entity, int seconds) {
        EntityCombustByBlockEvent event = new EntityCombustByBlockEvent(null, this.getBukkitEntity(), 8);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.func_70015_d(event.getDuration());
        }
    }

    @Inject(method={"resetPositionToBB"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;chunkCheck(Lnet/minecraft/entity/Entity;)V")})
    private void arclight$checkIfValid(CallbackInfo ci) {
        if (!this.valid) {
            ci.cancel();
        }
    }

    public void burn(float amount) {
        if (!this.func_70045_F()) {
            this.func_70097_a(DamageSource.field_76372_a, amount);
        }
    }

    @Override
    public void bridge$burn(float amount) {
        this.burn(amount);
    }

    @Inject(method={"setWorld"}, at={@At(value="HEAD")}, cancellable=true)
    public void arclight$setWorld(World world, CallbackInfo ci) {
        if (world == null) {
            this.func_70106_y();
            this.field_70170_p = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
            ci.cancel();
        }
    }

    @Inject(method={"setPositionAndRotation"}, at={@At(value="RETURN")})
    private void arclight$loadChunk(double x, double y, double z, float yaw, float pitch, CallbackInfo ci) {
        if (this.valid) {
            this.field_70170_p.func_212866_a_((int)Math.floor(this.field_70165_t) >> 4, (int)Math.floor(this.field_70161_v) >> 4);
        }
    }

    @Inject(method={"writeUnlessRemoved"}, cancellable=true, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/Entity;getEntityString()Ljava/lang/String;")})
    public void arclight$writeUnlessRemoved$persistCheck(CompoundNBT compound, CallbackInfoReturnable<Boolean> cir) {
        if (!this.persist) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"writeWithoutTypeId"}, at={@At(value="INVOKE_ASSIGN", ordinal=1, target="Lnet/minecraft/nbt/CompoundNBT;put(Ljava/lang/String;Lnet/minecraft/nbt/INBT;)Lnet/minecraft/nbt/INBT;")})
    public void arclight$writeWithoutTypeId$InfiniteValueCheck(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> cir) {
        if (Float.isNaN(this.field_70177_z)) {
            this.field_70177_z = 0.0f;
        }
        if (Float.isNaN(this.field_70125_A)) {
            this.field_70125_A = 0.0f;
        }
    }

    @Inject(method={"writeWithoutTypeId"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, ordinal=0, target="Lnet/minecraft/nbt/CompoundNBT;putUniqueId(Ljava/lang/String;Ljava/util/UUID;)V")})
    public void arclight$writeWithoutTypeId$CraftBukkitNBT(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> cir) {
        compound.func_74772_a("WorldUUIDLeast", ((SaveHandlerBridge)((ServerWorld)this.field_70170_p).func_217485_w()).bridge$getUUID((ServerWorld)this.field_70170_p).getLeastSignificantBits());
        compound.func_74772_a("WorldUUIDMost", ((SaveHandlerBridge)((ServerWorld)this.field_70170_p).func_217485_w()).bridge$getUUID((ServerWorld)this.field_70170_p).getMostSignificantBits());
        compound.func_74768_a("Bukkit.updateLevel", 2);
        compound.func_74768_a("Spigot.ticksLived", this.field_70173_aa);
    }

    @Inject(method={"writeWithoutTypeId"}, at={@At(value="RETURN")})
    public void arclight$writeWithoutTypeId$StoreBukkitValues(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> cir) {
        if (this.bukkitEntity != null) {
            this.bukkitEntity.storeBukkitValues(compound);
        }
    }

    private static boolean isLevelAtLeast(CompoundNBT tag, int level) {
        return tag.func_74764_b("Bukkit.updateLevel") && tag.func_74762_e("Bukkit.updateLevel") >= level;
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    public void arclight$read$ReadBukkitValues(CompoundNBT compound, CallbackInfo ci) {
        if (this instanceof net.minecraft.entity.LivingEntity) {
            net.minecraft.entity.LivingEntity entity = (net.minecraft.entity.LivingEntity)this;
            this.field_70173_aa = compound.func_74762_e("Spigot.ticksLived");
            if (entity instanceof TameableEntity && !EntityMixin.isLevelAtLeast(compound, 2) && !compound.func_74767_n("PersistenceRequired")) {
                MobEntity entityInsentient = (MobEntity)entity;
                ((MobEntityBridge)entityInsentient).bridge$setPersistenceRequired(!entityInsentient.func_213397_c(0.0));
            }
        }
        if (this instanceof ServerPlayerEntity) {
            org.bukkit.World bworld;
            Server server = Bukkit.getServer();
            String worldName = compound.func_74779_i("world");
            if (compound.func_74764_b("WorldUUIDMost") && compound.func_74764_b("WorldUUIDLeast")) {
                UUID uid = new UUID(compound.func_74763_f("WorldUUIDMost"), compound.func_74763_f("WorldUUIDLeast"));
                bworld = server.getWorld(uid);
            } else {
                bworld = server.getWorld(worldName);
            }
            if (bworld != null) {
                this.func_70029_a((World)(bworld == null ? null : ((CraftWorld)bworld).getHandle()));
            }
        }
        this.getBukkitEntity().readBukkitValues(compound);
    }

    @Redirect(method={"entityDropItem(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/item/ItemEntity;"}, at=@At(value="INVOKE", remap=false, ordinal=0, target="Lnet/minecraft/entity/Entity;captureDrops()Ljava/util/Collection;"))
    public Collection<ItemEntity> arclight$forceDrops(Entity entity) {
        Collection drops = entity.captureDrops();
        if (this instanceof LivingEntityBridge && ((LivingEntityBridge)((Object)this)).bridge$isForceDrops()) {
            drops = null;
        }
        return drops;
    }

    @Inject(method={"entityDropItem(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/item/ItemEntity;"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addEntity(Lnet/minecraft/entity/Entity;)Z")})
    public void arclight$entityDropItem(ItemStack stack, float offsetY, CallbackInfoReturnable<ItemEntity> cir, ItemEntity itementity) {
        EntityDropItemEvent event = new EntityDropItemEvent(this.getBukkitEntity(), (Item)((Object)((EntityBridge)itementity).bridge$getBukkitEntity()));
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"startRiding(Lnet/minecraft/entity/Entity;Z)Z"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;addPassenger(Lnet/minecraft/entity/Entity;)V")})
    public void arclight$startRide(Entity entityIn, boolean force, CallbackInfoReturnable<Boolean> cir) {
        if (!((EntityBridge)this.field_184239_as).bridge$addPassenger((Entity)this)) {
            this.field_184239_as = null;
        }
        cir.setReturnValue((Object)true);
    }

    @Redirect(method={"stopRiding()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;removePassenger(Lnet/minecraft/entity/Entity;)V"))
    public void arclight$stopRiding$CraftBukkitPatch(Entity entity, Entity passenger) {
        if (!((EntityBridge)entity).bridge$removePassenger(passenger)) {
            this.field_184239_as = entity;
        }
    }

    @Override
    public List<Entity> bridge$getPassengers() {
        return this.field_184244_h;
    }

    @Override
    public boolean bridge$addPassenger(Entity entity) {
        return this.addPassenger(entity);
    }

    public boolean addPassenger(Entity entity) {
        Event event;
        Entity orig;
        if (entity.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        Preconditions.checkState(!((EntityBridge)entity).bridge$getPassengers().contains(this), "Circular entity riding! %s %s", (Object)this, (Object)entity);
        CraftEntity craft = (CraftEntity)((EntityBridge)entity).bridge$getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && ((EntityBridge)entity).bridge$getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n;
            event = new VehicleEnterEvent((Vehicle)((Object)this.getBukkitEntity()), ((EntityBridge)entity).bridge$getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent(event);
            }
            Entity entity3 = n = (craftn = (CraftEntity)((EntityBridge)entity).bridge$getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (((VehicleEnterEvent)event).isCancelled() || n != orig) {
                return false;
            }
        }
        event = new EntityMountEvent(((EntityBridge)entity).bridge$getBukkitEntity(), this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent(event);
        }
        if (((EntityMountEvent)event).isCancelled()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && entity instanceof PlayerEntity && !(this.func_184179_bs() instanceof PlayerEntity)) {
            this.field_184244_h.add(0, entity);
        } else {
            this.field_184244_h.add(entity);
        }
        return true;
    }

    @Override
    public boolean bridge$removePassenger(Entity entity) {
        return this.removePassenger(entity);
    }

    public boolean removePassenger(Entity entity) {
        Event event;
        Entity orig;
        if (entity.func_184187_bx() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)((EntityBridge)entity).bridge$getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && ((EntityBridge)entity).bridge$getBukkitEntity() instanceof LivingEntity) {
            Entity n;
            event = new VehicleExitEvent((Vehicle)((Object)this.getBukkitEntity()), (LivingEntity)((Object)((EntityBridge)entity).bridge$getBukkitEntity()));
            Bukkit.getPluginManager().callEvent(event);
            CraftEntity craftn = (CraftEntity)((EntityBridge)entity).bridge$getBukkitEntity().getVehicle();
            Entity entity3 = n = craftn == null ? null : craftn.getHandle();
            if (((VehicleExitEvent)event).isCancelled() || n != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent(((EntityBridge)entity).bridge$getBukkitEntity(), this.getBukkitEntity());
        Bukkit.getPluginManager().callEvent(event);
        if (((EntityDismountEvent)event).isCancelled()) {
            return false;
        }
        this.field_184244_h.remove(entity);
        ((EntityBridge)entity).bridge$setRideCooldown(60);
        return true;
    }

    @Inject(method={"updatePortal"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;changeDimension(Lnet/minecraft/world/dimension/DimensionType;)Lnet/minecraft/entity/Entity;")})
    public void arclight$changeDimension(CallbackInfo ci) {
        if (this instanceof ServerPlayerEntityBridge) {
            ((ServerPlayerEntityBridge)((Object)this)).bridge$pushChangeDimensionCause(PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
        }
    }

    @Inject(method={"setSwimming"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$setSwimming$EntityToggleSwimEvent(boolean flag, CallbackInfo ci) {
        if (this.func_203007_ba() != flag && this instanceof net.minecraft.entity.LivingEntity && CraftEventFactory.callToggleSwimEvent((net.minecraft.entity.LivingEntity)this, flag).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"setAir"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$setAir$EntityAirChangeEvent(int air, CallbackInfo ci) {
        EntityAirChangeEvent event = new EntityAirChangeEvent(this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent(event);
        }
        if (!event.isCancelled()) {
            this.field_70180_af.func_187227_b(field_184241_ay, (Object)event.getAmount());
        }
        ci.cancel();
    }

    @Redirect(method={"onStruckByLightning"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setFire(I)V"))
    public void arclight$onStruckByLightning$EntityCombustByEntityEvent0(Entity entity, int seconds) {
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = ((EntityBridge)entity).bridge$getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent(stormBukkitEntity, thisBukkitEntity, 8);
        pluginManager.callEvent(entityCombustEvent);
        if (!entityCombustEvent.isCancelled()) {
            this.func_70015_d(entityCombustEvent.getDuration());
        }
    }

    @Redirect(method={"onStruckByLightning"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    public boolean arclight$onStruckByLightning$EntityCombustByEntityEvent1(Entity entity, DamageSource source, float amount) {
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = ((EntityBridge)entity).bridge$getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)((Object)thisBukkitEntity), stormBukkitEntity);
            pluginManager.callEvent(hangingEvent);
            if (hangingEvent.isCancelled()) {
                return false;
            }
        }
        if (this.func_70045_F()) {
            return false;
        }
        CraftEventFactory.entityDamage = entity;
        if (!this.func_70097_a(DamageSource.field_180137_b, 5.0f)) {
            CraftEventFactory.entityDamage = null;
            return false;
        }
        return true;
    }

    @Override
    public void bridge$setRideCooldown(int rideCooldown) {
        this.field_184245_j = rideCooldown;
    }

    @Override
    public int bridge$getRideCooldown() {
        return this.field_184245_j;
    }

    @Override
    public BlockPos internal$capturedPos() {
        try {
            BlockPos blockPos = this.arclight$tpPos;
            return blockPos;
        }
        finally {
            this.arclight$tpPos = null;
        }
    }

    public Entity teleportTo(DimensionType type, BlockPos blockPos) {
        this.arclight$tpPos = blockPos;
        return this.func_212321_a(type);
    }

    @Override
    public Entity bridge$teleportTo(DimensionType type, BlockPos blockPos) {
        return this.teleportTo(type, blockPos);
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;canTriggerWalking()Z")})
    private void arclight$move$blockCollide(MoverType typeIn, Vec3d pos, CallbackInfo ci) {
        if (this.field_70123_F && this.bridge$getBukkitEntity() instanceof Vehicle) {
            Vehicle vehicle = (Vehicle)((Object)this.bridge$getBukkitEntity());
            Block block = ((WorldBridge)this.field_70170_p).bridge$getWorld().getBlockAt(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_()));
            Vec3d vec3d = this.func_213306_e(pos);
            if (pos.field_72450_a > vec3d.field_72450_a) {
                block = block.getRelative(BlockFace.EAST);
            } else if (vec3d.field_72450_a < vec3d.field_72450_a) {
                block = block.getRelative(BlockFace.WEST);
            } else if (pos.field_72449_c > vec3d.field_72449_c) {
                block = block.getRelative(BlockFace.SOUTH);
            } else if (pos.field_72449_c < vec3d.field_72449_c) {
                block = block.getRelative(BlockFace.NORTH);
            }
            if (block.getType() != Material.AIR) {
                VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, block);
                Bukkit.getPluginManager().callEvent(event);
            }
        }
    }

    @Overwrite(remap=false)
    @Nullable
    public Entity changeDimension(DimensionType destination, ITeleporter teleporter) {
        BlockPos location = this.internal$capturedPos();
        if (!ForgeHooks.onTravelToDimension((Entity)((Entity)this), (DimensionType)destination)) {
            return null;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.field_70170_p.func_217381_Z().func_76320_a("changeDimension");
            MinecraftServer minecraftserver = this.func_184102_h();
            DimensionType dimensiontype = this.field_71093_bK;
            ServerWorld serverworld = minecraftserver.func_71218_a(dimensiontype);
            ServerWorld[] serverworld1 = new ServerWorld[]{minecraftserver.func_71218_a(destination)};
            if (serverworld1 == null) {
                return null;
            }
            this.field_71093_bK = destination;
            this.func_213319_R();
            this.field_70170_p.func_217381_Z().func_76320_a("reposition");
            Entity transportedEntity = teleporter.placeEntity((Entity)this, serverworld, serverworld1[0], this.field_70177_z, spawnPortal -> {
                Vec3d vec3d = this.func_213322_ci();
                float f = 0.0f;
                BlockPos blockpos = location;
                if (blockpos == null) {
                    if (dimensiontype == DimensionType.field_223229_c_ && destination == DimensionType.field_223227_a_) {
                        EntityPortalEvent event = CraftEventFactory.callEntityPortalEvent((Entity)this, (World)serverworld1[0], serverworld1[0].func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, serverworld1[0].func_175694_M()), 0);
                        if (event == null) {
                            return null;
                        }
                        serverworld1[0] = ((CraftWorld)event.getTo().getWorld()).getHandle();
                        blockpos = new BlockPos(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
                    } else if (destination == DimensionType.field_223229_c_) {
                        EntityPortalEvent event = CraftEventFactory.callEntityPortalEvent((Entity)this, (World)serverworld1[0], serverworld1[0].func_180504_m() != null ? serverworld1[0].func_180504_m() : serverworld1[0].func_175694_M(), 0);
                        if (event == null) {
                            return null;
                        }
                        serverworld1[0] = ((CraftWorld)event.getTo().getWorld()).getHandle();
                        blockpos = new BlockPos(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
                    } else {
                        double movementFactor = serverworld.func_201675_m().getMovementFactor() / serverworld1[0].func_201675_m().getMovementFactor();
                        double d0 = this.func_226277_ct_() * movementFactor;
                        double d1 = this.func_226281_cx_() * movementFactor;
                        double d3 = Math.min(-2.9999872E7, serverworld1[0].func_175723_af().func_177726_b() + 16.0);
                        double d4 = Math.min(-2.9999872E7, serverworld1[0].func_175723_af().func_177736_c() + 16.0);
                        double d5 = Math.min(2.9999872E7, serverworld1[0].func_175723_af().func_177728_d() - 16.0);
                        double d6 = Math.min(2.9999872E7, serverworld1[0].func_175723_af().func_177733_e() - 16.0);
                        d0 = MathHelper.func_151237_a((double)d0, (double)d3, (double)d5);
                        d1 = MathHelper.func_151237_a((double)d1, (double)d4, (double)d6);
                        Vec3d vec3d1 = this.func_181014_aG();
                        blockpos = new BlockPos(d0, this.func_226278_cu_(), d1);
                        EntityPortalEvent event2 = CraftEventFactory.callEntityPortalEvent((Entity)this, (World)serverworld1[0], blockpos, 128);
                        if (event2 == null) {
                            return null;
                        }
                        serverworld1[0] = ((CraftWorld)event2.getTo().getWorld()).getHandle();
                        blockpos = new BlockPos(event2.getTo().getX(), event2.getTo().getY(), event2.getTo().getZ());
                        int searchRadius = event2.getSearchRadius();
                        if (spawnPortal.booleanValue()) {
                            BlockPattern.PortalInfo blockpattern$portalinfo = serverworld1[0].func_85176_s().func_222272_a(blockpos, vec3d, this.func_181012_aH(), vec3d1.field_72450_a, vec3d1.field_72448_b, this instanceof PlayerEntity);
                            if (blockpattern$portalinfo == null) {
                                return null;
                            }
                            blockpos = new BlockPos(blockpattern$portalinfo.field_222505_a);
                            vec3d = blockpattern$portalinfo.field_222506_b;
                            f = blockpattern$portalinfo.field_222507_c;
                        }
                    }
                }
                this.field_70170_p.func_217381_Z().func_219895_b("reloading");
                Entity entity = this.func_200600_R().func_200721_a((World)serverworld1[0]);
                if (entity != null) {
                    entity.func_180432_n((Entity)this);
                    entity.func_174828_a(blockpos, entity.field_70177_z + f, entity.field_70125_A);
                    entity.func_213317_d(vec3d);
                    serverworld1[0].func_217460_e(entity);
                }
                return entity;
            });
            if (transportedEntity == null) {
                this.field_71093_bK = dimensiontype;
                return null;
            }
            this.remove(false);
            this.field_70170_p.func_217381_Z().func_76319_b();
            serverworld.func_82742_i();
            serverworld1[0].func_82742_i();
            this.field_70170_p.func_217381_Z().func_76319_b();
            return transportedEntity;
        }
        return null;
    }

    @Inject(method={"copyDataFromOld"}, at={@At(value="HEAD")})
    private void arclight$forwardHandle(Entity entityIn, CallbackInfo ci) {
        ((InternalEntityBridge)entityIn).internal$getBukkitEntity().setHandle((Entity)this);
        this.bridge$setBukkitEntity(((InternalEntityBridge)entityIn).internal$getBukkitEntity());
        if (entityIn instanceof MobEntity) {
            ((MobEntity)entityIn).func_110160_i(true, false);
        }
    }
}

