/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.item;

import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.entity.EntityMixin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.util.DamageSource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BoatEntity.class})
public abstract class BoatEntityMixin
extends EntityMixin {
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    @Shadow
    public abstract float func_70271_g();

    @Shadow
    public abstract void func_70266_a(float var1);

    @Inject(method={"attackEntityFrom"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/BoatEntity;setForwardDirection(I)V")})
    private void arclight$damageVehicle(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Vehicle vehicle = (Vehicle)((Object)this.getBukkitEntity());
        CraftEntity attacker = source.func_76346_g() == null ? null : ((EntityBridge)source.func_76346_g()).bridge$getBukkitEntity();
        VehicleDamageEvent event = new VehicleDamageEvent(vehicle, attacker, amount);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"attackEntityFrom"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/BoatEntity;getDamageTaken()F")})
    private void arclight$destroyVehicle(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.func_70271_g() > 40.0f) {
            Vehicle vehicle = (Vehicle)((Object)this.getBukkitEntity());
            CraftEntity attacker = source.func_76346_g() == null ? null : ((EntityBridge)source.func_76346_g()).bridge$getBukkitEntity();
            VehicleDestroyEvent event = new VehicleDestroyEvent(vehicle, attacker);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                this.func_70266_a(40.0f);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"applyEntityCollision"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;applyEntityCollision(Lnet/minecraft/entity/Entity;)V")})
    private void arclight$collideVehicle(Entity entityIn, CallbackInfo ci) {
        if (this.func_184223_x(entityIn)) {
            VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)((Object)this.getBukkitEntity()), ((EntityBridge)entityIn).bridge$getBukkitEntity());
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"tick"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/BoatEntity;updateRocking()V")})
    private void arclight$updateVehicle(CallbackInfo ci) {
        CraftWorld bworld = ((WorldBridge)this.field_70170_p).bridge$getWorld();
        Location to = new Location(bworld, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        Vehicle vehicle = (Vehicle)((Object)this.getBukkitEntity());
        Bukkit.getPluginManager().callEvent(new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals(to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            Bukkit.getPluginManager().callEvent(event);
        }
        this.lastLocation = vehicle.getLocation();
    }

    @Redirect(method={"updateFallState"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/item/BoatEntity;removed:Z"))
    private boolean arclight$breakVehicle(BoatEntity boatEntity) {
        if (!boatEntity.field_70128_L) {
            Vehicle vehicle = (Vehicle)((Object)this.getBukkitEntity());
            VehicleDestroyEvent event = new VehicleDestroyEvent(vehicle, null);
            Bukkit.getPluginManager().callEvent(event);
            return event.isCancelled();
        }
        return true;
    }
}

