/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.passive.horse;

import io.izzel.arclight.common.bridge.inventory.IInventoryBridge;
import io.izzel.arclight.common.mixin.core.entity.passive.AnimalEntityMixin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.inventory.InventoryHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorseEntity.class})
public abstract class AbstractHorseEntityMixin
extends AnimalEntityMixin {
    public int maxDomestication;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(EntityType<? extends AbstractHorseEntity> type, World worldIn, CallbackInfo ci) {
        this.maxDomestication = 100;
    }

    @Redirect(method={"initHorseChest"}, at=@At(value="NEW", target="net/minecraft/inventory/Inventory"))
    private Inventory arclight$createInv(int slots) {
        Inventory inventory = new Inventory(slots);
        ((IInventoryBridge)inventory).setOwner((InventoryHolder)((Object)this.getBukkitEntity()));
        return inventory;
    }

    @Inject(method={"handleEating"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/horse/AbstractHorseEntity;heal(F)V")})
    private void arclight$healByEating(PlayerEntity player, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        this.bridge$pushHealReason(EntityRegainHealthEvent.RegainReason.EATING);
    }

    @Inject(method={"livingTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/horse/AbstractHorseEntity;heal(F)V")})
    private void arclight$healByRegen(CallbackInfo ci) {
        this.bridge$pushHealReason(EntityRegainHealthEvent.RegainReason.REGEN);
    }

    @Inject(method={"writeAdditional"}, at={@At(value="RETURN")})
    private void arclight$writeTemper(CompoundNBT compound, CallbackInfo ci) {
        compound.func_74768_a("Bukkit.MaxDomestication", this.maxDomestication);
    }

    @Inject(method={"readAdditional"}, at={@At(value="RETURN")})
    private void arclight$readTemper(CompoundNBT compound, CallbackInfo ci) {
        if (compound.func_74764_b("Bukkit.MaxDomestication")) {
            this.maxDomestication = compound.func_74762_e("Bukkit.MaxDomestication");
        }
    }

    @Inject(method={"handleStartJump"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$horseJump(int i, CallbackInfo ci) {
        float power = i >= 90 ? 1.0f : 0.4f + 0.4f * (float)i / 90.0f;
        HorseJumpEvent event = CraftEventFactory.callHorseJumpEvent((Entity)((AbstractHorseEntity)this), power);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Overwrite
    public int func_190676_dC() {
        return this.maxDomestication;
    }
}

