/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.player;

import com.mojang.datafixers.util.Either;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.inventory.container.ContainerBridge;
import io.izzel.arclight.common.bridge.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.util.FoodStatsBridge;
import io.izzel.arclight.common.bridge.world.TeleporterBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.dimension.DimensionTypeBridge;
import io.izzel.arclight.common.bridge.world.server.ServerWorldBridge;
import io.izzel.arclight.common.mixin.core.entity.player.PlayerEntityMixin;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.BlackholeNetHandler;
import io.izzel.arclight.common.mod.util.ChestBlockDoubleInventoryHacks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SOpenHorseWindowPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_15_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin
implements ServerPlayerEntityBridge {
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    @Final
    public PlayerInteractionManager field_71134_c;
    @Shadow
    public ServerPlayNetHandler field_71135_a;
    @Shadow
    public boolean field_184851_cj;
    @Shadow
    public boolean field_71136_j;
    @Shadow
    private boolean field_192040_cp;
    @Shadow
    @Nullable
    private Vec3d field_193110_cw;
    @Shadow
    public int field_71144_ck;
    @Shadow
    private float field_71149_ch;
    @Shadow
    private int field_71146_ci;
    @Shadow
    public int field_71139_cq;
    @Shadow
    public String field_71148_cg;
    @Shadow
    private boolean field_193109_cv;
    public String displayName;
    public ITextComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public Integer clientViewDistance;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;
    private boolean arclight$initialized = false;
    private transient PlayerTeleportEvent.TeleportCause arclight$cause;

    @Shadow
    protected abstract int func_205735_q(int var1);

    @Shadow
    public abstract boolean func_175149_v();

    @Shadow
    public abstract void func_175145_a(Stat<?> var1);

    @Shadow
    public abstract void func_71053_j();

    @Shadow
    public abstract void func_175399_e(Entity var1);

    @Shadow
    public abstract ServerWorld func_71121_q();

    @Shadow
    public abstract void func_213846_b(ServerWorld var1);

    @Shadow
    public abstract void func_71117_bO();

    @Shadow
    public abstract void func_145747_a(ITextComponent var1);

    @Shadow
    public abstract void func_200619_a(ServerWorld var1, double var2, double var4, double var6, float var8, float var9);

    @Shadow
    public abstract void func_195068_e(int var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$init(CallbackInfo ci) {
        this.displayName = this.func_146103_bH() != null ? this.func_195047_I_() : "~FakePlayer~";
        this.canPickUpLoot = true;
        this.maxHealthCache = this.func_110138_aP();
        this.arclight$initialized = true;
        if (this instanceof FakePlayer) {
            this.field_71135_a = new BlackholeNetHandler(this.func_184102_h(), (ServerPlayerEntity)this);
        }
    }

    @Override
    public boolean bridge$initialized() {
        return this.arclight$initialized;
    }

    @Override
    @Overwrite(remap=false)
    @Nullable
    public Entity changeDimension(DimensionType dim, ITeleporter teleporter) {
        DimensionType[] destination = new DimensionType[]{dim};
        if (this.func_70608_bn()) {
            return (ServerPlayerEntity)this;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)((ServerPlayerEntity)this), (DimensionType)destination[0])) {
            return null;
        }
        PlayerTeleportEvent.TeleportCause cause = this.bridge$getTeleportCause().orElse(PlayerTeleportEvent.TeleportCause.UNKNOWN);
        DimensionType dimensiontype = this.field_71093_bK;
        if (((DimensionTypeBridge)dimensiontype).bridge$getType() == DimensionType.field_223229_c_ && ((DimensionTypeBridge)destination[0]).bridge$getType() == DimensionType.field_223227_a_ && teleporter instanceof Teleporter) {
            this.field_184851_cj = true;
            this.func_213319_R();
            this.func_71121_q().removePlayer((ServerPlayerEntity)this, true);
            if (!this.field_71136_j) {
                this.field_71136_j = true;
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(4, this.field_192040_cp ? 0.0f : 1.0f));
                this.field_192040_cp = true;
            }
            return (ServerPlayerEntity)this;
        }
        ServerWorld serverworld = this.field_71133_b.func_71218_a(dimensiontype);
        this.field_71093_bK = destination[0];
        ServerWorld[] serverworld1 = new ServerWorld[]{this.field_71133_b.func_71218_a(destination[0])};
        WorldInfo preWorldInfo = serverworld1[0].func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)this.field_71135_a.field_147371_a, (ServerPlayerEntity)((ServerPlayerEntity)this));
        this.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination[0], WorldInfo.func_227498_c_((long)preWorldInfo.func_76063_b()), preWorldInfo.func_76067_t(), this.field_71134_c.func_73081_b()));
        this.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(preWorldInfo.func_176130_y(), preWorldInfo.func_176123_z()));
        PlayerList playerlist = this.field_71133_b.func_184103_al();
        playerlist.func_187243_f((ServerPlayerEntity)this);
        serverworld.removeEntity((Entity)((ServerPlayerEntity)this), true);
        this.revive();
        Entity e = teleporter.placeEntity((Entity)((ServerPlayerEntity)this), serverworld, serverworld1[0], this.field_70177_z, spawnPortal -> {
            double d0 = this.func_226277_ct_();
            double d1 = this.func_226278_cu_();
            double d2 = this.func_226281_cx_();
            float f = this.field_70125_A;
            float f1 = this.field_70177_z;
            double d3 = 8.0;
            float f2 = f1;
            serverworld.func_217381_Z().func_76320_a("moving");
            if (serverworld1[0] != null) {
                double moveFactor = serverworld.func_201675_m().getMovementFactor() / serverworld1[0].func_201675_m().getMovementFactor();
                d0 *= moveFactor;
                d2 *= moveFactor;
                if (dimensiontype == DimensionType.field_223227_a_ && destination[0] == DimensionType.field_223228_b_) {
                    this.field_193110_cw = this.func_213303_ch();
                } else if (dimensiontype == DimensionType.field_223227_a_ && destination[0] == DimensionType.field_223229_c_) {
                    BlockPos blockpos = serverworld1[0].func_180504_m();
                    d0 = blockpos.func_177958_n();
                    d1 = blockpos.func_177956_o();
                    d2 = blockpos.func_177952_p();
                    f1 = 90.0f;
                    f = 0.0f;
                }
            }
            Location enter = this.bridge$getBukkitEntity().getLocation();
            Location exit = serverworld1[0] == null ? null : new Location(((ServerWorldBridge)serverworld1[0]).bridge$getWorld(), d0, d1, d2, f1, f);
            PlayerPortalEvent event = new PlayerPortalEvent(this.bridge$getBukkitEntity(), enter, exit, cause, 128, true, ((DimensionTypeBridge)destination[0]).bridge$getType() == DimensionType.field_223229_c_ ? 0 : 16);
            Bukkit.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled() || event.getTo() == null) {
                return null;
            }
            exit = event.getTo();
            if (exit == null) {
                return null;
            }
            serverworld1[0] = ((CraftWorld)exit.getWorld()).getHandle();
            d0 = exit.getX();
            d1 = exit.getY();
            d2 = exit.getZ();
            serverworld.func_217381_Z().func_76319_b();
            serverworld.func_217381_Z().func_76320_a("placing");
            double d7 = Math.max(-2.9999872E7, serverworld1[0].func_175723_af().func_177726_b() + 16.0);
            double d4 = Math.max(-2.9999872E7, serverworld1[0].func_175723_af().func_177736_c() + 16.0);
            double d5 = Math.min(2.9999872E7, serverworld1[0].func_175723_af().func_177728_d() - 16.0);
            double d6 = Math.min(2.9999872E7, serverworld1[0].func_175723_af().func_177733_e() - 16.0);
            d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
            d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
            Vec3d exitVelocity = Vec3d.field_186680_a;
            BlockPos exitPosition = new BlockPos(d0, d1, d2);
            if (((DimensionTypeBridge)destination[0]).bridge$getType() == DimensionType.field_223229_c_) {
                int i = exitPosition.func_177958_n();
                int j = exitPosition.func_177956_o() - 1;
                int k = exitPosition.func_177952_p();
                if (event.getCanCreatePortal()) {
                    BlockStateListPopulator blockList = new BlockStateListPopulator((World)serverworld1[0]);
                    for (int j1 = -2; j1 <= 2; ++j1) {
                        for (int k1 = -2; k1 <= 2; ++k1) {
                            for (int l1 = -1; l1 < 3; ++l1) {
                                int i2 = i + k1 * 1 + j1 * 0;
                                int j2 = j + l1;
                                int k2 = k + k1 * 0 - j1 * 1;
                                boolean flag = l1 < 0;
                                blockList.func_180501_a(new BlockPos(i2, j2, k2), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 3);
                            }
                        }
                    }
                    CraftWorld bworld = ((ServerWorldBridge)serverworld1[0]).bridge$getWorld();
                    PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), bworld, this.bridge$getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
                    Bukkit.getPluginManager().callEvent(portalEvent);
                    if (!portalEvent.isCancelled()) {
                        blockList.updateList();
                    }
                }
                exit.setX(i);
                exit.setY(j);
                exit.setZ(k);
                exitVelocity = Vec3d.field_186680_a;
            } else {
                BlockPattern.PortalInfo portalInfo = ((TeleporterBridge)serverworld1[0].func_85176_s()).bridge$placeInPortal((Entity)((ServerPlayerEntity)this), exitPosition, f2, event.getSearchRadius(), true);
                if (spawnPortal.booleanValue() && portalInfo == null && event.getCanCreatePortal() && ((TeleporterBridge)serverworld1[0].func_85176_s()).bridge$makePortal((Entity)((ServerPlayerEntity)this), exitPosition, event.getCreationRadius())) {
                    portalInfo = ((TeleporterBridge)serverworld1[0].func_85176_s()).bridge$placeInPortal((Entity)((ServerPlayerEntity)this), exitPosition, f2, event.getSearchRadius(), true);
                }
                if (portalInfo != null) {
                    exitVelocity = portalInfo.field_222506_b;
                    exit.setX(portalInfo.field_222505_a.func_82615_a());
                    exit.setY(portalInfo.field_222505_a.func_82617_b());
                    exit.setZ(portalInfo.field_222505_a.func_82616_c());
                    exit.setYaw(f2 + (float)portalInfo.field_222507_c);
                }
            }
            serverworld.func_217381_Z().func_76319_b();
            PlayerTeleportEvent tpEvent = new PlayerTeleportEvent(this.bridge$getBukkitEntity(), enter, exit, cause);
            Bukkit.getServer().getPluginManager().callEvent(tpEvent);
            if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
                return null;
            }
            exit = tpEvent.getTo();
            if (exit == null) {
                return null;
            }
            this.field_184851_cj = true;
            ServerWorld newWorld = ((CraftWorld)exit.getWorld()).getHandle();
            if (newWorld != serverworld1[0]) {
                serverworld1[0].removePlayer((ServerPlayerEntity)this, true);
                this.revive();
                serverworld1[0] = newWorld;
                destination[0] = newWorld.func_201675_m().func_186058_p();
                this.field_71093_bK = destination[0];
                WorldInfo worldinfo = serverworld1[0].func_72912_H();
                NetworkHooks.sendDimensionDataPacket((NetworkManager)this.field_71135_a.field_147371_a, (ServerPlayerEntity)((ServerPlayerEntity)this));
                this.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination[0], WorldInfo.func_227498_c_((long)worldinfo.func_76063_b()), worldinfo.func_76067_t(), this.field_71134_c.func_73081_b()));
                this.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
                this.field_71133_b.func_184103_al().func_187243_f((ServerPlayerEntity)this);
            }
            this.func_213317_d(exitVelocity);
            this.func_70029_a((World)newWorld);
            newWorld.func_217447_b((ServerPlayerEntity)this);
            this.func_213846_b(serverworld);
            ((ServerPlayNetHandlerBridge)this.field_71135_a).bridge$teleport(exit);
            this.field_71135_a.func_184342_d();
            return (ServerPlayerEntity)this;
        });
        if (e == null) {
            this.field_71093_bK = dimensiontype;
            serverworld.func_217447_b((ServerPlayerEntity)this);
            return (ServerPlayerEntity)this;
        }
        if (e != this) {
            throw new IllegalArgumentException(String.format("Teleporter %s returned not the player entity but instead %s, expected PlayerEntity %s", teleporter, e, this));
        }
        this.field_71134_c.func_73080_a(this.func_71121_q());
        this.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(this.field_71075_bZ));
        this.field_71133_b.func_184103_al().func_72354_b((ServerPlayerEntity)this, this.func_71121_q());
        this.field_71133_b.func_184103_al().func_72385_f((ServerPlayerEntity)this);
        for (EffectInstance effectinstance : this.func_70651_bq()) {
            this.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(this.func_145782_y(), effectinstance));
        }
        this.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)((ServerPlayerEntity)this), (DimensionType)dimensiontype, (DimensionType)destination[0]);
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.bridge$getBukkitEntity(), ((WorldBridge)serverworld).bridge$getWorld());
        Bukkit.getPluginManager().callEvent(changeEvent);
        return (ServerPlayerEntity)this;
    }

    public Entity a(DimensionType dimensionmanager, PlayerTeleportEvent.TeleportCause cause) {
        this.bridge$pushChangeDimensionCause(cause);
        return this.func_212321_a(dimensionmanager);
    }

    @Override
    public Either<PlayerEntity.SleepResult, Unit> sleep(BlockPos at, boolean force) {
        return super.sleep(at, force).ifRight(p_213849_1_ -> {
            this.func_195066_a(Stats.field_188064_ad);
            CriteriaTriggers.field_192136_p.func_192215_a((ServerPlayerEntity)this);
        });
    }

    @Inject(method={"stopSleepInBed"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$notWake(boolean flag, boolean flag1, CallbackInfo ci) {
        if (!this.func_70608_bn()) {
            ci.cancel();
        }
    }

    @Override
    public Entity bridge$changeDimension(DimensionType dimensionType, PlayerTeleportEvent.TeleportCause cause) {
        return this.a(dimensionType, cause);
    }

    public BlockPos getSpawnPoint(ServerWorld worldserver) {
        BlockPos blockposition = worldserver.func_175694_M();
        if (worldserver.field_73011_w.func_191066_m() && worldserver.func_72912_H().func_76077_q() != GameType.ADVENTURE) {
            int i = Math.max(0, this.field_71133_b.func_184108_a(worldserver));
            int j = MathHelper.func_76128_c((double)worldserver.func_175723_af().func_177729_b((double)blockposition.func_177958_n(), (double)blockposition.func_177952_p()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            int k = (i * 2 + 1) * (i * 2 + 1);
            int l = this.func_205735_q(k);
            int i2 = new Random().nextInt(k);
            for (int j2 = 0; j2 < k; ++j2) {
                int k2 = (i2 + l * j2) % k;
                int l2 = k2 % (i * 2 + 1);
                int i3 = k2 / (i * 2 + 1);
                BlockPos blockposition2 = worldserver.func_201675_m().func_206921_a(blockposition.func_177958_n() + l2 - i, blockposition.func_177952_p() + i3 - i, false);
                if (blockposition2 == null) continue;
                return blockposition2;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPos bridge$getSpawnPoint(ServerWorld world) {
        return this.getSpawnPoint(world);
    }

    @Inject(method={"readAdditional"}, at={@At(value="RETURN")})
    private void arclight$readExtra(CompoundNBT compound, CallbackInfo ci) {
        this.getBukkitEntity().readExtraData(compound);
    }

    @Redirect(method={"writeAdditional"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isOnePlayerRiding()Z"))
    private boolean arclight$nonPersistVehicle(Entity entity) {
        Entity entity1 = this.func_184187_bx();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.func_184187_bx()) {
                if (((EntityBridge)vehicle).bridge$isPersist()) continue;
                persistVehicle = false;
                break;
            }
        }
        return persistVehicle && entity.func_200601_bK();
    }

    @Inject(method={"writeAdditional"}, at={@At(value="RETURN")})
    private void arclight$writeExtra(CompoundNBT compound, CallbackInfo ci) {
        this.getBukkitEntity().setExtraData(compound);
    }

    @Override
    public void func_70029_a(World world) {
        super.func_70029_a(world);
        if (world == null) {
            CraftWorld cworld;
            this.field_70128_L = false;
            Vec3d position = null;
            if (this.spawnWorld != null && !this.spawnWorld.equals("") && (cworld = (CraftWorld)Bukkit.getServer().getWorld(this.spawnWorld)) != null && this.func_180470_cg() != null) {
                world = cworld.getHandle();
                position = PlayerEntity.func_213822_a((IWorldReader)cworld.getHandle(), (BlockPos)this.func_180470_cg(), (boolean)false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = new Vec3d((Vec3i)world.func_175694_M());
            }
            this.field_70170_p = world;
            this.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        }
        this.field_71093_bK = this.field_70170_p.func_201675_m().func_186058_p();
        this.field_71134_c.func_73080_a((ServerWorld)world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void arclight$joining(CallbackInfo ci) {
        if (this.joining) {
            this.joining = false;
        }
    }

    @Inject(method={"playerTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void arclight$returnIfDisconnected(CallbackInfo ci) {
        if (this.field_193109_cv) {
            ci.cancel();
        }
    }

    @Redirect(method={"playerTick"}, at=@At(value="NEW", target="net/minecraft/network/play/server/SUpdateHealthPacket"))
    private SUpdateHealthPacket arclight$useScaledHealth(float healthIn, int foodLevelIn, float saturationLevelIn) {
        return new SUpdateHealthPacket(this.getBukkitEntity().getScaledHealth(), foodLevelIn, saturationLevelIn);
    }

    @Inject(method={"playerTick"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/ServerPlayerEntity;ticksExisted:I")})
    private void arclight$updateHealthAndExp(CallbackInfo ci) {
        if (this.maxHealthCache != (double)this.func_110138_aP()) {
            this.getBukkitEntity().updateScaledHealth();
        }
        if (this.oldLevel == -1) {
            this.oldLevel = this.field_71068_ca;
        }
        if (this.oldLevel != this.field_71068_ca) {
            CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.field_71068_ca);
            this.oldLevel = this.field_71068_ca;
        }
    }

    @Override
    @Overwrite
    public void func_70645_a(DamageSource damagesource) {
        String deathMessage;
        PlayerInventory copyInv;
        boolean keepInventory;
        if (ForgeHooks.onLivingDeath((LivingEntity)((ServerPlayerEntity)this), (DamageSource)damagesource)) {
            return;
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l);
        if (this.field_70128_L) {
            return;
        }
        boolean bl = keepInventory = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || this.func_175149_v();
        if (keepInventory) {
            copyInv = this.field_71071_by;
        } else {
            copyInv = new PlayerInventory((PlayerEntity)((ServerPlayerEntity)this));
            copyInv.func_70455_b(this.field_71071_by);
        }
        this.func_213345_d(damagesource);
        ITextComponent defaultMessage = this.func_110142_aN().func_151521_b();
        String deathmessage = defaultMessage.getString();
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        Collection<ItemEntity> drops = this.captureDrops(null);
        if (drops != null) {
            for (ItemEntity entity : drops) {
                CraftItemStack craftItemStack = CraftItemStack.asCraftMirror(entity.func_92059_d());
                loot.add(craftItemStack);
            }
        }
        if (!keepInventory) {
            this.field_71071_by.func_70455_b(copyInv);
        }
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent((ServerPlayerEntity)this, loot, deathmessage, keepInventory);
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            ITextComponent itextcomponent = deathMessage.equals(deathmessage) ? this.func_110142_aN().func_151521_b() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.field_71135_a.func_211148_a((IPacket)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, itextcomponent), p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s2 = itextcomponent.func_212636_a(256);
                    TranslationTextComponent itextcomponent1 = new TranslationTextComponent("death.attack.message_too_long", new Object[]{new StringTextComponent(s2).func_211708_a(TextFormatting.YELLOW)});
                    ITextComponent itextcomponent2 = new TranslationTextComponent("death.attack.even_more_magic", new Object[]{this.func_145748_c_()}).func_211710_a(arg_0 -> ServerPlayerEntityMixin.lambda$null$2((ITextComponent)itextcomponent1, arg_0));
                    this.field_71135_a.func_147359_a((IPacket)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, itextcomponent2));
                }
            });
            Team scoreboardteambase = this.func_96124_cp();
            if (scoreboardteambase != null && scoreboardteambase.func_178771_j() != Team.Visible.ALWAYS) {
                if (scoreboardteambase.func_178771_j() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                    this.field_71133_b.func_184103_al().func_177453_a((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                } else if (scoreboardteambase.func_178771_j() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                    this.field_71133_b.func_184103_al().func_177452_b((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                }
            } else {
                this.field_71133_b.func_184103_al().func_148539_a(itextcomponent);
            }
        } else {
            this.field_71135_a.func_147359_a((IPacket)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED));
        }
        this.func_192030_dh();
        this.func_226294_cV_();
        if (!event.getKeepInventory()) {
            this.field_71071_by.func_174888_l();
        }
        this.func_175399_e((Entity)((ServerPlayerEntity)this));
        ((CraftScoreboardManager)Bukkit.getScoreboardManager()).getScoreboardScores(ScoreCriteria.field_96642_c, this.func_195047_I_(), Score::func_96648_a);
        LivingEntity entityliving = this.func_94060_bK();
        if (entityliving != null) {
            this.func_71029_a(Stats.field_199091_i.func_199076_b((Object)entityliving.func_200600_R()));
            entityliving.func_191956_a((Entity)((ServerPlayerEntity)this), this.field_70744_aE, damagesource);
            this.func_226298_f_(entityliving);
        }
        this.field_70170_p.func_72960_a((Entity)((ServerPlayerEntity)this), (byte)3);
        this.func_195066_a(Stats.field_188069_A);
        this.func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188098_h));
        this.func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
        this.func_110142_aN().func_94549_h();
    }

    @Redirect(method={"awardKillScore"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$useCustomScoreboard(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftServer)Bukkit.getServer()).getScoreboardManager().getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Redirect(method={"handleTeamKill"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$teamKill(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftServer)Bukkit.getServer()).getScoreboardManager().getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Inject(method={"canPlayersAttack"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$pvpMode(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)((WorldBridge)this.field_70170_p).bridge$isPvpMode());
    }

    public int nextContainerCounter() {
        this.func_71117_bO();
        return this.field_71139_cq;
    }

    @Inject(method={"openContainer"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/inventory/container/INamedContainerProvider;createMenu(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/inventory/container/Container;")})
    private void arclight$invOpen(INamedContainerProvider itileinventory, CallbackInfoReturnable<OptionalInt> cir, Container container) {
        if (container != null) {
            ((ContainerBridge)container).bridge$setTitle(itileinventory.func_145748_c_());
            boolean cancelled = false;
            ArclightCaptures.captureContainerOwner((PlayerEntity)((ServerPlayerEntity)this));
            container = CraftEventFactory.callInventoryOpenEvent((ServerPlayerEntity)this, container, cancelled);
            ArclightCaptures.resetContainerOwner();
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)itileinventory).func_174886_c((PlayerEntity)((ServerPlayerEntity)this));
                } else if (ChestBlockDoubleInventoryHacks.isInstance(itileinventory)) {
                    ChestBlockDoubleInventoryHacks.get(itileinventory).func_174886_c((PlayerEntity)((ServerPlayerEntity)this));
                }
                cir.setReturnValue((Object)OptionalInt.empty());
            }
        }
    }

    @Overwrite
    public void func_184826_a(AbstractHorseEntity entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        HorseInventoryContainer container = new HorseInventoryContainer(this.field_71139_cq, this.field_71071_by, iinventory, entityhorseabstract);
        ((ContainerBridge)container).bridge$setTitle(entityhorseabstract.func_145748_c_());
        container = CraftEventFactory.callInventoryOpenEvent((ServerPlayerEntity)this, (Container)container);
        if (container == null) {
            iinventory.func_174886_c((PlayerEntity)((ServerPlayerEntity)this));
            return;
        }
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.field_71135_a.func_147359_a((IPacket)new SOpenHorseWindowPacket(this.field_71139_cq, iinventory.func_70302_i_(), entityhorseabstract.func_145782_y()));
        this.field_71070_bA = container;
        this.field_71070_bA.func_75132_a((IContainerListener)((ServerPlayerEntity)this));
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)((ServerPlayerEntity)this), this.field_71070_bA));
    }

    @Inject(method={"sendAllContents"}, at={@At(value="RETURN")})
    private void arclight$sendExtra(Container container, NonNullList<net.minecraft.item.ItemStack> itemsList, CallbackInfo ci) {
        ArclightCaptures.captureContainerOwner((PlayerEntity)((ServerPlayerEntity)this));
        if (EnumSet.of(InventoryType.CRAFTING, InventoryType.WORKBENCH).contains((Object)((ContainerBridge)container).bridge$getBukkitView().getType())) {
            this.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(container.field_75152_c, 0, container.func_75139_a(0).func_75211_c()));
        }
        ArclightCaptures.resetContainerOwner();
    }

    @Inject(method={"closeContainer"}, at={@At(value="HEAD")})
    private void arclight$invClose(CallbackInfo ci) {
        if (this.field_71070_bA != this.field_71069_bz) {
            CraftEventFactory.handleInventoryCloseEvent((PlayerEntity)((ServerPlayerEntity)this));
        }
    }

    @Redirect(method={"addStat"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$addStats(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftScoreboardManager)Bukkit.getScoreboardManager()).getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Redirect(method={"takeStat"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$takeStats(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftScoreboardManager)Bukkit.getScoreboardManager()).getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Inject(method={"setPlayerHealthUpdated"}, at={@At(value="HEAD")})
    private void arclight$setExpUpdate(CallbackInfo ci) {
        this.field_71144_ck = -1;
    }

    public void sendMessage(ITextComponent[] ichatbasecomponent) {
        for (ITextComponent component : ichatbasecomponent) {
            this.func_145747_a(component);
        }
    }

    @Override
    public void bridge$sendMessage(ITextComponent[] ichatbasecomponent) {
        this.sendMessage(ichatbasecomponent);
    }

    @Override
    public void bridge$sendMessage(ITextComponent component) {
        this.func_145747_a(component);
    }

    @Redirect(method={"copyFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/crafting/ServerRecipeBook;copyFrom(Lnet/minecraft/item/crafting/RecipeBook;)V"))
    private void arclight$noRecipeBookCopy(ServerRecipeBook serverRecipeBook, RecipeBook that) {
    }

    @Inject(method={"setGameType"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$gameModeChange(GameType gameType, CallbackInfo ci) {
        if (gameType == this.field_71134_c.func_73081_b()) {
            ci.cancel();
            return;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue(gameType.func_77148_a()));
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleClientSettings"}, at={@At(value="HEAD")})
    private void arclight$settingChange(CClientSettingsPacket packetIn, CallbackInfo ci) {
        if (this.func_184591_cq() != packetIn.func_186991_f()) {
            PlayerChangedMainHandEvent event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.func_184591_cq() == HandSide.LEFT ? MainHand.LEFT : MainHand.RIGHT);
            Bukkit.getPluginManager().callEvent(event);
        }
        if (!this.field_71148_cg.equals(packetIn.func_149524_c())) {
            PlayerLocaleChangeEvent event2 = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), packetIn.func_149524_c());
            Bukkit.getPluginManager().callEvent(event2);
        }
        this.clientViewDistance = packetIn.field_149528_b;
    }

    @Inject(method={"setSpectatingEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;setPositionAndUpdate(DDD)V")})
    private void arclight$spectatorReason(Entity entityToSpectate, CallbackInfo ci) {
        this.bridge$pushChangeDimensionCause(PlayerTeleportEvent.TeleportCause.SPECTATE);
    }

    @Overwrite
    @Nullable
    public ITextComponent func_175396_E() {
        return this.listName;
    }

    @Inject(method={"teleport"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/player/ServerPlayerEntity;stopRiding()V")})
    private void arclight$handleBy(ServerWorld world, double x, double y, double z, float yaw, float pitch, CallbackInfo ci) {
        PlayerTeleportEvent.TeleportCause cause = this.arclight$cause == null ? PlayerTeleportEvent.TeleportCause.UNKNOWN : this.arclight$cause;
        this.arclight$cause = null;
        this.getBukkitEntity().teleport(new Location(((WorldBridge)world).bridge$getWorld(), x, y, z, yaw, pitch), cause);
        ci.cancel();
    }

    public void a(ServerWorld worldserver, double d0, double d1, double d2, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.bridge$pushChangeDimensionCause(cause);
        this.func_200619_a(worldserver, d0, d1, d2, f, f1);
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)this.internal$getBukkitEntity();
    }

    @Override
    public CraftPlayer bridge$getBukkitEntity() {
        return (CraftPlayer)this.internal$getBukkitEntity();
    }

    @Override
    public void bridge$pushChangeDimensionCause(PlayerTeleportEvent.TeleportCause cause) {
        this.arclight$cause = cause;
    }

    @Override
    public Optional<PlayerTeleportEvent.TeleportCause> bridge$getTeleportCause() {
        try {
            Optional<PlayerTeleportEvent.TeleportCause> optional = Optional.ofNullable(this.arclight$cause);
            return optional;
        }
        finally {
            this.arclight$cause = null;
        }
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.field_70170_p.func_72820_D() + this.timeOffset;
        }
        return this.field_70170_p.func_72820_D() - this.field_70170_p.func_72820_D() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(2, 0.0f));
        } else {
            this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(1, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(7, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(7, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(8, newThunder));
            } else {
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(8, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (this.pluginRainPosition += 0.01f) : (this.pluginRainPosition -= 0.01f);
        this.pluginRainPosition = MathHelper.func_76131_a((float)this.pluginRainPosition, (float)0.0f, (float)1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.field_70170_p.func_72912_H().func_76059_o() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    public String toString() {
        return super.toString() + "(" + this.func_195047_I_() + " at " + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v + ")";
    }

    public void forceSetPositionRotation(double x, double y, double z, float yaw, float pitch) {
        this.func_70012_b(x, y, z, yaw, pitch);
        this.field_71135_a.func_184342_d();
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() || !this.getBukkitEntity().isOnline();
    }

    @Override
    public Scoreboard func_96123_co() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c);
        if (this.keepLevel || keepInventory) {
            exp = this.field_71106_cc;
            this.newTotalExp = this.field_71067_cb;
            this.newLevel = this.field_71068_ca;
        }
        this.func_70606_j(this.func_110138_aP());
        this.field_190534_ay = 0;
        this.field_70143_R = 0.0f;
        this.field_71100_bB = new FoodStats();
        ((FoodStatsBridge)this.field_71100_bB).bridge$setEntityHuman((PlayerEntity)((ServerPlayerEntity)this));
        this.field_71068_ca = this.newLevel;
        this.field_71067_cb = this.newTotalExp;
        this.field_71106_cc = 0.0f;
        this.field_70725_aQ = 0;
        this.func_85034_r(0);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.field_70752_e = true;
        this.field_71070_bA = this.field_71069_bz;
        this.field_70717_bb = null;
        this.field_70755_b = null;
        this.field_94063_bt = new CombatTracker((LivingEntity)((ServerPlayerEntity)this));
        this.field_71144_ck = -1;
        if (this.keepLevel || keepInventory) {
            this.field_71106_cc = exp;
        } else {
            this.func_195068_e(this.newExp);
        }
        this.keepLevel = false;
    }

    @Override
    public boolean bridge$isMovementBlocked() {
        return this.func_70610_aX();
    }

    @Override
    public void bridge$setCompassTarget(Location location) {
        this.compassTarget = location;
    }

    @Override
    public boolean bridge$isJoining() {
        return this.joining;
    }

    @Override
    public void bridge$reset() {
        this.reset();
    }

    private static /* synthetic */ void lambda$null$2(ITextComponent itextcomponent1, Style p_212357_1_) {
        p_212357_1_.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, itextcomponent1));
    }
}

