/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.item;

import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.util.DummyGeneratorAccess;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BucketItem.class})
public abstract class BucketItemMixin {
    private transient @Nullable ItemStack arclight$captureItem;
    private transient Direction arclight$direction;
    private transient BlockPos arclight$click;
    private transient net.minecraft.item.ItemStack arclight$stack;

    @Shadow
    public abstract boolean func_180616_a(@javax.annotation.Nullable PlayerEntity var1, World var2, BlockPos var3, @javax.annotation.Nullable BlockRayTraceResult var4);

    @Inject(method={"onItemRightClick"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/block/IBucketPickupHandler;pickupFluid(Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Lnet/minecraft/fluid/Fluid;")})
    private void arclight$bucketFill(World worldIn, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<net.minecraft.item.ItemStack>> cir, net.minecraft.item.ItemStack stack, RayTraceResult result) {
        BlockPos pos = ((BlockRayTraceResult)result).func_216350_a();
        BlockState state = worldIn.func_180495_p(pos);
        Fluid dummyFluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a(DummyGeneratorAccess.INSTANCE, pos, state);
        PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(worldIn, playerIn, pos, pos, ((BlockRayTraceResult)result).func_216354_b(), stack, dummyFluid.func_204524_b());
        if (event.isCancelled()) {
            ((ServerPlayerEntity)playerIn).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)worldIn, pos));
            ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().updateInventory();
            cir.setReturnValue((Object)new ActionResult(ActionResultType.FAIL, (Object)stack));
        } else {
            this.arclight$captureItem = event.getItemStack();
        }
    }

    @Inject(method={"onItemRightClick"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/item/BucketItem;tryPlaceContainedLiquid(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockRayTraceResult;)Z")})
    private void arclight$capture(World worldIn, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<net.minecraft.item.ItemStack>> cir, net.minecraft.item.ItemStack stack, RayTraceResult result) {
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
        this.arclight$direction = blockRayTraceResult.func_216354_b();
        this.arclight$click = blockRayTraceResult.func_216350_a();
        this.arclight$stack = stack;
    }

    @Inject(method={"onItemRightClick"}, at={@At(value="RETURN")})
    private void arclight$clean(World worldIn, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<net.minecraft.item.ItemStack>> cir) {
        this.arclight$captureItem = null;
        this.arclight$direction = null;
        this.arclight$click = null;
        this.arclight$stack = null;
    }

    @Redirect(method={"fillBucket"}, at=@At(value="NEW", target="net/minecraft/item/ItemStack"))
    private net.minecraft.item.ItemStack arclight$useCapture(IItemProvider fillBucket) {
        return this.arclight$captureItem == null ? new net.minecraft.item.ItemStack(fillBucket) : CraftItemStack.asNMSCopy(this.arclight$captureItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean a(PlayerEntity entity, World world, BlockPos pos, @Nullable BlockRayTraceResult result, Direction direction, BlockPos clicked, net.minecraft.item.ItemStack itemstack) {
        this.arclight$direction = direction;
        this.arclight$click = clicked;
        this.arclight$stack = itemstack;
        try {
            boolean bl = this.func_180616_a(entity, world, pos, result);
            return bl;
        }
        finally {
            this.arclight$direction = null;
            this.arclight$click = null;
            this.arclight$stack = null;
        }
    }

    @Inject(method={"tryPlaceContainedLiquid"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/dimension/Dimension;doesWaterVaporize()Z")})
    private void arclight$bucketEmpty(PlayerEntity player, World worldIn, BlockPos posIn, BlockRayTraceResult p_180616_4_, CallbackInfoReturnable<Boolean> cir) {
        PlayerBucketEmptyEvent event;
        if (player != null && (event = CraftEventFactory.callPlayerBucketEmptyEvent(worldIn, player, posIn, this.arclight$click, this.arclight$direction, this.arclight$stack)).isCancelled()) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)worldIn, posIn));
            ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity().updateInventory();
            cir.setReturnValue((Object)false);
        }
    }
}

