/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network.handshake;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UUIDTypeAdapter;
import io.izzel.arclight.common.bridge.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.network.login.ServerLoginNetHandlerBridge;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.ServerHandshakeNetHandler;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.status.ServerStatusNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.bukkit.Bukkit;
import org.spigotmc.SpigotConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerHandshakeNetHandler.class})
public class ServerHandshakeNetHandlerMixin {
    private static final Gson gson = new Gson();
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    @Shadow
    @Final
    private NetworkManager field_147386_b;
    @Shadow
    @Final
    private MinecraftServer field_147387_a;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_147383_a(CHandshakePacket packetIn) {
        if (!ServerLifecycleHooks.handleServerLogin((CHandshakePacket)packetIn, (NetworkManager)this.field_147386_b)) {
            return;
        }
        switch (packetIn.func_149594_c()) {
            case LOGIN: {
                this.field_147386_b.func_150723_a(ProtocolType.LOGIN);
                try {
                    long currentTime = System.currentTimeMillis();
                    long connectionThrottle = Bukkit.getServer().getConnectionThrottle();
                    InetAddress address = ((InetSocketAddress)this.field_147386_b.func_74430_c()).getAddress();
                    HashMap<InetAddress, Long> hashMap = throttleTracker;
                    synchronized (hashMap) {
                        if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                            throttleTracker.put(address, currentTime);
                            TranslationTextComponent component = new TranslationTextComponent("Connection throttled! Please wait before reconnecting.", new Object[0]);
                            this.field_147386_b.func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)component));
                            this.field_147386_b.func_150718_a((ITextComponent)component);
                            return;
                        }
                        throttleTracker.put(address, currentTime);
                        if (++throttleCounter > 200) {
                            throttleCounter = 0;
                            throttleTracker.entrySet().removeIf(entry -> (Long)entry.getValue() > connectionThrottle);
                        }
                    }
                }
                catch (Throwable t) {
                    LogManager.getLogger().debug("Failed to check connection throttle", t);
                }
                if (packetIn.func_149595_d() > SharedConstants.func_215069_a().getProtocolVersion()) {
                    TranslationTextComponent component = new TranslationTextComponent(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.func_215069_a().getName()), new Object[0]);
                    this.field_147386_b.func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)component));
                    this.field_147386_b.func_150718_a((ITextComponent)component);
                    break;
                }
                if (packetIn.func_149595_d() < SharedConstants.func_215069_a().getProtocolVersion()) {
                    TranslationTextComponent component = new TranslationTextComponent(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.func_215069_a().getName()), new Object[0]);
                    this.field_147386_b.func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)component));
                    this.field_147386_b.func_150718_a((ITextComponent)component);
                    break;
                }
                this.field_147386_b.func_150719_a((INetHandler)new ServerLoginNetHandler(this.field_147387_a, this.field_147386_b));
                if (SpigotConfig.bungee) {
                    String[] split = packetIn.field_149598_b.split("\u0000");
                    if (split.length != 3 && split.length != 4) {
                        TranslationTextComponent component = new TranslationTextComponent("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!", new Object[0]);
                        this.field_147386_b.func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)component));
                        this.field_147386_b.func_150718_a((ITextComponent)component);
                        return;
                    }
                    packetIn.field_149598_b = split[0];
                    this.field_147386_b.field_150743_l = new InetSocketAddress(split[1], ((InetSocketAddress)this.field_147386_b.func_74430_c()).getPort());
                    ((NetworkManagerBridge)this.field_147386_b).bridge$setSpoofedUUID(UUIDTypeAdapter.fromString((String)split[2]));
                    if (split.length == 4) {
                        ((NetworkManagerBridge)this.field_147386_b).bridge$setSpoofedProfile(gson.fromJson(split[3], Property[].class));
                    }
                }
                ((ServerLoginNetHandlerBridge)this.field_147386_b.func_150729_e()).bridge$setHostname(packetIn.field_149598_b + ":" + packetIn.field_149599_c);
                break;
            }
            case STATUS: {
                this.field_147386_b.func_150723_a(ProtocolType.STATUS);
                this.field_147386_b.func_150719_a((INetHandler)new ServerStatusNetHandler(this.field_147387_a, this.field_147386_b));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + packetIn.func_149594_c());
            }
        }
    }
}

