/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network.play;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.inventory.container.ContainerBridge;
import io.izzel.arclight.common.bridge.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.network.play.TimestampedPacket;
import io.izzel.arclight.common.bridge.server.MinecraftServerBridge;
import io.izzel.arclight.common.bridge.server.management.PlayerInteractionManagerBridge;
import io.izzel.arclight.common.bridge.tileentity.SignTileEntityBridge;
import io.izzel.arclight.common.mod.ArclightConstants;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ShortMap;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CConfirmTeleportPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CEditBookPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CResourcePackStatusPacket;
import net.minecraft.network.play.client.CSelectTradePacket;
import net.minecraft.network.play.client.CSpectatePacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SConfirmTransactionPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SSpawnMobPacket;
import net.minecraft.network.play.server.SSpawnPositionPacket;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_15_R1.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_15_R1.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.util.Vector;
import org.spigotmc.SpigotConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayNetHandler.class})
public abstract class ServerPlayNetHandlerMixin
implements ServerPlayNetHandlerBridge {
    @Shadow(aliases={"server", "field_147367_d"}, remap=false)
    @Final
    private MinecraftServer minecraftServer;
    @Shadow
    public ServerPlayerEntity field_147369_b;
    @Shadow
    @Final
    public NetworkManager field_147371_a;
    @Shadow
    private Entity field_184355_r;
    @Shadow
    private double field_184356_s;
    @Shadow
    private double field_184357_t;
    @Shadow
    private double field_184358_u;
    @Shadow
    private double field_184359_v;
    @Shadow
    private double field_184360_w;
    @Shadow
    private double field_184361_x;
    @Shadow
    private boolean field_184345_D;
    @Shadow
    private int field_184347_F;
    @Shadow
    private int field_184348_G;
    @Shadow
    private Vec3d field_184362_y;
    @Shadow
    private int field_147368_e;
    @Shadow
    private int field_184343_A;
    @Shadow
    private double field_184349_l;
    @Shadow
    private double field_184350_m;
    @Shadow
    private double field_184351_n;
    @Shadow
    @Final
    private static org.apache.logging.log4j.Logger field_147370_c;
    @Shadow
    private double field_184352_o;
    @Shadow
    private double field_184353_p;
    @Shadow
    private double field_184354_q;
    @Shadow
    private boolean field_184344_B;
    @Shadow
    private int field_184363_z;
    @Shadow
    private int field_147374_l;
    @Shadow
    @Final
    private Int2ShortMap field_147372_n;
    @Shadow
    private int field_147375_m;
    private static final int SURVIVAL_PLACE_DISTANCE_SQUARED = 36;
    private static final int CREATIVE_PLACE_DISTANCE_SQUARED = 49;
    private CraftServer server;
    public boolean processedDisconnect;
    private int allowedPlayerTicks;
    private int dropCount;
    private int lastTick;
    private int lastBookTick;
    private int lastDropTick;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private float lastPitch;
    private float lastYaw;
    private boolean justTeleported;
    private boolean hasMoved;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;
    private static final Set<String> sneakKeys;
    private static final Set<String> standKeys;
    private ITextComponent[] arclight$lines;
    private static final ResourceLocation CUSTOM_REGISTER;
    private static final ResourceLocation CUSTOM_UNREGISTER;
    private transient PlayerTeleportEvent.TeleportCause arclight$cause;

    @Shadow
    public abstract void func_147231_a(ITextComponent var1);

    @Shadow
    private static boolean func_184341_b(CMoveVehiclePacket packetIn) {
        return false;
    }

    @Shadow
    protected abstract boolean func_217264_d();

    @Shadow
    private static boolean func_183006_b(CPlayerPacket packetIn) {
        return false;
    }

    @Shadow
    public abstract void func_184342_d();

    @Shadow
    public abstract void func_147364_a(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    protected abstract boolean func_223133_a(IWorldReader var1);

    @Shadow
    public abstract void func_147359_a(IPacket<?> var1);

    public CraftPlayer getPlayer() {
        return this.field_147369_b == null ? null : ((ServerPlayerEntityBridge)this.field_147369_b).bridge$getBukkitEntity();
    }

    @Override
    public boolean bridge$processedDisconnect() {
        return this.processedDisconnect;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(MinecraftServer server, NetworkManager networkManagerIn, ServerPlayerEntity playerIn, CallbackInfo ci) {
        this.server = (CraftServer)Bukkit.getServer();
        this.allowedPlayerTicks = 1;
        this.dropCount = 0;
        this.lastPosX = Double.MAX_VALUE;
        this.lastPosY = Double.MAX_VALUE;
        this.lastPosZ = Double.MAX_VALUE;
        this.lastPitch = Float.MAX_VALUE;
        this.lastYaw = Float.MAX_VALUE;
        this.justTeleported = false;
    }

    @Overwrite
    public void func_194028_b(ITextComponent textComponent) {
        this.disconnect(CraftChatMessage.fromComponent(textComponent));
    }

    public void disconnect(String s2) {
        if (this.processedDisconnect) {
            return;
        }
        String leaveMessage = TextFormatting.YELLOW + this.field_147369_b.func_195047_I_() + " left the game.";
        PlayerKickEvent event = new PlayerKickEvent(this.server.getPlayer(this.field_147369_b), s2, leaveMessage);
        if (this.server.getServer().func_71278_l()) {
            this.server.getPluginManager().callEvent(event);
        }
        if (event.isCancelled()) {
            return;
        }
        s2 = event.getReason();
        StringTextComponent textComponent = new StringTextComponent(s2);
        this.field_147371_a.func_201058_a((IPacket)new SDisconnectPacket((ITextComponent)textComponent), future -> this.field_147371_a.func_150718_a((ITextComponent)textComponent));
        this.func_147231_a((ITextComponent)textComponent);
        this.field_147371_a.func_150721_g();
        this.minecraftServer.func_213167_f(() -> ((NetworkManager)this.field_147371_a).func_179293_l());
    }

    @Override
    public void bridge$disconnect(String str) {
        this.disconnect(str);
    }

    @Overwrite
    public void func_184338_a(CMoveVehiclePacket packetplayinvehiclemove) {
        PacketThreadUtil.func_218796_a((IPacket)packetplayinvehiclemove, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandlerMixin.func_184341_b(packetplayinvehiclemove)) {
            this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_vehicle_movement", new Object[0]));
        } else {
            Entity entity = this.field_147369_b.func_184208_bv();
            if (entity != this.field_147369_b && entity.func_184179_bs() == this.field_147369_b && entity == this.field_184355_r) {
                ServerWorld worldserver = this.field_147369_b.func_71121_q();
                double d0 = entity.field_70165_t;
                double d2 = entity.field_70163_u;
                double d3 = entity.field_70161_v;
                double d4 = packetplayinvehiclemove.func_187004_a();
                double d5 = packetplayinvehiclemove.func_187002_b();
                double d6 = packetplayinvehiclemove.func_187003_c();
                float f = packetplayinvehiclemove.func_187006_d();
                float f2 = packetplayinvehiclemove.func_187005_e();
                double d7 = d4 - this.field_184356_s;
                double d8 = d5 - this.field_184357_t;
                double d9 = d6 - this.field_184358_u;
                double d10 = entity.func_213322_ci().func_189985_c();
                double d11 = d7 * d7 + d8 * d8 + d9 * d9;
                this.allowedPlayerTicks += (int)(System.currentTimeMillis() / 50L - (long)this.lastTick);
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.field_184347_F;
                int i = this.field_184347_F - this.field_184348_G;
                if (i > Math.max(this.allowedPlayerTicks, 5)) {
                    field_147370_c.debug(this.field_147369_b.func_195047_I_() + " is sending move packets too frequently (" + i + " packets since last tick)");
                    i = 1;
                }
                this.allowedPlayerTicks = d11 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.field_147369_b.field_71075_bZ.field_75100_b ? (double)(this.field_147369_b.field_71075_bZ.field_75096_f * 20.0f) : (double)(this.field_147369_b.field_71075_bZ.field_75097_g * 10.0f);
                speed *= 2.0;
                if (d11 - d10 > Math.max(100.0, Math.pow((double)(10.0f * (float)i) * speed, 2.0)) && !this.func_217264_d()) {
                    field_147370_c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)d7, (Object)d8, (Object)d9);
                    this.field_147371_a.func_179290_a((IPacket)new SMoveVehiclePacket(entity));
                    return;
                }
                boolean flag = worldserver.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                d7 = d4 - this.field_184359_v;
                d8 = d5 - this.field_184360_w - 1.0E-6;
                d9 = d6 - this.field_184361_x;
                entity.func_213315_a(MoverType.PLAYER, new Vec3d(d7, d8, d9));
                double d12 = d8;
                d7 = d4 - entity.field_70165_t;
                d8 = d5 - entity.field_70163_u;
                if (d8 > -0.5 || d8 < 0.5) {
                    d8 = 0.0;
                }
                d9 = d6 - entity.field_70161_v;
                d11 = d7 * d7 + d8 * d8 + d9 * d9;
                boolean flag2 = false;
                if (d11 > 0.0625) {
                    flag2 = true;
                    field_147370_c.warn("{} moved wrongly!", (Object)entity.func_200200_C_().getString());
                }
                entity.func_70080_a(d4, d5, d6, f, f2);
                this.field_147369_b.func_70080_a(d4, d5, d6, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                boolean flag3 = worldserver.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                if (flag && (flag2 || !flag3)) {
                    entity.func_70080_a(d0, d2, d3, f, f2);
                    this.field_147369_b.func_70080_a(d0, d2, d3, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    this.field_147371_a.func_179290_a((IPacket)new SMoveVehiclePacket(entity));
                    return;
                }
                CraftPlayer player = this.getPlayer();
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(packetplayinvehiclemove.func_187004_a());
                to.setY(packetplayinvehiclemove.func_187002_b());
                to.setZ(packetplayinvehiclemove.func_187003_c());
                to.setYaw(packetplayinvehiclemove.func_187006_d());
                to.setPitch(packetplayinvehiclemove.func_187005_e());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    if (from.getX() != Double.MAX_VALUE) {
                        Location oldTo = to.clone();
                        PlayerMoveEvent event = new PlayerMoveEvent(player, from, to);
                        this.server.getPluginManager().callEvent(event);
                        if (event.isCancelled()) {
                            this.bridge$teleport(from);
                            return;
                        }
                        if (!oldTo.equals(event.getTo()) && !event.isCancelled()) {
                            ((ServerPlayerEntityBridge)this.field_147369_b).bridge$getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                            return;
                        }
                        if (!from.equals(this.getPlayer().getLocation()) && this.justTeleported) {
                            this.justTeleported = false;
                            return;
                        }
                    }
                }
                this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                this.field_147369_b.func_71000_j(this.field_147369_b.field_70165_t - d0, this.field_147369_b.field_70163_u - d2, this.field_147369_b.field_70161_v - d3);
                this.field_184345_D = d12 >= -0.03125 && !this.minecraftServer.func_71231_X() && !worldserver.func_72829_c(entity.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0));
                this.field_184359_v = entity.field_70165_t;
                this.field_184360_w = entity.field_70163_u;
                this.field_184361_x = entity.field_70161_v;
            }
        }
    }

    @Inject(method={"processConfirmTeleport"}, at={@At(value="FIELD", ordinal=6, shift=At.Shift.AFTER, target="Lnet/minecraft/network/play/ServerPlayNetHandler;targetPos:Lnet/minecraft/util/math/Vec3d;")})
    private void arclight$updateLoc(CConfirmTeleportPacket packetIn, CallbackInfo ci) {
        this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
    }

    @Inject(method={"processConfirmTeleport"}, cancellable=true, at={@At(value="FIELD", target="Lnet/minecraft/network/play/ServerPlayNetHandler;teleportId:I")})
    private void arclight$confirm(CConfirmTeleportPacket packetIn, CallbackInfo ci) {
        if (this.field_184362_y == null) {
            ci.cancel();
        }
    }

    @Inject(method={"processSelectTrade"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/container/MerchantContainer;setCurrentRecipeIndex(I)V")})
    private void arclight$tradeSelect(CSelectTradePacket packetIn, CallbackInfo ci, int i, Container container) {
        CraftEventFactory.callTradeSelectEvent(this.field_147369_b, i, (MerchantContainer)container);
    }

    @Overwrite
    public void func_210156_a(CEditBookPacket packetplayinbedit) {
        PacketThreadUtil.func_218796_a((IPacket)packetplayinbedit, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.lastBookTick == 0) {
            this.lastBookTick = ArclightConstants.currentTick - 20;
        }
        if (this.lastBookTick + 20 > ArclightConstants.currentTick) {
            this.disconnect("Book edited too quickly!");
            return;
        }
        this.lastBookTick = ArclightConstants.currentTick;
        EquipmentSlotType enumitemslot = packetplayinbedit.func_212644_d() == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
        net.minecraft.item.ItemStack itemstack = packetplayinbedit.func_210346_a();
        if (!itemstack.func_190926_b() && WritableBookItem.func_150930_a((CompoundNBT)itemstack.func_77978_p())) {
            net.minecraft.item.ItemStack itemstack2 = this.field_147369_b.func_184586_b(packetplayinbedit.func_212644_d());
            if (itemstack.func_77973_b() == Items.field_151099_bA && itemstack2.func_77973_b() == Items.field_151099_bA) {
                if (packetplayinbedit.func_210345_b()) {
                    net.minecraft.item.ItemStack itemstack3 = new net.minecraft.item.ItemStack((IItemProvider)Items.field_151164_bB);
                    CompoundNBT nbttagcompound = itemstack2.func_77978_p();
                    if (nbttagcompound != null) {
                        itemstack3.func_77982_d(nbttagcompound.func_74737_b());
                    }
                    itemstack3.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)this.field_147369_b.func_200200_C_().getString()));
                    itemstack3.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)itemstack.func_77978_p().func_74779_i("title")));
                    ListNBT nbttaglist = itemstack.func_77978_p().func_150295_c("pages", 8);
                    for (int i = 0; i < nbttaglist.size(); ++i) {
                        String s2 = nbttaglist.func_150307_f(i);
                        StringTextComponent chatcomponenttext = new StringTextComponent(s2);
                        s2 = ITextComponent.Serializer.func_150696_a((ITextComponent)chatcomponenttext);
                        nbttaglist.set(i, (INBT)StringNBT.func_229705_a_((String)s2));
                    }
                    itemstack3.func_77983_a("pages", (INBT)nbttaglist);
                    this.field_147369_b.func_184611_a(packetplayinbedit.func_212644_d(), CraftEventFactory.handleEditBookEvent(this.field_147369_b, enumitemslot, itemstack2, itemstack3));
                } else {
                    net.minecraft.item.ItemStack old = itemstack2.func_77946_l();
                    itemstack2.func_77983_a("pages", (INBT)itemstack.func_77978_p().func_150295_c("pages", 8));
                    CraftEventFactory.handleEditBookEvent(this.field_147369_b, enumitemslot, old, itemstack2);
                }
            }
        }
    }

    @Overwrite
    public void func_147347_a(CPlayerPacket packetplayinflying) {
        PacketThreadUtil.func_218796_a((IPacket)packetplayinflying, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandlerMixin.func_183006_b(packetplayinflying)) {
            this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_player_movement", new Object[0]));
        } else {
            ServerWorld worldserver = this.minecraftServer.func_71218_a(this.field_147369_b.field_71093_bK);
            if (!this.field_147369_b.field_71136_j && !((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
                if (this.field_147368_e == 0) {
                    this.func_184342_d();
                }
                if (this.field_184362_y != null) {
                    if (this.field_147368_e - this.field_184343_A > 20) {
                        this.field_184343_A = this.field_147368_e;
                        this.func_147364_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    }
                    this.allowedPlayerTicks = 20;
                } else {
                    this.field_184343_A = this.field_147368_e;
                    if (this.field_147369_b.func_184218_aH()) {
                        this.field_147369_b.func_70080_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, packetplayinflying.func_186999_a(this.field_147369_b.field_70177_z), packetplayinflying.func_186998_b(this.field_147369_b.field_70125_A));
                        this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.field_147369_b.field_70165_t;
                        double prevY = this.field_147369_b.field_70163_u;
                        double prevZ = this.field_147369_b.field_70161_v;
                        float prevYaw = this.field_147369_b.field_70177_z;
                        float prevPitch = this.field_147369_b.field_70125_A;
                        double d0 = this.field_147369_b.field_70165_t;
                        double d2 = this.field_147369_b.field_70163_u;
                        double d3 = this.field_147369_b.field_70161_v;
                        double d4 = this.field_147369_b.field_70163_u;
                        double d5 = packetplayinflying.func_186997_a(this.field_147369_b.field_70165_t);
                        double d6 = packetplayinflying.func_186996_b(this.field_147369_b.field_70163_u);
                        double d7 = packetplayinflying.func_187000_c(this.field_147369_b.field_70161_v);
                        float f = packetplayinflying.func_186999_a(this.field_147369_b.field_70177_z);
                        float f2 = packetplayinflying.func_186998_b(this.field_147369_b.field_70125_A);
                        double d8 = d5 - this.field_184349_l;
                        double d9 = d6 - this.field_184350_m;
                        double d10 = d7 - this.field_184351_n;
                        double d11 = this.field_147369_b.func_213322_ci().func_189985_c();
                        double d12 = d8 * d8 + d9 * d9 + d10 * d10;
                        if (this.field_147369_b.func_70608_bn()) {
                            if (d12 > 1.0) {
                                this.func_147364_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, packetplayinflying.func_186999_a(this.field_147369_b.field_70177_z), packetplayinflying.func_186998_b(this.field_147369_b.field_70125_A));
                            }
                        } else {
                            ++this.field_184347_F;
                            int i = this.field_184347_F - this.field_184348_G;
                            this.allowedPlayerTicks += (int)(System.currentTimeMillis() / 50L - (long)this.lastTick);
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i > Math.max(this.allowedPlayerTicks, 5)) {
                                field_147370_c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)i);
                                i = 1;
                            }
                            this.allowedPlayerTicks = packetplayinflying.field_149481_i || d12 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.field_147369_b.field_71075_bZ.field_75100_b ? (double)(this.field_147369_b.field_71075_bZ.field_75096_f * 20.0f) : (double)(this.field_147369_b.field_71075_bZ.field_75097_g * 10.0f);
                            if (!(this.field_147369_b.func_184850_K() || this.field_147369_b.func_71121_q().func_82736_K().func_223586_b(GameRules.field_223615_r) && this.field_147369_b.func_184613_cA())) {
                                float f3;
                                float f4 = f3 = this.field_147369_b.func_184613_cA() ? 300.0f : 100.0f;
                                if (d12 - d11 > Math.max((double)f3, Math.pow((double)(10.0f * (float)i) * speed, 2.0)) && !this.func_217264_d()) {
                                    field_147370_c.warn("{} moved too quickly! {},{},{}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)d8, (Object)d9, (Object)d10);
                                    this.func_147364_a(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                                    return;
                                }
                            }
                            boolean flag = this.func_223133_a((IWorldReader)worldserver);
                            d8 = d5 - this.field_184352_o;
                            d9 = d6 - this.field_184353_p;
                            d10 = d7 - this.field_184354_q;
                            if (d9 > 0.0) {
                                this.field_147369_b.field_70143_R = 0.0f;
                            }
                            if (this.field_147369_b.field_70122_E && !packetplayinflying.func_149465_i() && d9 > 0.0) {
                                this.field_147369_b.func_70664_aZ();
                            }
                            this.field_147369_b.func_213315_a(MoverType.PLAYER, new Vec3d(d8, d9, d10));
                            this.field_147369_b.field_70122_E = packetplayinflying.func_149465_i();
                            double d13 = d9;
                            d8 = d5 - this.field_147369_b.field_70165_t;
                            d9 = d6 - this.field_147369_b.field_70163_u;
                            if (d9 > -0.5 || d9 < 0.5) {
                                d9 = 0.0;
                            }
                            d10 = d7 - this.field_147369_b.field_70161_v;
                            d12 = d8 * d8 + d9 * d9 + d10 * d10;
                            boolean flag2 = false;
                            if (!this.field_147369_b.func_184850_K() && d12 > 0.0625 && !this.field_147369_b.func_70608_bn() && !this.field_147369_b.field_71134_c.func_73083_d() && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR) {
                                flag2 = true;
                                field_147370_c.warn("{} moved wrongly!", (Object)this.field_147369_b.func_200200_C_().getString());
                            }
                            this.field_147369_b.func_70080_a(d5, d6, d7, f, f2);
                            this.field_147369_b.func_71000_j(this.field_147369_b.field_70165_t - d0, this.field_147369_b.field_70163_u - d2, this.field_147369_b.field_70161_v - d3);
                            if (!this.field_147369_b.field_70145_X && !this.field_147369_b.func_70608_bn()) {
                                boolean flag3 = this.func_223133_a((IWorldReader)worldserver);
                                if (flag && (flag2 || !flag3)) {
                                    this.func_147364_a(d0, d2, d3, f, f2);
                                    return;
                                }
                            }
                            this.field_147369_b.func_70080_a(prevX, prevY, prevZ, prevYaw, prevPitch);
                            CraftPlayer player = this.getPlayer();
                            Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                            Location to = player.getLocation().clone();
                            if (packetplayinflying.field_149480_h) {
                                to.setX(packetplayinflying.field_149479_a);
                                to.setY(packetplayinflying.field_149477_b);
                                to.setZ(packetplayinflying.field_149478_c);
                            }
                            if (packetplayinflying.field_149481_i) {
                                to.setYaw(packetplayinflying.field_149476_e);
                                to.setPitch(packetplayinflying.field_149473_f);
                            }
                            double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                            float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                            if ((delta > 0.00390625 || deltaAngle > 10.0f) && !((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
                                this.lastPosX = to.getX();
                                this.lastPosY = to.getY();
                                this.lastPosZ = to.getZ();
                                this.lastYaw = to.getYaw();
                                this.lastPitch = to.getPitch();
                                if (from.getX() != Double.MAX_VALUE) {
                                    Location oldTo = to.clone();
                                    PlayerMoveEvent event = new PlayerMoveEvent(player, from, to);
                                    this.server.getPluginManager().callEvent(event);
                                    if (event.isCancelled()) {
                                        this.teleport(from);
                                        return;
                                    }
                                    if (!oldTo.equals(event.getTo()) && !event.isCancelled()) {
                                        ((ServerPlayerEntityBridge)this.field_147369_b).bridge$getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                        return;
                                    }
                                    if (!from.equals(this.getPlayer().getLocation()) && this.justTeleported) {
                                        this.justTeleported = false;
                                        return;
                                    }
                                }
                            }
                            this.field_147369_b.func_70080_a(d5, d6, d7, f, f2);
                            this.field_184344_B = d13 >= -0.03125 && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR && !this.minecraftServer.func_71231_X() && !this.field_147369_b.field_71075_bZ.field_75101_c && !this.field_147369_b.func_70644_a(Effects.field_188424_y) && !this.field_147369_b.func_184613_cA() && !worldserver.func_72829_c(this.field_147369_b.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0)) && !this.field_147369_b.func_204805_cN();
                            this.field_147369_b.field_70122_E = packetplayinflying.func_149465_i();
                            this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                            this.field_147369_b.func_71122_b(this.field_147369_b.field_70163_u - d4, packetplayinflying.func_149465_i());
                            this.field_184352_o = this.field_147369_b.field_70165_t;
                            this.field_184353_p = this.field_147369_b.field_70163_u;
                            this.field_184354_q = this.field_147369_b.field_70161_v;
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"onDisconnect"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnIfProcessed(ITextComponent reason, CallbackInfo ci) {
        if (this.processedDisconnect) {
            ci.cancel();
        } else {
            this.processedDisconnect = true;
        }
    }

    @Redirect(method={"onDisconnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V"))
    public void arclight$captureQuit(PlayerList playerList, ITextComponent component) {
    }

    @Inject(method={"onDisconnect"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/management/PlayerList;playerLoggedOut(Lnet/minecraft/entity/player/ServerPlayerEntity;)V")})
    public void arclight$processQuit(ITextComponent reason, CallbackInfo ci) {
        String quitMessage = ArclightCaptures.getQuitMessage();
        if (quitMessage != null) {
            for (ITextComponent component : CraftChatMessage.fromString(quitMessage)) {
                this.minecraftServer.func_184103_al().func_148544_a(component, true);
            }
        }
    }

    @Overwrite
    public void func_147345_a(CPlayerDiggingPacket packetplayinblockdig) {
        PacketThreadUtil.func_218796_a((IPacket)packetplayinblockdig, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            return;
        }
        BlockPos blockposition = packetplayinblockdig.func_179715_a();
        this.field_147369_b.func_143004_u();
        CPlayerDiggingPacket.Action packetplayinblockdig_enumplayerdigtype = packetplayinblockdig.func_180762_c();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case SWAP_HELD_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    net.minecraft.item.ItemStack itemstack = this.field_147369_b.func_184586_b(Hand.OFF_HAND);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.field_147369_b.func_184586_b(Hand.MAIN_HAND));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent(this.getPlayer(), mainHand.clone(), offHand.clone());
                    this.server.getPluginManager().callEvent(swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals(offHand)) {
                        this.field_147369_b.func_184611_a(Hand.OFF_HAND, this.field_147369_b.func_184586_b(Hand.MAIN_HAND));
                    } else {
                        this.field_147369_b.func_184611_a(Hand.OFF_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals(mainHand)) {
                        this.field_147369_b.func_184611_a(Hand.MAIN_HAND, itemstack);
                    } else {
                        this.field_147369_b.func_184611_a(Hand.MAIN_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.field_147369_b.func_175149_v()) {
                    if (this.lastDropTick != ArclightConstants.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = ArclightConstants.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            field_147370_c.warn(this.field_147369_b.func_195047_I_() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)");
                            return;
                        }
                    }
                    this.field_147369_b.func_225609_n_(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_225609_n_(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.field_147369_b.func_184597_cx();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.field_147369_b.field_71134_c.func_225416_a(blockposition, packetplayinblockdig_enumplayerdigtype, packetplayinblockdig.func_179714_b(), this.minecraftServer.func_71207_Z());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    @Inject(method={"processTryUseItemOnBlock"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorld(Lnet/minecraft/world/dimension/DimensionType;)Lnet/minecraft/world/server/ServerWorld;")})
    private void arclight$frozenUseItem(CPlayerTryUseItemOnBlockPacket packetIn, CallbackInfo ci) {
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            ci.cancel();
        }
        if (!this.checkLimit(((TimestampedPacket)packetIn).bridge$timestamp())) {
            ci.cancel();
        }
    }

    @Inject(method={"processTryUseItemOnBlock"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerInteractionManager;func_219441_a(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/Hand;Lnet/minecraft/util/math/BlockRayTraceResult;)Lnet/minecraft/util/ActionResultType;")})
    private void arclight$checkDistance(CPlayerTryUseItemOnBlockPacket packetIn, CallbackInfo ci, ServerWorld serverWorld, Hand hand, net.minecraft.item.ItemStack itemStack, BlockRayTraceResult rayTraceResult, BlockPos blockPos) {
        this.field_147369_b.func_184597_cx();
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Overwrite
    public void func_147346_a(CPlayerTryUseItemPacket packet) {
        PacketThreadUtil.func_218796_a((IPacket)packet, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            return;
        }
        if (!this.checkLimit(((TimestampedPacket)packet).bridge$timestamp())) {
            return;
        }
        ServerWorld worldserver = this.minecraftServer.func_71218_a(this.field_147369_b.field_71093_bK);
        Hand enumhand = packet.func_187028_a();
        net.minecraft.item.ItemStack itemstack = this.field_147369_b.func_184586_b(enumhand);
        this.field_147369_b.func_143004_u();
        if (!itemstack.func_190926_b()) {
            boolean cancelled;
            float f1 = this.field_147369_b.field_70125_A;
            float f2 = this.field_147369_b.field_70177_z;
            double d0 = this.field_147369_b.field_70165_t;
            double d2 = this.field_147369_b.field_70163_u + (double)this.field_147369_b.func_70047_e();
            double d3 = this.field_147369_b.field_70161_v;
            Vec3d vec3d = new Vec3d(d0, d2, d3);
            float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d4 = this.field_147369_b.field_71134_c.func_73081_b() == GameType.CREATIVE ? 5.0 : 4.5;
            Vec3d vec3d2 = vec3d.func_72441_c((double)f7 * d4, (double)f6 * d4, (double)f8 * d4);
            BlockRayTraceResult movingobjectposition = this.field_147369_b.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.field_147369_b));
            if (movingobjectposition == null || movingobjectposition.func_216346_c() != RayTraceResult.Type.BLOCK) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_147369_b, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else if (((PlayerInteractionManagerBridge)this.field_147369_b.field_71134_c).bridge$isFiredInteract()) {
                ((PlayerInteractionManagerBridge)this.field_147369_b.field_71134_c).bridge$setFiredInteract(false);
                cancelled = ((PlayerInteractionManagerBridge)this.field_147369_b.field_71134_c).bridge$getInteractResult();
            } else {
                BlockRayTraceResult movingobjectpositionblock = movingobjectposition;
                PlayerInteractEvent event2 = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_147369_b, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.func_216350_a(), movingobjectpositionblock.func_216354_b(), itemstack, true, enumhand);
                boolean bl = cancelled = event2.useItemInHand() == Event.Result.DENY;
            }
            if (cancelled) {
                ((ServerPlayerEntityBridge)this.field_147369_b).bridge$getBukkitEntity().updateInventory();
            } else {
                this.field_147369_b.field_71134_c.func_187250_a((PlayerEntity)this.field_147369_b, (World)worldserver, itemstack, enumhand);
            }
        }
    }

    @Inject(method={"handleSpectate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;teleport(Lnet/minecraft/world/server/ServerWorld;DDDFF)V")})
    private void arclight$spectateTeleport(CSpectatePacket packetIn, CallbackInfo ci) {
        ((ServerPlayerEntityBridge)this.field_147369_b).bridge$pushChangeDimensionCause(PlayerTeleportEvent.TeleportCause.SPECTATE);
    }

    @Inject(method={"handleResourcePackStatus"}, at={@At(value="HEAD")})
    private void arclight$handleResourcePackStatus(CResourcePackStatusPacket packetIn, CallbackInfo ci) {
        PacketThreadUtil.func_218796_a((IPacket)packetIn, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        this.server.getPluginManager().callEvent(new PlayerResourcePackStatusEvent((Player)this.getPlayer(), PlayerResourcePackStatusEvent.Status.values()[packetIn.field_179719_b.ordinal()]));
    }

    @Inject(method={"sendPacket(Lnet/minecraft/network/IPacket;Lio/netty/util/concurrent/GenericFutureListener;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$updateCompassTarget(IPacket<?> packetIn, GenericFutureListener<? extends Future<? super Void>> futureListeners, CallbackInfo ci) {
        if (!(packetIn instanceof SChatPacket)) {
            if (packetIn == null || this.processedDisconnect) {
                ci.cancel();
                return;
            }
            if (packetIn instanceof SSpawnPositionPacket) {
                SSpawnPositionPacket packet2 = (SSpawnPositionPacket)packetIn;
                ((ServerPlayerEntityBridge)this.field_147369_b).bridge$setCompassTarget(new Location(this.getPlayer().getWorld(), packet2.field_179801_a.func_177958_n(), packet2.field_179801_a.func_177956_o(), packet2.field_179801_a.func_177952_p()));
            }
        }
    }

    @Overwrite
    public void func_147355_a(CHeldItemChangePacket packet) {
        PacketThreadUtil.func_218796_a((IPacket)packet, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            return;
        }
        if (packet.func_149614_c() >= 0 && packet.func_149614_c() < PlayerInventory.func_70451_h()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent(this.getPlayer(), this.field_147369_b.field_71071_by.field_70461_c, packet.func_149614_c());
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                this.func_147359_a((IPacket<?>)new SHeldItemChangePacket(this.field_147369_b.field_71071_by.field_70461_c));
                this.field_147369_b.func_143004_u();
                return;
            }
            this.field_147369_b.field_71071_by.field_70461_c = packet.func_149614_c();
            this.field_147369_b.func_143004_u();
        } else {
            field_147370_c.warn("{} tried to set an invalid carried item", (Object)this.field_147369_b.func_200200_C_().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_147354_a(CChatMessagePacket packet) {
        if (this.minecraftServer.func_71241_aa()) {
            return;
        }
        boolean isSync = packet.func_149439_c().startsWith("/");
        if (packet.func_149439_c().startsWith("/")) {
            PacketThreadUtil.func_218796_a((IPacket)packet, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        }
        if (this.field_147369_b.field_70128_L || this.field_147369_b.func_147096_v() == ChatVisibility.HIDDEN) {
            this.func_147359_a((IPacket<?>)new SChatPacket(new TranslationTextComponent("chat.cannotSend", new Object[0]).func_211708_a(TextFormatting.RED)));
        } else {
            this.field_147369_b.func_143004_u();
            String s2 = packet.func_149439_c();
            s2 = StringUtils.normalizeSpace((String)s2);
            for (int i = 0; i < s2.length(); ++i) {
                if (SharedConstants.func_71566_a((char)s2.charAt(i))) continue;
                if (!isSync) {
                    class Disconnect
                    extends Waitable {
                        Disconnect() {
                        }

                        protected Object evaluate() {
                            ServerPlayNetHandlerMixin.this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.illegal_characters", new Object[0]));
                            return null;
                        }
                    }
                    Disconnect waitable = new Disconnect();
                    ((MinecraftServerBridge)this.minecraftServer).bridge$queuedProcess(waitable);
                    try {
                        waitable.get();
                        return;
                    }
                    catch (InterruptedException e3) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.illegal_characters", new Object[0]));
                return;
            }
            if (isSync) {
                try {
                    this.server.playerCommandState = true;
                    this.func_147361_d(s2);
                }
                finally {
                    this.server.playerCommandState = false;
                }
                this.server.playerCommandState = false;
            } else if (s2.isEmpty()) {
                field_147370_c.warn(this.field_147369_b.func_195047_I_() + " tried to send an empty message");
            } else if (this.getPlayer().isConversing()) {
                String conversationInput = s2;
                ((MinecraftServerBridge)this.minecraftServer).bridge$queuedProcess(() -> this.getPlayer().acceptConversationInput(conversationInput));
            } else if (this.field_147369_b.func_147096_v() == ChatVisibility.SYSTEM) {
                TranslationTextComponent chatmessage = new TranslationTextComponent("chat.cannotSend", new Object[0]);
                chatmessage.func_150256_b().func_150238_a(TextFormatting.RED);
                this.func_147359_a((IPacket<?>)new SChatPacket((ITextComponent)chatmessage));
            } else {
                this.chat(s2, true);
            }
            this.field_147374_l += 20;
            if (this.field_147374_l > 200 && !this.minecraftServer.func_184103_al().func_152596_g(this.field_147369_b.func_146103_bH())) {
                if (!isSync) {
                    class Disconnect2
                    extends Waitable {
                        Disconnect2() {
                        }

                        protected Object evaluate() {
                            ServerPlayNetHandlerMixin.this.func_194028_b((ITextComponent)new TranslationTextComponent("disconnect.spam", new Object[0]));
                            return null;
                        }
                    }
                    Disconnect2 waitable2 = new Disconnect2();
                    ((MinecraftServerBridge)this.minecraftServer).bridge$queuedProcess(waitable2);
                    try {
                        waitable2.get();
                        return;
                    }
                    catch (InterruptedException e4) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (ExecutionException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                this.func_194028_b((ITextComponent)new TranslationTextComponent("disconnect.spam", new Object[0]));
            }
        }
    }

    public void chat(String s2, boolean async) {
        if (s2.isEmpty() || this.field_147369_b.func_147096_v() == ChatVisibility.HIDDEN) {
            return;
        }
        final ServerPlayNetHandler handler = (ServerPlayNetHandler)this;
        if (!async && s2.startsWith("/")) {
            this.func_147361_d(s2);
        } else if (this.field_147369_b.func_147096_v() != ChatVisibility.SYSTEM) {
            CraftPlayer player = this.getPlayer();
            final AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, player, s2, new LazyPlayerSet(this.minecraftServer));
            this.server.getPluginManager().callEvent(event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent(player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                class SyncChat
                extends Waitable {
                    SyncChat() {
                    }

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent(queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        ITextComponent component = ForgeHooks.onServerChatEvent((ServerPlayNetHandler)handler, (String)queueEvent.getMessage(), (ITextComponent)ForgeHooks.newChatWithLinks((String)message));
                        if (component == null) {
                            return null;
                        }
                        Bukkit.getConsoleSender().sendMessage(CraftChatMessage.fromComponent(component));
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            for (ServerPlayerEntity player : ((ServerPlayNetHandlerMixin)ServerPlayNetHandlerMixin.this).minecraftServer.func_184103_al().field_72404_b) {
                                ((ServerPlayerEntityBridge)player).bridge$sendMessage(component);
                            }
                        } else {
                            for (Player player2 : queueEvent.getRecipients()) {
                                ((ServerPlayerEntityBridge)((CraftPlayer)player2).getHandle()).bridge$sendMessage(component);
                            }
                        }
                        return null;
                    }
                }
                SyncChat waitable = new SyncChat();
                if (async) {
                    ((MinecraftServerBridge)this.minecraftServer).bridge$queuedProcess(waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                    return;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Exception processing chat event", e.getCause());
                }
            }
            if (event.isCancelled()) {
                return;
            }
            s2 = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
            final ITextComponent chatWithLinks = ForgeHooks.newChatWithLinks((String)s2);
            class ForgeChat
            extends Waitable<Void> {
                ForgeChat() {
                }

                @Override
                protected Void evaluate() {
                    ITextComponent component = ForgeHooks.onServerChatEvent((ServerPlayNetHandler)handler, (String)event.getMessage(), (ITextComponent)chatWithLinks);
                    if (component == null) {
                        return null;
                    }
                    Bukkit.getConsoleSender().sendMessage(CraftChatMessage.fromComponent(component));
                    if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                        for (ServerPlayerEntity recipient : ((ServerPlayNetHandlerMixin)ServerPlayNetHandlerMixin.this).minecraftServer.func_184103_al().field_72404_b) {
                            ((ServerPlayerEntityBridge)recipient).bridge$sendMessage(component);
                        }
                    } else {
                        for (Player recipient2 : event.getRecipients()) {
                            ((ServerPlayerEntityBridge)((CraftPlayer)recipient2).getHandle()).bridge$sendMessage(component);
                        }
                    }
                    return null;
                }
            }
            ForgeChat waitable = new ForgeChat();
            if (async) {
                ((MinecraftServerBridge)this.minecraftServer).bridge$queuedProcess(waitable);
            } else {
                waitable.run();
            }
        }
    }

    @Overwrite
    private void func_147361_d(String s2) {
        if (SpigotConfig.logCommands) {
            field_147370_c.info(this.field_147369_b.func_195047_I_() + " issued server command: " + s2);
        }
        CraftPlayer player = this.getPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent(player, s2, new LazyPlayerSet(this.minecraftServer));
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        try {
            this.minecraftServer.func_195571_aL().func_197059_a(((CraftPlayer)event.getPlayer()).getHandle().func_195051_bN(), event.getMessage());
        }
        catch (CommandException ex) {
            player.sendMessage((Object)((Object)ChatColor.RED) + "An internal error occurred while attempting to perform this command");
            Logger.getLogger(ServerPlayNetHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Overwrite
    public void func_175087_a(CAnimateHandPacket packet) {
        PacketThreadUtil.func_218796_a((IPacket)packet, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            return;
        }
        this.field_147369_b.func_143004_u();
        float f1 = this.field_147369_b.field_70125_A;
        float f2 = this.field_147369_b.field_70177_z;
        double d0 = this.field_147369_b.field_70165_t;
        double d2 = this.field_147369_b.field_70163_u + (double)this.field_147369_b.func_70047_e();
        double d3 = this.field_147369_b.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d2, d3);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d4 = this.field_147369_b.field_71134_c.func_73081_b() == GameType.CREATIVE ? 5.0 : 4.5;
        Vec3d vec3d2 = vec3d.func_72441_c((double)f7 * d4, (double)f6 * d4, (double)f8 * d4);
        BlockRayTraceResult result = this.field_147369_b.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.field_147369_b));
        if (result == null || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_147369_b, Action.LEFT_CLICK_AIR, this.field_147369_b.field_71071_by.func_70448_g(), Hand.MAIN_HAND);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent(this.getPlayer());
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.field_147369_b.func_184609_a(packet.func_187018_a());
    }

    @Inject(method={"processEntityAction"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;markPlayerActive()V")})
    private void arclight$toggleAction(CEntityActionPacket packetIn, CallbackInfo ci) {
        if (this.field_147369_b.field_70128_L) {
            ci.cancel();
            return;
        }
        String name = packetIn.func_180764_b().name();
        if (sneakKeys.contains(name) || standKeys.contains(name)) {
            PlayerToggleSneakEvent event = new PlayerToggleSneakEvent(this.getPlayer(), sneakKeys.contains(name));
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        } else if (packetIn.func_180764_b() == CEntityActionPacket.Action.START_SPRINTING || packetIn.func_180764_b() == CEntityActionPacket.Action.STOP_SPRINTING) {
            PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent(this.getPlayer(), packetIn.func_180764_b() == CEntityActionPacket.Action.START_SPRINTING);
            this.server.getPluginManager().callEvent(e2);
            if (e2.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Overwrite
    public void func_147340_a(CUseEntityPacket packetIn) {
        PacketThreadUtil.func_218796_a((IPacket)packetIn, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            return;
        }
        ServerWorld world = this.minecraftServer.func_71218_a(this.field_147369_b.field_71093_bK);
        Entity entity = packetIn.func_149564_a((World)world);
        this.field_147369_b.func_143004_u();
        if (entity != null) {
            boolean flag = this.field_147369_b.func_70685_l(entity);
            double d0 = 36.0;
            if (!flag) {
                d0 = 9.0;
            }
            if (this.field_147369_b.func_70068_e(entity) < d0) {
                net.minecraft.item.ItemStack itemInHand = this.field_147369_b.func_184586_b(packetIn.func_186994_b() == null ? Hand.MAIN_HAND : packetIn.func_186994_b());
                if (packetIn.func_149565_c() == CUseEntityPacket.Action.INTERACT || packetIn.func_149565_c() == CUseEntityPacket.Action.INTERACT_AT) {
                    PlayerInteractEntityEvent event;
                    Item origItem;
                    boolean triggerLeashUpdate = itemInHand != null && itemInHand.func_77973_b() == Items.field_151058_ca && entity instanceof MobEntity;
                    Item item = origItem = this.field_147369_b.field_71071_by.func_70448_g() == null ? null : this.field_147369_b.field_71071_by.func_70448_g().func_77973_b();
                    if (packetIn.func_149565_c() == CUseEntityPacket.Action.INTERACT) {
                        event = new PlayerInteractEntityEvent(this.getPlayer(), ((EntityBridge)entity).bridge$getBukkitEntity(), packetIn.func_186994_b() == Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
                    } else {
                        Vec3d target = packetIn.func_179712_b();
                        event = new PlayerInteractAtEntityEvent(this.getPlayer(), ((EntityBridge)entity).bridge$getBukkitEntity(), new Vector(target.field_72450_a, target.field_72448_b, target.field_72449_c), packetIn.func_186994_b() == Hand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
                    }
                    this.server.getPluginManager().callEvent(event);
                    if (entity instanceof AbstractFishEntity && origItem != null && origItem.func_199767_j() == Items.field_151131_as && (event.isCancelled() || this.field_147369_b.field_71071_by.func_70448_g() == null || this.field_147369_b.field_71071_by.func_70448_g().func_77973_b() != origItem)) {
                        this.func_147359_a((IPacket<?>)new SSpawnMobPacket((LivingEntity)entity));
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                    if (triggerLeashUpdate && (event.isCancelled() || this.field_147369_b.field_71071_by.func_70448_g() == null || this.field_147369_b.field_71071_by.func_70448_g().func_77973_b() != origItem)) {
                        this.func_147359_a((IPacket<?>)new SMountEntityPacket(entity, ((MobEntity)entity).func_110166_bE()));
                    }
                    if (event.isCancelled() || this.field_147369_b.field_71071_by.func_70448_g() == null || this.field_147369_b.field_71071_by.func_70448_g().func_77973_b() != origItem) {
                        this.func_147359_a((IPacket<?>)new SEntityMetadataPacket(entity.func_145782_y(), entity.func_184212_Q(), true));
                    }
                    if (event.isCancelled()) {
                        return;
                    }
                }
                if (packetIn.func_149565_c() == CUseEntityPacket.Action.INTERACT) {
                    Hand hand = packetIn.func_186994_b();
                    this.field_147369_b.func_190775_a(entity, hand);
                    if (!itemInHand.func_190926_b() && itemInHand.func_190916_E() <= -1) {
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                } else if (packetIn.func_149565_c() == CUseEntityPacket.Action.INTERACT_AT) {
                    Hand hand = packetIn.func_186994_b();
                    if (ForgeHooks.onInteractEntityAt((PlayerEntity)this.field_147369_b, (Entity)entity, (Vec3d)packetIn.func_179712_b(), (Hand)hand) != null) {
                        return;
                    }
                    ActionResultType result = entity.func_184199_a((PlayerEntity)this.field_147369_b, packetIn.func_179712_b(), hand);
                    if (result == ActionResultType.SUCCESS) {
                        this.field_147369_b.func_184609_a(hand);
                    }
                    if (!itemInHand.func_190926_b() && itemInHand.func_190916_E() <= -1) {
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                } else if (packetIn.func_149565_c() == CUseEntityPacket.Action.ATTACK) {
                    if (entity instanceof ItemEntity || entity instanceof ExperienceOrbEntity || entity instanceof AbstractArrowEntity || entity == this.field_147369_b && !this.field_147369_b.func_175149_v()) {
                        this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_entity_attacked", new Object[0]));
                        this.minecraftServer.func_71236_h("Player " + this.field_147369_b.func_200200_C_().getString() + " tried to attack an invalid entity");
                        return;
                    }
                    this.field_147369_b.func_71059_n(entity);
                    if (!itemInHand.func_190926_b() && itemInHand.func_190916_E() <= -1) {
                        this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                    }
                }
            }
        }
    }

    @Inject(method={"processCloseWindow"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;closeContainer()V")})
    private void arclight$invClose(CCloseWindowPacket packetIn, CallbackInfo ci) {
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            ci.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Overwrite
    public void func_147351_a(CClickWindowPacket packet) {
        PacketThreadUtil.func_218796_a((IPacket)packet, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            return;
        }
        ArclightCaptures.captureContainerOwner((PlayerEntity)this.field_147369_b);
        try {
            this.field_147369_b.func_143004_u();
            if (this.field_147369_b.field_71070_bA.field_75152_c != packet.func_149548_c()) return;
            if (!this.field_147369_b.field_71070_bA.func_75129_b((PlayerEntity)this.field_147369_b)) return;
            if (!this.field_147369_b.field_71070_bA.func_75145_c((PlayerEntity)this.field_147369_b)) return;
            boolean cancelled = this.field_147369_b.func_175149_v();
            if (packet.func_149544_d() < -1 && packet.func_149544_d() != -999) {
                return;
            }
            ArclightCaptures.captureContainerOwner((PlayerEntity)this.field_147369_b);
            InventoryView inventory = ((ContainerBridge)this.field_147369_b.field_71070_bA).bridge$getBukkitView();
            ArclightCaptures.resetContainerOwner();
            InventoryType.SlotType type = inventory.getSlotType(packet.func_149544_d());
            org.bukkit.event.inventory.ClickType click = org.bukkit.event.inventory.ClickType.UNKNOWN;
            InventoryAction action = InventoryAction.UNKNOWN;
            net.minecraft.item.ItemStack itemstack = net.minecraft.item.ItemStack.field_190927_a;
            switch (packet.func_186993_f()) {
                case PICKUP: {
                    if (packet.func_149543_e() == 0) {
                        click = org.bukkit.event.inventory.ClickType.LEFT;
                    } else if (packet.func_149543_e() == 1) {
                        click = org.bukkit.event.inventory.ClickType.RIGHT;
                    }
                    if (packet.func_149543_e() != 0 && packet.func_149543_e() != 1) break;
                    action = InventoryAction.NOTHING;
                    if (packet.func_149544_d() == -999) {
                        if (this.field_147369_b.field_71071_by.func_70445_o().func_190926_b()) break;
                        action = packet.func_149543_e() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                        break;
                    }
                    if (packet.func_149544_d() < 0) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    Slot slot = this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d());
                    if (slot == null) break;
                    net.minecraft.item.ItemStack clickedItem = slot.func_75211_c();
                    net.minecraft.item.ItemStack cursor = this.field_147369_b.field_71071_by.func_70445_o();
                    if (clickedItem.func_190926_b()) {
                        if (cursor.func_190926_b()) break;
                        action = packet.func_149543_e() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                        break;
                    }
                    if (!slot.func_82869_a((PlayerEntity)this.field_147369_b)) break;
                    if (cursor.func_190926_b()) {
                        action = packet.func_149543_e() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                        break;
                    }
                    if (slot.func_75214_a(cursor)) {
                        if (clickedItem.func_77969_a(cursor) && net.minecraft.item.ItemStack.func_77970_a((net.minecraft.item.ItemStack)clickedItem, (net.minecraft.item.ItemStack)cursor)) {
                            int toPlace = packet.func_149543_e() == 0 ? cursor.func_190916_E() : 1;
                            toPlace = Math.min(toPlace, clickedItem.func_77976_d() - clickedItem.func_190916_E());
                            if ((toPlace = Math.min(toPlace, slot.field_75224_c.func_70297_j_() - clickedItem.func_190916_E())) == 1) {
                                action = InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (toPlace == cursor.func_190916_E()) {
                                action = InventoryAction.PLACE_ALL;
                                break;
                            }
                            if (toPlace < 0) {
                                action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                break;
                            }
                            if (toPlace == 0) break;
                            action = InventoryAction.PLACE_SOME;
                            break;
                        }
                        if (cursor.func_190916_E() > slot.func_75219_a()) break;
                        action = InventoryAction.SWAP_WITH_CURSOR;
                        break;
                    }
                    if (cursor.func_77973_b() != clickedItem.func_77973_b() || !net.minecraft.item.ItemStack.func_77970_a((net.minecraft.item.ItemStack)cursor, (net.minecraft.item.ItemStack)clickedItem) || clickedItem.func_190916_E() < 0 || clickedItem.func_190916_E() + cursor.func_190916_E() > cursor.func_77976_d()) break;
                    action = InventoryAction.PICKUP_ALL;
                    break;
                }
                case QUICK_MOVE: {
                    if (packet.func_149543_e() == 0) {
                        click = org.bukkit.event.inventory.ClickType.SHIFT_LEFT;
                    } else if (packet.func_149543_e() == 1) {
                        click = org.bukkit.event.inventory.ClickType.SHIFT_RIGHT;
                    }
                    if (packet.func_149543_e() != 0 && packet.func_149543_e() != 1) break;
                    if (packet.func_149544_d() < 0) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    Slot slot = this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d());
                    if (slot != null && slot.func_82869_a((PlayerEntity)this.field_147369_b) && slot.func_75216_d()) {
                        action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case SWAP: {
                    boolean canCleanSwap;
                    if (packet.func_149543_e() < 0 || packet.func_149543_e() >= 9) break;
                    click = org.bukkit.event.inventory.ClickType.NUMBER_KEY;
                    Slot clickedSlot = this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d());
                    if (!clickedSlot.func_82869_a((PlayerEntity)this.field_147369_b)) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    net.minecraft.item.ItemStack hotbar = this.field_147369_b.field_71071_by.func_70301_a(packet.func_149543_e());
                    boolean bl = canCleanSwap = hotbar.func_190926_b() || clickedSlot.field_75224_c == this.field_147369_b.field_71071_by && clickedSlot.func_75214_a(hotbar);
                    if (clickedSlot.func_75216_d()) {
                        if (canCleanSwap) {
                            action = InventoryAction.HOTBAR_SWAP;
                            break;
                        }
                        action = InventoryAction.HOTBAR_MOVE_AND_READD;
                        break;
                    }
                    if (!clickedSlot.func_75216_d() && !hotbar.func_190926_b() && clickedSlot.func_75214_a(hotbar)) {
                        action = InventoryAction.HOTBAR_SWAP;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case CLONE: {
                    if (packet.func_149543_e() != 2) {
                        click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                        action = InventoryAction.UNKNOWN;
                        break;
                    }
                    click = org.bukkit.event.inventory.ClickType.MIDDLE;
                    if (packet.func_149544_d() < 0) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    Slot slot = this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d());
                    if (slot != null && slot.func_75216_d() && this.field_147369_b.field_71075_bZ.field_75098_d && this.field_147369_b.field_71071_by.func_70445_o().func_190926_b()) {
                        action = InventoryAction.CLONE_STACK;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case THROW: {
                    Slot slot;
                    if (packet.func_149544_d() < 0) {
                        click = org.bukkit.event.inventory.ClickType.LEFT;
                        if (packet.func_149543_e() == 1) {
                            click = org.bukkit.event.inventory.ClickType.RIGHT;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    if (packet.func_149543_e() == 0) {
                        click = org.bukkit.event.inventory.ClickType.DROP;
                        slot = this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d());
                        if (slot != null && slot.func_75216_d() && slot.func_82869_a((PlayerEntity)this.field_147369_b) && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a)) {
                            action = InventoryAction.DROP_ONE_SLOT;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    if (packet.func_149543_e() != 1) break;
                    click = org.bukkit.event.inventory.ClickType.CONTROL_DROP;
                    slot = this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d());
                    if (slot != null && slot.func_75216_d() && slot.func_82869_a((PlayerEntity)this.field_147369_b) && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a)) {
                        action = InventoryAction.DROP_ALL_SLOT;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case QUICK_CRAFT: {
                    itemstack = this.field_147369_b.field_71070_bA.func_184996_a(packet.func_149544_d(), packet.func_149543_e(), packet.func_186993_f(), (PlayerEntity)this.field_147369_b);
                    break;
                }
                case PICKUP_ALL: {
                    click = org.bukkit.event.inventory.ClickType.DOUBLE_CLICK;
                    action = InventoryAction.NOTHING;
                    if (packet.func_149544_d() < 0 || this.field_147369_b.field_71071_by.func_70445_o().func_190926_b()) break;
                    net.minecraft.item.ItemStack cursor2 = this.field_147369_b.field_71071_by.func_70445_o();
                    action = InventoryAction.NOTHING;
                    if (!inventory.getTopInventory().contains(CraftMagicNumbers.getMaterial(cursor2.func_77973_b())) && !inventory.getBottomInventory().contains(CraftMagicNumbers.getMaterial(cursor2.func_77973_b()))) break;
                    action = InventoryAction.COLLECT_TO_CURSOR;
                    break;
                }
            }
            if (packet.func_186993_f() != ClickType.QUICK_CRAFT) {
                Recipe recipe;
                InventoryClickEvent event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packet.func_149544_d(), click, action, packet.func_149543_e()) : new InventoryClickEvent(inventory, type, packet.func_149544_d(), click, action);
                Inventory top = inventory.getTopInventory();
                if (packet.func_149544_d() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                    event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packet.func_149544_d(), click, action, packet.func_149543_e()) : new CraftItemEvent(recipe, inventory, type, packet.func_149544_d(), click, action);
                }
                event.setCancelled(cancelled);
                Container oldContainer = this.field_147369_b.field_71070_bA;
                this.server.getPluginManager().callEvent(event);
                if (this.field_147369_b.field_71070_bA != oldContainer) {
                    return;
                }
                switch (event.getResult()) {
                    case DEFAULT: 
                    case ALLOW: {
                        itemstack = this.field_147369_b.field_71070_bA.func_184996_a(packet.func_149544_d(), packet.func_149543_e(), packet.func_186993_f(), (PlayerEntity)this.field_147369_b);
                        break;
                    }
                    case DENY: {
                        switch (action) {
                            case PICKUP_ALL: 
                            case MOVE_TO_OTHER_INVENTORY: 
                            case HOTBAR_MOVE_AND_READD: 
                            case HOTBAR_SWAP: 
                            case COLLECT_TO_CURSOR: 
                            case UNKNOWN: {
                                this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                                return;
                            }
                            case PICKUP_SOME: 
                            case PICKUP_HALF: 
                            case PICKUP_ONE: 
                            case PLACE_ALL: 
                            case PLACE_SOME: 
                            case PLACE_ONE: 
                            case SWAP_WITH_CURSOR: {
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, this.field_147369_b.field_71071_by.func_70445_o()));
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_147369_b.field_71070_bA.field_75152_c, packet.func_149544_d(), this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d()).func_75211_c()));
                                return;
                            }
                            case DROP_ALL_SLOT: 
                            case DROP_ONE_SLOT: {
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_147369_b.field_71070_bA.field_75152_c, packet.func_149544_d(), this.field_147369_b.field_71070_bA.func_75139_a(packet.func_149544_d()).func_75211_c()));
                                return;
                            }
                            case DROP_ALL_CURSOR: 
                            case DROP_ONE_CURSOR: 
                            case CLONE_STACK: {
                                this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, this.field_147369_b.field_71071_by.func_70445_o()));
                                return;
                            }
                        }
                        return;
                    }
                }
                if (event instanceof CraftItemEvent) {
                    this.field_147369_b.func_71120_a(this.field_147369_b.field_71070_bA);
                }
            }
            if (net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)packet.func_149546_g(), (net.minecraft.item.ItemStack)itemstack)) {
                this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SConfirmTransactionPacket(packet.func_149548_c(), packet.func_149547_f(), true));
                this.field_147369_b.field_71137_h = true;
                this.field_147369_b.field_71070_bA.func_75142_b();
                this.field_147369_b.func_71113_k();
                this.field_147369_b.field_71137_h = false;
                return;
            }
            this.field_147372_n.put(this.field_147369_b.field_71070_bA.field_75152_c, packet.func_149547_f());
            this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SConfirmTransactionPacket(packet.func_149548_c(), packet.func_149547_f(), false));
            this.field_147369_b.field_71070_bA.func_75128_a((PlayerEntity)this.field_147369_b, false);
            NonNullList nonnulllist1 = NonNullList.func_191196_a();
            for (int j = 0; j < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++j) {
                net.minecraft.item.ItemStack itemstack2 = ((Slot)this.field_147369_b.field_71070_bA.field_75151_b.get(j)).func_75211_c();
                nonnulllist1.add((Object)(itemstack2.func_190926_b() ? net.minecraft.item.ItemStack.field_190927_a : itemstack2));
            }
            this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, nonnulllist1);
            return;
        }
        finally {
            ArclightCaptures.resetContainerOwner();
        }
    }

    @Inject(method={"processEnchantItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;markPlayerActive()V")})
    private void arclight$noEnchant(CEnchantItemPacket packetIn, CallbackInfo ci) {
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            ci.cancel();
        }
    }

    @Overwrite
    public void func_147344_a(CCreativeInventoryActionPacket packetplayinsetcreativeslot) {
        PacketThreadUtil.func_218796_a((IPacket)packetplayinsetcreativeslot, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71134_c.func_73083_d()) {
            boolean flag3;
            BlockPos blockposition;
            TileEntity tileentity;
            boolean flag = packetplayinsetcreativeslot.func_149627_c() < 0;
            net.minecraft.item.ItemStack itemstack = packetplayinsetcreativeslot.func_149625_d();
            CompoundNBT nbttagcompound = itemstack.func_179543_a("BlockEntityTag");
            if (!itemstack.func_190926_b() && nbttagcompound != null && nbttagcompound.func_74764_b("x") && nbttagcompound.func_74764_b("y") && nbttagcompound.func_74764_b("z") && (tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockposition = new BlockPos(nbttagcompound.func_74762_e("x"), nbttagcompound.func_74762_e("y"), nbttagcompound.func_74762_e("z")))) != null) {
                CompoundNBT nbttagcompound2 = tileentity.func_189515_b(new CompoundNBT());
                nbttagcompound2.func_82580_o("x");
                nbttagcompound2.func_82580_o("y");
                nbttagcompound2.func_82580_o("z");
                itemstack.func_77983_a("BlockEntityTag", (INBT)nbttagcompound2);
            }
            boolean flag2 = packetplayinsetcreativeslot.func_149627_c() >= 1 && packetplayinsetcreativeslot.func_149627_c() <= 45;
            boolean bl = flag3 = itemstack.func_190926_b() || itemstack.func_77952_i() >= 0 && itemstack.func_190916_E() <= 64 && !itemstack.func_190926_b();
            if (flag || flag2 && !net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)this.field_147369_b.field_71069_bz.func_75139_a(packetplayinsetcreativeslot.func_149627_c()).func_75211_c(), (net.minecraft.item.ItemStack)packetplayinsetcreativeslot.func_149625_d())) {
                InventoryView inventory = ((ContainerBridge)this.field_147369_b.field_71069_bz).bridge$getBukkitView();
                ItemStack item = CraftItemStack.asBukkitCopy(packetplayinsetcreativeslot.func_149625_d());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packetplayinsetcreativeslot.func_149627_c() < 36) {
                    type = packetplayinsetcreativeslot.func_149627_c() >= 5 && packetplayinsetcreativeslot.func_149627_c() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent(inventory, type, flag ? -999 : packetplayinsetcreativeslot.func_149627_c(), item);
                this.server.getPluginManager().callEvent(event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag3 = true;
                    }
                    case DENY: {
                        if (packetplayinsetcreativeslot.func_149627_c() >= 0) {
                            this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_147369_b.field_71069_bz.field_75152_c, packetplayinsetcreativeslot.func_149627_c(), this.field_147369_b.field_71069_bz.func_75139_a(packetplayinsetcreativeslot.func_149627_c()).func_75211_c()));
                            this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, net.minecraft.item.ItemStack.field_190927_a));
                        }
                        return;
                    }
                }
            }
            if (flag2 && flag3) {
                if (itemstack.func_190926_b()) {
                    this.field_147369_b.field_71069_bz.func_75141_a(packetplayinsetcreativeslot.func_149627_c(), net.minecraft.item.ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.field_71069_bz.func_75141_a(packetplayinsetcreativeslot.func_149627_c(), itemstack);
                }
                this.field_147369_b.field_71069_bz.func_75128_a((PlayerEntity)this.field_147369_b, true);
                this.field_147369_b.field_71069_bz.func_75142_b();
            } else if (flag && flag3 && this.field_147375_m < 200) {
                this.field_147375_m += 20;
                this.field_147369_b.func_71019_a(itemstack, true);
            }
        }
    }

    @Inject(method={"processConfirmTransaction"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/PacketThreadUtil;checkThreadAndEnqueue(Lnet/minecraft/network/IPacket;Lnet/minecraft/network/INetHandler;Lnet/minecraft/world/server/ServerWorld;)V")})
    private void arclight$noTransaction(CConfirmTransactionPacket packetIn, CallbackInfo ci) {
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            ci.cancel();
        }
    }

    @Inject(method={"processUpdateSign"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;markPlayerActive()V")})
    private void arclight$noSignEdit(CUpdateSignPacket packetIn, CallbackInfo ci) {
        if (((ServerPlayerEntityBridge)this.field_147369_b).bridge$isMovementBlocked()) {
            ci.cancel();
        }
    }

    @Inject(method={"processUpdateSign"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/play/client/CUpdateSignPacket;getLines()[Ljava/lang/String;")})
    public void arclight$onSignChangePre(CUpdateSignPacket packetIn, CallbackInfo ci) {
        String[] lines = packetIn.func_187017_b();
        Player player = ((CraftServer)Bukkit.getServer()).getPlayer(this.field_147369_b);
        CraftBlock block = CraftBlock.at((IWorld)this.field_147369_b.field_70170_p, packetIn.func_179722_a());
        String[] bukkitLines = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            bukkitLines[i] = TextFormatting.func_110646_a((String)new StringTextComponent(Objects.requireNonNull(TextFormatting.func_110646_a((String)lines[i]))).getString());
        }
        SignChangeEvent event = new SignChangeEvent(block, player, bukkitLines);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            for (int i = 0; i < lines.length; ++i) {
                this.arclight$lines = CraftSign.sanitizeLines(event.getLines());
            }
        }
    }

    @Redirect(method={"processUpdateSign"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/SignTileEntity;setText(ILnet/minecraft/util/text/ITextComponent;)V"))
    public void arclight$onSignChangePost(SignTileEntity signTileEntity, int line, ITextComponent p_212365_2_) {
        if (this.arclight$lines != null) {
            signTileEntity.func_212365_a(line, this.arclight$lines[line]);
            if (line == this.arclight$lines.length - 1) {
                this.arclight$lines = null;
                ((SignTileEntityBridge)signTileEntity).bridge$setEditable(false);
            }
        }
    }

    @Inject(method={"processKeepAlive"}, at={@At(value="HEAD")})
    private void arclight$syncKeepAlive(CKeepAlivePacket packetIn, CallbackInfo ci) {
        PacketThreadUtil.func_218796_a((IPacket)packetIn, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
    }

    @Overwrite
    public void func_147348_a(CPlayerAbilitiesPacket packet) {
        PacketThreadUtil.func_218796_a((IPacket)packet, (INetHandler)((ServerPlayNetHandler)this), (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71075_bZ.field_75101_c && this.field_147369_b.field_71075_bZ.field_75100_b != packet.func_149488_d()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent(this.server.getPlayer(this.field_147369_b), packet.func_149488_d());
            this.server.getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.field_147369_b.field_71075_bZ.field_75100_b = packet.func_149488_d();
            } else {
                this.field_147369_b.func_71016_p();
            }
        }
    }

    @Inject(method={"processCustomPayload"}, cancellable=true, at={@At(value="INVOKE", remap=false, target="Lnet/minecraftforge/fml/network/NetworkHooks;onCustomPayload(Lnet/minecraftforge/fml/network/ICustomPacket;Lnet/minecraft/network/NetworkManager;)Z")})
    private void arclight$customPayload(CCustomPayloadPacket packet, CallbackInfo ci) {
        if (packet.field_149562_a.equals((Object)CUSTOM_REGISTER)) {
            try {
                String channels = packet.field_149561_c.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    if (net.minecraft.util.StringUtils.func_151246_b((String)channel)) continue;
                    this.getPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                field_147370_c.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect("Invalid payload REGISTER!");
                ci.cancel();
            }
        } else if (packet.field_149562_a.equals((Object)CUSTOM_UNREGISTER)) {
            try {
                String channels = packet.field_149561_c.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    if (net.minecraft.util.StringUtils.func_151246_b((String)channel)) continue;
                    this.getPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                field_147370_c.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect("Invalid payload UNREGISTER!");
                ci.cancel();
            }
        } else {
            try {
                int readerIndex = packet.field_149561_c.readerIndex();
                byte[] data = new byte[packet.field_149561_c.readableBytes()];
                packet.field_149561_c.readBytes(data);
                this.server.getMessenger().dispatchIncomingMessage(((ServerPlayerEntityBridge)this.field_147369_b).bridge$getBukkitEntity(), packet.field_149562_a.toString(), data);
                packet.field_149561_c.readerIndex(readerIndex);
            }
            catch (Exception ex) {
                field_147370_c.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect("Invalid custom payload!");
                ci.cancel();
            }
        }
    }

    public final boolean isDisconnected() {
        return !((ServerPlayerEntityBridge)this.field_147369_b).bridge$isJoining() && !this.field_147371_a.func_150724_d();
    }

    @Override
    public boolean bridge$isDisconnected() {
        return this.isDisconnected();
    }

    @Overwrite
    public void func_175089_a(double x, double y, double z, float yaw, float pitch, Set<SPlayerPositionLookPacket.Flags> relativeSet) {
        Location to;
        PlayerTeleportEvent.TeleportCause cause = this.arclight$cause == null ? PlayerTeleportEvent.TeleportCause.UNKNOWN : this.arclight$cause;
        this.arclight$cause = null;
        CraftPlayer player = this.getPlayer();
        Location from = player.getLocation();
        if (!from.equals(to = new Location(this.getPlayer().getWorld(), x, y, z, yaw, pitch))) {
            PlayerTeleportEvent event = new PlayerTeleportEvent(player, from.clone(), to.clone(), cause);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled() || !to.equals(event.getTo())) {
                relativeSet.clear();
                to = event.isCancelled() ? event.getFrom() : event.getTo();
                x = to.getX();
                y = to.getY();
                z = to.getZ();
                yaw = to.getYaw();
                pitch = to.getPitch();
            }
        }
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        this.justTeleported = true;
        double d0 = relativeSet.contains(SPlayerPositionLookPacket.Flags.X) ? this.field_147369_b.field_70165_t : 0.0;
        double d1 = relativeSet.contains(SPlayerPositionLookPacket.Flags.Y) ? this.field_147369_b.field_70163_u : 0.0;
        double d2 = relativeSet.contains(SPlayerPositionLookPacket.Flags.Z) ? this.field_147369_b.field_70161_v : 0.0;
        float f = relativeSet.contains(SPlayerPositionLookPacket.Flags.Y_ROT) ? this.field_147369_b.field_70177_z : 0.0f;
        float f1 = relativeSet.contains(SPlayerPositionLookPacket.Flags.X_ROT) ? this.field_147369_b.field_70125_A : 0.0f;
        this.field_184362_y = new Vec3d(x, y, z);
        if (++this.field_184363_z == Integer.MAX_VALUE) {
            this.field_184363_z = 0;
        }
        this.lastPosX = this.field_184362_y.field_72450_a;
        this.lastPosY = this.field_184362_y.field_72448_b;
        this.lastPosZ = this.field_184362_y.field_72449_c;
        this.lastYaw = yaw;
        this.lastPitch = pitch;
        this.field_184343_A = this.field_147368_e;
        this.field_147369_b.func_70080_a(x, y, z, yaw, pitch);
        this.field_147369_b.field_71135_a.func_147359_a((IPacket)new SPlayerPositionLookPacket(x - d0, y - d1, z - d2, yaw - f, pitch - f1, relativeSet, this.field_184363_z));
    }

    public void a(double d0, double d1, double d2, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.a(d0, d1, d2, f, f1, Collections.emptySet(), cause);
    }

    public void a(double d0, double d1, double d2, float f, float f1, Set<SPlayerPositionLookPacket.Flags> set, PlayerTeleportEvent.TeleportCause cause) {
        this.bridge$pushTeleportCause(cause);
        this.func_175089_a(d0, d1, d2, f, f1, set);
    }

    private void internalTeleport(double d0, double d1, double d2, float f, float f1, Set<SPlayerPositionLookPacket.Flags> set) {
        this.func_175089_a(d0, d1, d2, f, f1, set);
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    @Override
    public void bridge$pushTeleportCause(PlayerTeleportEvent.TeleportCause cause) {
        this.arclight$cause = cause;
    }

    @Override
    public void bridge$teleport(Location dest) {
        this.teleport(dest);
    }

    static {
        sneakKeys = ImmutableSet.of("START_SNEAKING", "PRESS_SHIFT_KEY");
        standKeys = ImmutableSet.of("STOP_SNEAKING", "RELEASE_SHIFT_KEY");
        CUSTOM_REGISTER = new ResourceLocation("register");
        CUSTOM_UNREGISTER = new ResourceLocation("unregister");
    }
}

