/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server;

import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.izzel.arclight.common.bridge.command.ICommandSourceBridge;
import io.izzel.arclight.common.bridge.server.MinecraftServerBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.dimension.DimensionTypeBridge;
import io.izzel.arclight.common.mod.ArclightConstants;
import io.izzel.arclight.common.mod.server.BukkitRegistry;
import io.izzel.arclight.common.mod.util.BukkitOptionParser;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.PluginLoadOrder;
import org.spigotmc.WatchdogThread;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
extends RecursiveEventLoop<TickDelayedTask>
implements MinecraftServerBridge,
ICommandSourceBridge {
    @Shadow
    private int field_71315_w;
    @Shadow
    protected long field_211151_aa;
    @Shadow
    @Final
    private ServerStatusResponse field_147147_p;
    @Shadow
    @Nullable
    private String field_71286_C;
    @Shadow
    private volatile boolean field_71317_u;
    @Shadow
    private long field_71299_R;
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    private boolean field_71295_T;
    @Shadow
    @Final
    private DebugProfiler field_71304_b;
    @Shadow
    private boolean field_213214_ac;
    @Shadow
    private long field_213213_ab;
    @Shadow
    private volatile boolean field_71296_Q;
    @Shadow
    private boolean field_71316_v;
    private boolean forceTicks;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public RemoteConsoleCommandSender remoteConsole;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public File bukkitDataPackFolder;
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    private static final int TPS = 20;
    private static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 100;
    private static int currentTick;
    public final double[] recentTps = new double[3];

    @Shadow
    protected abstract boolean func_71197_b() throws IOException;

    @Shadow
    public abstract void func_184107_a(ServerStatusResponse var1);

    @Shadow
    protected abstract void func_71217_p(BooleanSupplier var1);

    @Shadow
    protected abstract boolean func_212379_aT();

    @Shadow
    protected abstract void func_213202_o();

    @Shadow
    protected abstract void func_71228_a(CrashReport var1);

    @Shadow
    public abstract CrashReport func_71230_b(CrashReport var1);

    @Shadow
    public abstract File func_71238_n();

    @Shadow
    protected abstract void func_71260_j();

    @Shadow
    protected abstract void func_71240_o();

    @Shadow
    public abstract Commands func_195571_aL();

    @Shadow
    protected abstract void func_213188_a(WorldInfo var1);

    @Shadow
    protected abstract void func_200245_b(ITextComponent var1);

    @Shadow
    public abstract ServerWorld func_71218_a(DimensionType var1);

    @Shadow
    @Deprecated
    public abstract void markWorldsDirty();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    @Override
    public boolean bridge$hasStopped() {
        return this.hasStopped();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$loadOptions(File file, Proxy proxy, DataFixer dataFixerIn, Commands commands, YggdrasilAuthenticationService authenticationService, MinecraftSessionService sessionService, GameProfileRepository profileRepository, PlayerProfileCache playerProfileCache, IChunkStatusListenerFactory listenerFactory, String string, CallbackInfo ci) {
        String[] arguments = ManagementFactory.getRuntimeMXBean().getInputArguments().toArray(new String[0]);
        BukkitOptionParser parser = new BukkitOptionParser();
        try {
            this.options = parser.parse(arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Overwrite
    public void run() {
        try {
            if (this.func_71197_b()) {
                ServerLifecycleHooks.handleServerStarted((MinecraftServer)((MinecraftServer)this));
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a((ITextComponent)new StringTextComponent(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version(SharedConstants.func_215069_a().getName(), SharedConstants.func_215069_a().getProtocolVersion()));
                this.func_184107_a(this.field_147147_p);
                Arrays.fill(this.recentTps, 20.0);
                long tickSection = Util.func_211177_b();
                long tickCount = 1L;
                while (true) {
                    if (!this.field_71317_u) {
                        ServerLifecycleHooks.handleServerStopping((MinecraftServer)((MinecraftServer)this));
                        ServerLifecycleHooks.expectServerStopped();
                        return;
                    }
                    long curTime = Util.func_211177_b();
                    long i = curTime - this.field_211151_aa;
                    if (i > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        long j = i / 50L;
                        if (this.server.getWarnOnOverload()) {
                            field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i, (Object)j);
                        }
                        this.field_211151_aa += j * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    if (tickCount++ % 100L == 0L) {
                        double currentTps = 1000.0 / (double)(curTime - tickSection) * 100.0;
                        this.recentTps[0] = MinecraftServerMixin.calcTps(this.recentTps[0], 0.92, currentTps);
                        this.recentTps[1] = MinecraftServerMixin.calcTps(this.recentTps[1], 0.9835, currentTps);
                        this.recentTps[2] = MinecraftServerMixin.calcTps(this.recentTps[2], 0.9945, currentTps);
                        tickSection = curTime;
                    }
                    currentTick = (int)(System.currentTimeMillis() / 50L);
                    this.field_211151_aa += 50L;
                    if (this.field_71295_T) {
                        this.field_71295_T = false;
                        this.field_71304_b.func_219899_d().func_219939_d();
                    }
                    this.field_71304_b.func_219894_a();
                    this.field_71304_b.func_76320_a("tick");
                    this.func_71217_p(this::func_212379_aT);
                    this.field_71304_b.func_219895_b("nextTickWait");
                    this.field_213214_ac = true;
                    this.field_213213_ab = Math.max(Util.func_211177_b() + 50L, this.field_211151_aa);
                    this.func_213202_o();
                    this.field_71304_b.func_76319_b();
                    this.field_71304_b.func_219897_b();
                    this.field_71296_Q = true;
                }
            }
            ServerLifecycleHooks.expectServerStopped();
            this.func_71228_a(null);
            return;
        }
        catch (StartupQuery.AbortedException e) {
            ServerLifecycleHooks.expectServerStopped();
            return;
        }
        catch (Throwable throwable1) {
            field_147145_h.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = throwable1 instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable1).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_147149_a(file1)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            ServerLifecycleHooks.expectServerStopped();
            this.func_71228_a(crashreport);
            return;
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable throwable) {
                field_147145_h.error("Exception stopping the server", throwable);
            }
            finally {
                WatchdogThread.doStop();
                ServerLifecycleHooks.handleServerStopped((MinecraftServer)((MinecraftServer)this));
                this.func_71240_o();
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"stopServer"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$setStopped(CallbackInfo ci) {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                ci.cancel();
                return;
            }
            this.hasStopped = true;
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="INVOKE", remap=false, ordinal=0, shift=At.Shift.AFTER, target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;)V")})
    public void arclight$unloadPlugins(CallbackInfo ci) {
        if (this.server != null) {
            this.server.disablePlugins();
        }
    }

    @Inject(method={"loadAllWorlds"}, at={@At(value="RETURN")})
    public void arclight$enablePlugins(String saveName, String worldNameIn, long seed, WorldType type, JsonElement generatorOptions, CallbackInfo ci) {
        BukkitRegistry.unlockRegistries();
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        BukkitRegistry.lockRegistries();
        this.server.getPluginManager().callEvent(new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
    }

    public void initWorld(ServerWorld serverWorld, WorldInfo worldInfo, WorldSettings worldSettings) {
        serverWorld.func_175723_af().func_222519_b(worldInfo);
        if (((WorldBridge)serverWorld).bridge$getGenerator() != null) {
            ((WorldBridge)serverWorld).bridge$getWorld().getPopulators().addAll(((WorldBridge)serverWorld).bridge$getGenerator().getDefaultPopulators(((WorldBridge)serverWorld).bridge$getWorld()));
        }
        if (!worldInfo.func_76070_v()) {
            try {
                serverWorld.func_73052_b(worldSettings);
                if (worldInfo.func_76067_t() == WorldType.field_180272_g) {
                    this.func_213188_a(worldInfo);
                }
                worldInfo.func_76091_d(true);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception initializing level");
                try {
                    serverWorld.func_72914_a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            worldInfo.func_76091_d(true);
        }
    }

    public void loadSpawn(IChunkStatusListener listener, ServerWorld serverWorld) {
        this.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)serverWorld));
        if (!((WorldBridge)serverWorld).bridge$getWorld().getKeepSpawnInMemory()) {
            return;
        }
        this.func_200245_b((ITextComponent)new TranslationTextComponent("menu.generatingTerrain", new Object[0]));
        this.forceTicks = true;
        field_147145_h.info("Preparing start region for dimension '{}'/{}", (Object)serverWorld.func_72912_H().func_76065_j(), (Object)DimensionType.func_212678_a((DimensionType)((DimensionTypeBridge)serverWorld.field_73011_w.func_186058_p()).bridge$getType()));
        BlockPos pos = serverWorld.func_175694_M();
        listener.func_219509_a(new ChunkPos(pos));
        ServerChunkProvider chunkProvider = serverWorld.func_72863_F();
        chunkProvider.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        chunkProvider.func_217228_a(TicketType.field_219488_a, new ChunkPos(pos), 11, (Object)Unit.INSTANCE);
        while (chunkProvider.func_217229_b() < 441) {
            this.executeModerately();
        }
        this.executeModerately();
        DimensionType type = serverWorld.field_73011_w.func_186058_p();
        ForcedChunksSaveData chunks = (ForcedChunksSaveData)serverWorld.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        if (chunks != null) {
            ServerWorld world = this.func_71218_a(type);
            LongIterator iterator = chunks.func_212438_a().iterator();
            while (iterator.hasNext()) {
                long i = iterator.nextLong();
                ChunkPos chunkPos = new ChunkPos(i);
                world.func_72863_F().func_217206_a(chunkPos, true);
            }
        }
        this.executeModerately();
        listener.func_219510_b();
        chunkProvider.func_212863_j_().func_215598_a(5);
        this.forceTicks = false;
    }

    private void executeModerately() {
        this.func_213160_bf();
        this.bridge$drainQueuedTasks();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    @Override
    public void bridge$drainQueuedTasks() {
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
    }

    @Inject(method={"isAheadOfTime"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$forceAheadOfTime(CallbackInfoReturnable<Boolean> cir) {
        if (this.forceTicks) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"loadWorlds"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraftforge/common/DimensionManager;fireRegister()V", remap=false)})
    private void arclight$registerEnv(SaveHandler saveHandlerIn, WorldInfo info, WorldSettings worldSettingsIn, IChunkStatusListener chunkStatusListenerIn, CallbackInfo ci) {
        BukkitRegistry.registerEnvironments();
    }

    @Inject(method={"loadWorlds"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/MinecraftServer;func_213204_a(Lnet/minecraft/world/storage/DimensionSavedDataManager;)V")})
    private void arclight$worldInit(SaveHandler p_213194_1_, WorldInfo info, WorldSettings p_213194_3_, IChunkStatusListener p_213194_4_, CallbackInfo ci, ServerWorld serverWorld) {
        if (((CraftServer)Bukkit.getServer()).scoreboardManager == null) {
            ((CraftServer)Bukkit.getServer()).scoreboardManager = new CraftScoreboardManager((MinecraftServer)this, (Scoreboard)serverWorld.func_96441_U());
        }
    }

    @Redirect(method={"loadWorlds"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object arclight$worldInit(Map<Object, Object> map, Object key, Object value) {
        Object ret = map.put(key, value);
        ServerWorld serverWorld = (ServerWorld)value;
        if (((WorldBridge)serverWorld).bridge$getGenerator() != null) {
            ((WorldBridge)serverWorld).bridge$getWorld().getPopulators().addAll(((WorldBridge)serverWorld).bridge$getGenerator().getDefaultPopulators(((WorldBridge)serverWorld).bridge$getWorld()));
        }
        Bukkit.getPluginManager().callEvent(new WorldInitEvent(((WorldBridge)serverWorld).bridge$getWorld()));
        return ret;
    }

    @Overwrite
    public void func_213186_a(IChunkStatusListener listener) {
        this.func_200245_b((ITextComponent)new TranslationTextComponent("menu.generatingTerrain", new Object[0]));
        ServerWorld serverworld = this.func_71218_a(DimensionType.field_223227_a_);
        this.forceTicks = true;
        field_147145_h.info("Preparing start region for dimension " + DimensionType.func_212678_a((DimensionType)serverworld.field_73011_w.func_186058_p()));
        BlockPos blockpos = serverworld.func_175694_M();
        listener.func_219509_a(new ChunkPos(blockpos));
        ServerChunkProvider serverchunkprovider = serverworld.func_72863_F();
        serverchunkprovider.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        serverchunkprovider.func_217228_a(TicketType.field_219488_a, new ChunkPos(blockpos), 11, (Object)Unit.INSTANCE);
        while (serverchunkprovider.func_217229_b() < 441) {
            this.executeModerately();
        }
        this.executeModerately();
        for (DimensionType dimensiontype : DimensionType.func_212681_b()) {
            ForcedChunksSaveData forcedchunkssavedata;
            ServerWorld serverWorld = this.func_71218_a(dimensiontype);
            if (((WorldBridge)serverWorld).bridge$getWorld().getKeepSpawnInMemory() && (forcedchunkssavedata = (ForcedChunksSaveData)serverWorld.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks")) != null) {
                LongIterator longiterator = forcedchunkssavedata.func_212438_a().iterator();
                while (longiterator.hasNext()) {
                    long i = longiterator.nextLong();
                    ChunkPos chunkpos = new ChunkPos(i);
                    serverWorld.func_72863_F().func_217206_a(chunkpos, true);
                }
            }
            Bukkit.getPluginManager().callEvent(new WorldLoadEvent(((WorldBridge)serverWorld).bridge$getWorld()));
        }
        this.executeModerately();
        listener.func_219510_b();
        serverchunkprovider.func_212863_j_().func_215598_a(5);
        this.forceTicks = false;
    }

    @Inject(method={"updateTimeLightAndEntities"}, at={@At(value="HEAD")})
    public void arclight$runScheduler(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        ArclightConstants.currentTick = (int)(System.currentTimeMillis() / 50L);
        this.server.getScheduler().mainThreadHeartbeat(this.field_71315_w);
        this.bridge$drainQueuedTasks();
    }

    @Inject(method={"loadDataPacks(Ljava/io/File;Lnet/minecraft/world/storage/WorldInfo;)V"}, at={@At(value="HEAD")})
    private void arclight$bukkitDatapack(File file, WorldInfo p_195560_2_, CallbackInfo ci) {
        this.bukkitDataPackFolder = new File(new File(file, "datapacks"), "bukkit");
        if (!this.bukkitDataPackFolder.exists()) {
            this.bukkitDataPackFolder.mkdirs();
        }
        File mcMeta = new File(this.bukkitDataPackFolder, "pack.mcmeta");
        try {
            Files.write("{\n    \"pack\": {\n        \"description\": \"Data pack for resources provided by Bukkit plugins\",\n        \"pack_format\": " + SharedConstants.func_215069_a().getPackVersion() + "\n    }\n}\n", mcMeta, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not initialize Bukkit datapack", ex);
        }
    }

    @Override
    public void bridge$setAutosavePeriod(int autosavePeriod) {
        this.autosavePeriod = autosavePeriod;
    }

    @Override
    public void bridge$setConsole(ConsoleCommandSender console) {
        this.console = console;
    }

    @Override
    public void bridge$setServer(CraftServer server) {
        this.server = server;
    }

    @Override
    public RemoteConsoleCommandSender bridge$getRemoteConsole() {
        return this.remoteConsole;
    }

    @Override
    public void bridge$setRemoteConsole(RemoteConsoleCommandSender sender) {
        this.remoteConsole = sender;
    }

    @Override
    public void bridge$queuedProcess(Runnable runnable) {
        this.processQueue.add(runnable);
    }

    public CommandSender getBukkitSender(CommandSource wrapper) {
        return this.console;
    }

    @Override
    public CommandSender bridge$getBukkitSender(CommandSource wrapper) {
        return this.getBukkitSender(wrapper);
    }

    private static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    static {
        currentTick = (int)(System.currentTimeMillis() / 50L);
    }
}

