/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.management;

import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.server.management.PlayerInteractionManagerBridge;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SPlayerDiggingPacket;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInteractionManager.class})
public abstract class PlayerInteractionManagerMixin
implements PlayerInteractionManagerBridge {
    @Shadow
    public ServerWorld field_73092_a;
    @Shadow
    public ServerPlayerEntity field_73090_b;
    @Shadow
    private GameType field_73091_c;
    @Shadow
    private int field_73089_e;
    @Shadow
    private int field_73100_i;
    @Shadow
    private boolean field_73088_d;
    @Shadow
    private BlockPos field_180240_f;
    @Shadow
    private int field_73094_o;
    @Shadow
    private boolean field_73097_j;
    @Shadow
    private BlockPos field_180241_i;
    @Shadow
    private int field_73093_n;
    public boolean interactResult = false;
    public boolean firedInteract = false;

    @Shadow
    public abstract boolean func_73083_d();

    @Shadow
    public abstract void func_229860_a_(BlockPos var1, CPlayerDiggingPacket.Action var2, String var3);

    @Overwrite
    public void func_225416_a(BlockPos blockPos, CPlayerDiggingPacket.Action action, Direction direction, int i) {
        double d0 = this.field_73090_b.field_70165_t - ((double)blockPos.func_177958_n() + 0.5);
        double d2 = this.field_73090_b.field_70163_u - ((double)blockPos.func_177956_o() + 0.5) + 1.5;
        double d3 = this.field_73090_b.field_70161_v - ((double)blockPos.func_177952_p() + 0.5);
        double d4 = d0 * d0 + d2 * d2 + d3 * d3;
        double dist = this.field_73090_b.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0;
        dist *= dist;
        PlayerInteractEvent.LeftClickBlock forgeEvent = ForgeHooks.onLeftClickBlock((PlayerEntity)this.field_73090_b, (BlockPos)blockPos, (Direction)direction);
        if (forgeEvent.isCanceled() || !this.func_73083_d() && forgeEvent.getUseItem() == Event.Result.DENY) {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, false, "mod canceled"));
            this.field_73092_a.func_184138_a(blockPos, this.field_73092_a.func_180495_p(blockPos), this.field_73092_a.func_180495_p(blockPos), 3);
            return;
        }
        if (d4 > dist) {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, false, "too far"));
        } else if (blockPos.func_177956_o() >= i) {
            this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, false, "too high"));
        } else if (action == CPlayerDiggingPacket.Action.START_DESTROY_BLOCK) {
            if (!this.field_73092_a.func_175660_a((PlayerEntity)this.field_73090_b, blockPos)) {
                CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_73090_b, Action.LEFT_CLICK_BLOCK, blockPos, direction, this.field_73090_b.field_71071_by.func_70448_g(), Hand.MAIN_HAND);
                this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, false, "may not interact"));
                TileEntity tileentity = this.field_73092_a.func_175625_s(blockPos);
                if (tileentity != null) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)tileentity.func_189518_D_());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)this.field_73090_b, Action.LEFT_CLICK_BLOCK, blockPos, direction, this.field_73090_b.field_71071_by.func_70448_g(), Hand.MAIN_HAND);
            if (event.isCancelled()) {
                this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.field_73092_a, blockPos));
                TileEntity tileentity2 = this.field_73092_a.func_175625_s(blockPos);
                if (tileentity2 != null) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)tileentity2.func_189518_D_());
                }
                return;
            }
            if (this.func_73083_d()) {
                if (!this.field_73092_a.func_175719_a(null, blockPos, direction)) {
                    this.func_229860_a_(blockPos, action, "creative destroy");
                } else {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, true, "fire put out"));
                }
                return;
            }
            if (this.field_73090_b.func_223729_a((World)this.field_73092_a, blockPos, this.field_73091_c)) {
                this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, false, "block action restricted"));
                return;
            }
            this.field_73089_e = this.field_73100_i;
            float f = 1.0f;
            net.minecraft.block.BlockState iblockdata = this.field_73092_a.func_180495_p(blockPos);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                net.minecraft.block.BlockState data = this.field_73092_a.func_180495_p(blockPos);
                if (data.func_177230_c() instanceof DoorBlock) {
                    boolean bottom = data.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER;
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.field_73092_a, blockPos));
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.field_73092_a, bottom ? blockPos.func_177984_a() : blockPos.func_177977_b()));
                } else if (data.func_177230_c() instanceof TrapDoorBlock) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.field_73092_a, blockPos));
                }
            } else if (!iblockdata.isAir((IBlockReader)this.field_73092_a, blockPos)) {
                if (forgeEvent.getUseBlock() != Event.Result.DENY) {
                    iblockdata.func_196942_a((World)this.field_73092_a, blockPos, (PlayerEntity)this.field_73090_b);
                }
                f = iblockdata.func_185903_a((PlayerEntity)this.field_73090_b, (IBlockReader)this.field_73090_b.field_70170_p, blockPos);
                this.field_73092_a.func_175719_a(null, blockPos, direction);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f > 1.0f) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.field_73092_a, blockPos));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent((PlayerEntity)this.field_73090_b, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), this.field_73090_b.field_71071_by.func_70448_g(), f >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.field_73092_a, blockPos));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f = 2.0f;
            }
            if (!iblockdata.isAir((IBlockReader)this.field_73092_a, blockPos) && f >= 1.0f) {
                this.func_229860_a_(blockPos, action, "insta mine");
            } else {
                if (this.field_73088_d) {
                    this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(this.field_180240_f, this.field_73092_a.func_180495_p(this.field_180240_f), CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, false, "abort destroying since another started (client insta mine, server disagreed)"));
                }
                this.field_73088_d = true;
                this.field_180240_f = blockPos;
                int j = (int)(f * 10.0f);
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), blockPos, j);
                this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, true, "actual start of destroying"));
                this.field_73094_o = j;
            }
        } else if (action == CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK) {
            if (blockPos.equals((Object)this.field_180240_f)) {
                int k = this.field_73100_i - this.field_73089_e;
                net.minecraft.block.BlockState iblockdata = this.field_73092_a.func_180495_p(blockPos);
                if (!iblockdata.func_196958_f()) {
                    float f2 = iblockdata.func_185903_a((PlayerEntity)this.field_73090_b, (IBlockReader)this.field_73090_b.field_70170_p, blockPos) * (float)(k + 1);
                    if (f2 >= 0.7f) {
                        this.field_73088_d = false;
                        this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), blockPos, -1);
                        this.func_229860_a_(blockPos, action, "destroyed");
                        return;
                    }
                    if (!this.field_73097_j) {
                        this.field_73088_d = false;
                        this.field_73097_j = true;
                        this.field_180241_i = blockPos;
                        this.field_73093_n = this.field_73089_e;
                    }
                }
            }
            this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, true, "stopped destroying"));
        } else if (action == CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK) {
            this.field_73088_d = false;
            if (!Objects.equals(this.field_180240_f, blockPos)) {
                ArclightMod.LOGGER.debug("Mismatch in destroy block pos: " + this.field_180240_f + " " + blockPos);
                this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), this.field_180240_f, -1);
                this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(this.field_180240_f, this.field_73092_a.func_180495_p(this.field_180240_f), action, true, "aborted mismatched destroying"));
            }
            this.field_73092_a.func_175715_c(this.field_73090_b.func_145782_y(), blockPos, -1);
            this.field_73090_b.field_71135_a.func_147359_a((IPacket)new SPlayerDiggingPacket(blockPos, this.field_73092_a.func_180495_p(blockPos), action, true, "aborted destroying"));
        }
    }

    @Inject(method={"tryHarvestBlock"}, at={@At(value="RETURN")})
    public void arclight$resetBlockBreak(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        List<ItemEntity> blockDrops = ArclightCaptures.getBlockDrops();
        BlockState state = ArclightCaptures.getBlockBreakPlayerState();
        BlockBreakEvent breakEvent = ArclightCaptures.resetBlockBreakPlayer();
        if (blockDrops != null && (breakEvent == null || breakEvent.isDropItems())) {
            CraftBlock craftBlock = CraftBlock.at((IWorld)this.field_73092_a, pos);
            CraftEventFactory.handleBlockDropItemEvent(craftBlock, state, this.field_73090_b, blockDrops);
        }
    }

    @Override
    public boolean bridge$isFiredInteract() {
        return this.firedInteract;
    }

    @Override
    public void bridge$setFiredInteract(boolean b) {
        this.firedInteract = b;
    }

    @Override
    public boolean bridge$getInteractResult() {
        return this.interactResult;
    }

    @Override
    public void bridge$setInteractResult(boolean b) {
        this.interactResult = b;
    }

    @Overwrite
    public ActionResultType func_219441_a(PlayerEntity playerIn, World worldIn, ItemStack stackIn, Hand handIn, BlockRayTraceResult blockRaytraceResultIn) {
        BlockPos blockpos = blockRaytraceResultIn.func_216350_a();
        net.minecraft.block.BlockState blockstate = worldIn.func_180495_p(blockpos);
        ActionResultType resultType = ActionResultType.PASS;
        boolean cancelledBlock = false;
        if (this.field_73091_c == GameType.SPECTATOR) {
            INamedContainerProvider provider = blockstate.func_215699_b(worldIn, blockpos);
            boolean bl = cancelledBlock = !(provider instanceof INamedContainerProvider);
        }
        if (playerIn.func_184811_cZ().func_185141_a(stackIn.func_77973_b())) {
            cancelledBlock = true;
        }
        PlayerInteractEvent bukkitEvent = CraftEventFactory.callPlayerInteractEvent(playerIn, Action.RIGHT_CLICK_BLOCK, blockpos, blockRaytraceResultIn.func_216354_b(), stackIn, cancelledBlock, handIn);
        this.bridge$setFiredInteract(true);
        this.bridge$setInteractResult(bukkitEvent.useItemInHand() == Event.Result.DENY);
        if (bukkitEvent.useInteractedBlock() == Event.Result.DENY) {
            if (blockstate.func_177230_c() instanceof DoorBlock) {
                boolean bottom = blockstate.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER;
                ((ServerPlayerEntity)playerIn).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)this.field_73092_a, bottom ? blockpos.func_177984_a() : blockpos.func_177977_b()));
            } else if (blockstate.func_177230_c() instanceof CakeBlock) {
                ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().sendHealthUpdate();
            }
        } else {
            boolean flag1;
            ActionResultType result;
            if (this.field_73091_c == GameType.SPECTATOR) {
                INamedContainerProvider inamedcontainerprovider = blockstate.func_215699_b(worldIn, blockpos);
                if (inamedcontainerprovider != null) {
                    playerIn.func_213829_a(inamedcontainerprovider);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)playerIn, (Hand)handIn, (BlockPos)blockpos, (Direction)blockRaytraceResultIn.func_216354_b());
            if (event.isCanceled()) {
                return event.getCancellationResult();
            }
            ItemUseContext itemusecontext = new ItemUseContext(playerIn, handIn, blockRaytraceResultIn);
            if (event.getUseItem() != Event.Result.DENY && (result = stackIn.onItemUseFirst(itemusecontext)) != ActionResultType.PASS) {
                return result;
            }
            boolean flag = !playerIn.func_184614_ca().func_190926_b() || !playerIn.func_184592_cb().func_190926_b();
            boolean bl = flag1 = playerIn.func_226563_dT_() && flag && (!playerIn.func_184614_ca().doesSneakBypassUse((IWorldReader)worldIn, blockpos, playerIn) || !playerIn.func_184592_cb().doesSneakBypassUse((IWorldReader)worldIn, blockpos, playerIn));
            if (event.getUseBlock() != Event.Result.DENY && !flag1 && (resultType = blockstate.func_227031_a_(worldIn, playerIn, handIn, blockRaytraceResultIn)).func_226246_a_()) {
                return resultType;
            }
            if (!stackIn.func_190926_b() && resultType != ActionResultType.SUCCESS && !this.bridge$getInteractResult()) {
                if (event.getUseItem() == Event.Result.DENY) {
                    return ActionResultType.PASS;
                }
                if (this.func_73083_d()) {
                    int i = stackIn.func_190916_E();
                    resultType = stackIn.func_196084_a(itemusecontext);
                    stackIn.func_190920_e(i);
                    return resultType;
                }
                return stackIn.func_196084_a(itemusecontext);
            }
            return resultType;
        }
        ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().updateInventory();
        resultType = bukkitEvent.useItemInHand() != Event.Result.ALLOW ? ActionResultType.SUCCESS : ActionResultType.PASS;
        return resultType;
    }
}

