/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.management;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.izzel.arclight.api.ArclightVersion;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.InternalEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.network.login.ServerLoginNetHandlerBridge;
import io.izzel.arclight.common.bridge.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.server.management.PlayerListBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.dimension.DimensionTypeBridge;
import io.izzel.arclight.common.bridge.world.server.ServerWorldBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSpawnPositionPacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.spigotmc.SpigotConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    public IPlayerFileData field_72412_k;
    @Shadow
    @Final
    private BanList field_72401_g;
    @Shadow
    @Final
    private static SimpleDateFormat field_72403_e;
    @Shadow
    @Final
    private IPBanList field_72413_h;
    @Shadow
    @Final
    public List<ServerPlayerEntity> field_72404_b;
    @Shadow
    @Final
    protected int field_72405_c;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;
    @Shadow
    @Final
    private Map<UUID, ServerPlayerEntity> field_177454_f;
    private CraftServer cserver;
    private transient Location arclight$loc;
    private transient Boolean arclight$suffo;

    @Override
    @Accessor(value="players")
    @Mutable
    public abstract void bridge$setPlayers(List<ServerPlayerEntity> var1);

    @Override
    @Accessor(value="players")
    public abstract List<ServerPlayerEntity> bridge$getPlayers();

    @Shadow
    public abstract void func_148544_a(ITextComponent var1, boolean var2);

    @Shadow
    public abstract boolean func_152607_e(GameProfile var1);

    @Shadow
    public abstract boolean func_183023_f(GameProfile var1);

    @Shadow
    protected abstract void func_72391_b(ServerPlayerEntity var1);

    @Shadow
    public abstract BanList func_152608_h();

    @Shadow
    public abstract IPBanList func_72363_f();

    @Shadow(remap=false)
    public abstract boolean removePlayer(ServerPlayerEntity var1);

    @Shadow
    protected abstract void func_72381_a(ServerPlayerEntity var1, ServerPlayerEntity var2, IWorld var3);

    @Shadow
    public abstract void func_72354_b(ServerPlayerEntity var1, ServerWorld var2);

    @Shadow
    public abstract void func_187243_f(ServerPlayerEntity var1);

    @Shadow(remap=false)
    public abstract boolean addPlayer(ServerPlayerEntity var1);

    @Shadow
    public abstract void func_72385_f(ServerPlayerEntity var1);

    @Override
    public CraftServer bridge$getCraftServer() {
        return this.cserver;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$loadCraftBukkit(MinecraftServer minecraftServer, int i, CallbackInfo ci) {
        this.cserver = ArclightServer.createOrLoad((DedicatedServer)minecraftServer, (PlayerList)this);
    }

    @Inject(method={"initializeConnectionToPlayer"}, at={@At(value="INVOKE", remap=false, target="Lnet/minecraftforge/fml/network/NetworkHooks;sendMCRegistryPackets(Lnet/minecraft/network/NetworkManager;Ljava/lang/String;)V")})
    private void arclight$sendChannel(NetworkManager netManager, ServerPlayerEntity playerIn, CallbackInfo ci) {
        ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().sendSupportedChannels();
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="NEW", target="net/minecraft/network/play/server/SJoinGamePacket"))
    private SJoinGamePacket arclight$spawnPacket(int playerId, GameType gameType, long hashedSeed, boolean hardcoreMode, DimensionType dimensionType, int maxPlayers, WorldType worldType, int viewDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, NetworkManager netManager, ServerPlayerEntity playerIn) {
        return new SJoinGamePacket(playerId, gameType, hashedSeed, hardcoreMode, ((DimensionTypeBridge)dimensionType).bridge$getType(), maxPlayers, worldType, ((ServerWorldBridge)playerIn.func_71121_q()).bridge$spigotConfig().viewDistance, reducedDebugInfo, enableRespawnScreen);
    }

    @Inject(method={"func_212504_a"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnIfSet(ServerWorld world, CallbackInfo ci) {
        if (this.field_72412_k != null) {
            ci.cancel();
        }
    }

    @Inject(method={"writePlayerData"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnIfNotPersist(ServerPlayerEntity playerIn, CallbackInfo ci) {
        if (!((ServerPlayerEntityBridge)playerIn).bridge$isPersist()) {
            ci.cancel();
        }
    }

    @Override
    public ServerPlayerEntity bridge$canPlayerLogin(SocketAddress socketAddress, GameProfile gameProfile, ServerLoginNetHandler handler) {
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)gameProfile);
        ArrayList<ServerPlayerEntity> list = Lists.newArrayList();
        for (ServerPlayerEntity entityplayer : this.field_72404_b) {
            if (!entityplayer.func_110124_au().equals(uuid)) continue;
            list.add(entityplayer);
        }
        for (ServerPlayerEntity entityplayer : list) {
            this.func_72391_b(entityplayer);
            entityplayer.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.duplicate_login", new Object[0]));
        }
        ServerPlayerEntity entity = new ServerPlayerEntity(this.field_72400_f, this.field_72400_f.func_71218_a(DimensionType.field_223227_a_), gameProfile, new PlayerInteractionManager(this.field_72400_f.func_71218_a(DimensionType.field_223227_a_)));
        CraftPlayer player = ((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity();
        String hostname = handler == null ? "" : ((ServerLoginNetHandlerBridge)handler).bridge$getHostname();
        InetAddress realAddress = handler == null ? ((InetSocketAddress)socketAddress).getAddress() : ((InetSocketAddress)((NetworkManagerBridge)handler.field_147333_a).bridge$getRawAddress()).getAddress();
        PlayerLoginEvent event = new PlayerLoginEvent(player, hostname, ((InetSocketAddress)socketAddress).getAddress(), realAddress);
        if (this.func_152608_h().func_152702_a(gameProfile) && !((ProfileBanEntry)this.func_152608_h().func_152683_b((Object)gameProfile)).func_73682_e()) {
            ProfileBanEntry gameprofilebanentry = (ProfileBanEntry)this.field_72401_g.func_152683_b((Object)gameProfile);
            TranslationTextComponent chatmessage = new TranslationTextComponent("multiplayer.disconnect.banned.reason", new Object[]{gameprofilebanentry.func_73686_f()});
            if (gameprofilebanentry.func_73680_d() != null) {
                chatmessage.func_150257_a((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned.expiration", new Object[]{field_72403_e.format(gameprofilebanentry.func_73680_d())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((ITextComponent)chatmessage));
        } else if (!this.func_152607_e(gameProfile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.func_72363_f().func_152708_a(socketAddress) && !this.func_72363_f().func_152709_b(socketAddress).func_73682_e()) {
            IPBanEntry ipbanentry = this.field_72413_h.func_152709_b(socketAddress);
            TranslationTextComponent chatmessage = new TranslationTextComponent("multiplayer.disconnect.banned_ip.reason", new Object[]{ipbanentry.func_73686_f()});
            if (ipbanentry.func_73680_d() != null) {
                chatmessage.func_150257_a((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned_ip.expiration", new Object[]{field_72403_e.format(ipbanentry.func_73680_d())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((ITextComponent)chatmessage));
        } else if (this.field_72404_b.size() >= this.field_72405_c && !this.func_183023_f(gameProfile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent(event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            if (handler != null) {
                handler.func_194026_b(CraftChatMessage.fromStringOrNull(event.getKickMessage()));
            }
            return null;
        }
        return entity;
    }

    public ServerPlayerEntity moveToWorld(ServerPlayerEntity playerIn, DimensionType type, boolean flag, Location location, boolean avoidSuffocation) {
        if (!ForgeHooks.onTravelToDimension((Entity)playerIn, (DimensionType)type)) {
            return playerIn;
        }
        playerIn.func_184210_p();
        this.field_72404_b.remove(playerIn);
        playerIn.func_71121_q().removePlayer(playerIn, true);
        playerIn.revive();
        BlockPos pos = playerIn.getBedLocation(type);
        boolean flag2 = playerIn.isSpawnForced(type);
        org.bukkit.World fromWorld = ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().getWorld();
        playerIn.field_71136_j = false;
        if (location == null) {
            boolean isBedSpawn = false;
            CraftWorld cworld = (CraftWorld)Bukkit.getServer().getWorld(((ServerPlayerEntityBridge)playerIn).bridge$getSpawnWorld());
            if (cworld != null && pos != null) {
                Optional optional = PlayerEntity.func_213822_a((IWorldReader)cworld.getHandle(), (BlockPos)pos, (boolean)flag2);
                if (optional.isPresent()) {
                    Vec3d vec3d = (Vec3d)optional.get();
                    isBedSpawn = true;
                    location = new Location(cworld, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                } else {
                    playerIn.setSpawnPoint(null, true, false, playerIn.field_71093_bK);
                    playerIn.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(0, 0.0f));
                }
            }
            if (location == null) {
                cworld = (CraftWorld)Bukkit.getServer().getWorlds().get(0);
                pos = ((ServerPlayerEntityBridge)playerIn).bridge$getSpawnPoint(cworld.getHandle());
                location = new Location(cworld, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.1f, (float)pos.func_177952_p() + 0.5f);
            }
            Player respawnPlayer = this.cserver.getPlayer(playerIn);
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(respawnPlayer, location, isBedSpawn);
            this.cserver.getPluginManager().callEvent(respawnEvent);
            if (((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
                return playerIn;
            }
            location = respawnEvent.getRespawnLocation();
            if (!flag) {
                ((ServerPlayerEntityBridge)playerIn).bridge$reset();
            }
        } else {
            location.setWorld(((WorldBridge)this.field_72400_f.func_71218_a(type)).bridge$getWorld());
        }
        ServerWorld serverWorld = ((CraftWorld)location.getWorld()).getHandle();
        playerIn.func_70080_a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        playerIn.field_71135_a.func_184342_d();
        while (avoidSuffocation && !serverWorld.func_226669_j_((Entity)playerIn) && playerIn.func_226278_cu_() < 256.0) {
            playerIn.func_70107_b(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + 1.0, playerIn.func_226281_cx_());
        }
        WorldInfo worldInfo = serverWorld.func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)playerIn.field_71135_a.field_147371_a, (ServerPlayerEntity)playerIn);
        playerIn.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(((DimensionTypeBridge)serverWorld.field_73011_w.func_186058_p()).bridge$getType(), WorldInfo.func_227498_c_((long)serverWorld.func_72912_H().func_76063_b()), serverWorld.func_72912_H().func_76067_t(), playerIn.field_71134_c.func_73081_b()));
        playerIn.field_71135_a.func_147359_a((IPacket)new SUpdateViewDistancePacket(((ServerWorldBridge)serverWorld).bridge$spigotConfig().viewDistance));
        playerIn.func_70029_a((World)serverWorld);
        playerIn.field_71134_c.func_73080_a(serverWorld);
        ((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$teleport(new Location(((WorldBridge)serverWorld).bridge$getWorld(), playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), playerIn.field_70177_z, playerIn.field_70125_A));
        playerIn.func_226284_e_(false);
        BlockPos pos1 = serverWorld.func_175694_M();
        playerIn.field_71135_a.func_147359_a((IPacket)new SSpawnPositionPacket(pos1));
        playerIn.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldInfo.func_176130_y(), worldInfo.func_176123_z()));
        playerIn.field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(playerIn.field_71106_cc, playerIn.field_71067_cb, playerIn.field_71068_ca));
        this.func_72354_b(playerIn, serverWorld);
        this.func_187243_f(playerIn);
        if (!((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
            serverWorld.func_217446_a(playerIn);
            this.field_72404_b.add(playerIn);
            this.field_177454_f.put(playerIn.func_110124_au(), playerIn);
        }
        playerIn.func_70606_j(playerIn.func_110143_aJ());
        this.func_72385_f(playerIn);
        playerIn.func_71016_p();
        for (Object o1 : playerIn.func_70651_bq()) {
            EffectInstance mobEffect = (EffectInstance)o1;
            playerIn.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(playerIn.func_145782_y(), mobEffect));
        }
        playerIn.func_213846_b(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity(), fromWorld);
            Bukkit.getPluginManager().callEvent(event);
        }
        if (((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
            this.func_72391_b(playerIn);
        }
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)playerIn, (DimensionType)((CraftWorld)fromWorld).getHandle().field_73011_w.func_186058_p(), (DimensionType)serverWorld.field_73011_w.func_186058_p());
        return playerIn;
    }

    @Overwrite
    public ServerPlayerEntity func_72368_a(ServerPlayerEntity playerIn, DimensionType dimension, boolean conqueredEnd) {
        Location location = this.arclight$loc;
        this.arclight$loc = null;
        boolean avoidSuffocation = this.arclight$suffo == null ? true : this.arclight$suffo;
        this.arclight$suffo = null;
        playerIn.func_184210_p();
        org.bukkit.World fromWorld = ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().getWorld();
        ServerWorld world = this.field_72400_f.func_71218_a(dimension);
        if (world == null) {
            dimension = playerIn.getSpawnDimension();
        } else if (!world.func_201675_m().func_76567_e()) {
            dimension = world.func_201675_m().getRespawnDimension(playerIn);
        }
        if (this.field_72400_f.func_71218_a(dimension) == null) {
            dimension = DimensionType.field_223227_a_;
        }
        this.removePlayer(playerIn);
        playerIn.func_71121_q().removePlayer(playerIn, true);
        BlockPos blockpos = playerIn.getBedLocation(dimension);
        boolean flag = playerIn.isSpawnForced(dimension);
        boolean setSpawn = false;
        playerIn.field_71136_j = false;
        if (location == null) {
            boolean isBedSpawn = false;
            CraftWorld cworld = (CraftWorld)Bukkit.getWorld(((PlayerEntityBridge)playerIn).bridge$getSpawnWorld());
            if (cworld != null && blockpos != null) {
                Optional optional = PlayerEntity.func_213822_a((IWorldReader)cworld.getHandle(), (BlockPos)blockpos, (boolean)flag);
                if (optional.isPresent()) {
                    Vec3d vec3d = (Vec3d)optional.get();
                    isBedSpawn = true;
                    location = new Location(cworld, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    setSpawn = true;
                } else {
                    playerIn.setSpawnPoint(null, true, false, playerIn.field_71093_bK);
                    playerIn.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(0, 0.0f));
                }
            }
            if (location == null) {
                cworld = (CraftWorld)Bukkit.getWorlds().get(0);
                blockpos = ((ServerPlayerEntityBridge)playerIn).bridge$getSpawnPoint(cworld.getHandle());
                location = new Location(cworld, (float)blockpos.func_177958_n() + 0.5f, (float)blockpos.func_177956_o() + 0.1f, (float)blockpos.func_177952_p() + 0.5f);
            }
            Player respawnPlayer = this.cserver.getPlayer(playerIn);
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(respawnPlayer, location, isBedSpawn);
            this.cserver.getPluginManager().callEvent(respawnEvent);
            if (((ServerPlayNetHandlerBridge)playerIn.field_71135_a).bridge$isDisconnected()) {
                return playerIn;
            }
            location = respawnEvent.getRespawnLocation();
            if (location.getWorld() == null) {
                location.setWorld(((WorldBridge)this.field_72400_f.func_71218_a(dimension)).bridge$getWorld());
            }
            dimension = ((CraftWorld)location.getWorld()).getHandle().field_73011_w.func_186058_p();
            if (!flag) {
                ((ServerPlayerEntityBridge)playerIn).bridge$reset();
            }
        } else {
            location.setWorld(((WorldBridge)this.field_72400_f.func_71218_a(dimension)).bridge$getWorld());
        }
        playerIn.field_71093_bK = dimension;
        ServerWorld serverworld = ((CraftWorld)location.getWorld()).getHandle();
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager(serverworld) : new PlayerInteractionManager(serverworld);
        ServerPlayerEntity serverplayerentity = new ServerPlayerEntity(this.field_72400_f, serverworld, playerIn.func_146103_bH(), (PlayerInteractionManager)playerinteractionmanager);
        ((InternalEntityBridge)playerIn).internal$getBukkitEntity().setHandle((Entity)serverplayerentity);
        ((EntityBridge)serverplayerentity).bridge$setBukkitEntity(((InternalEntityBridge)playerIn).internal$getBukkitEntity());
        if (serverplayerentity instanceof MobEntity) {
            ((MobEntity)playerIn).func_110160_i(true, false);
        }
        serverplayerentity.field_71135_a = playerIn.field_71135_a;
        serverplayerentity.func_193104_a(playerIn, true);
        if (setSpawn) {
            serverplayerentity.setSpawnPoint(blockpos, flag, false, dimension);
        }
        playerIn.remove(false);
        serverplayerentity.field_71093_bK = dimension;
        serverplayerentity.field_71134_c.func_73080_a(serverworld);
        serverplayerentity.func_145769_d(playerIn.func_145782_y());
        serverplayerentity.func_184819_a(playerIn.func_184591_cq());
        for (String s2 : playerIn.func_184216_O()) {
            serverplayerentity.func_184211_a(s2);
        }
        serverplayerentity.func_70080_a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        serverplayerentity.field_71135_a.func_184342_d();
        this.func_72381_a(serverplayerentity, playerIn, (IWorld)serverworld);
        while (avoidSuffocation && !serverworld.func_226669_j_((Entity)serverplayerentity) && serverplayerentity.field_70163_u < 256.0) {
            serverplayerentity.func_70107_b(serverplayerentity.field_70165_t, serverplayerentity.field_70163_u + 1.0, serverplayerentity.field_70161_v);
        }
        if (fromWorld.getEnvironment() == ((WorldBridge)serverworld).bridge$getWorld().getEnvironment()) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(((DimensionTypeBridge)serverplayerentity.field_71093_bK).bridge$getType().func_186068_a() >= 0 ? DimensionType.field_223228_b_ : DimensionType.field_223227_a_, WorldInfo.func_227498_c_((long)serverworld.func_72912_H().func_76063_b()), serverworld.func_72912_H().func_76067_t(), playerIn.field_71134_c.func_73081_b()));
        }
        WorldInfo worldinfo = serverplayerentity.field_70170_p.func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)serverplayerentity.field_71135_a.field_147371_a, (ServerPlayerEntity)serverplayerentity);
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(((DimensionTypeBridge)serverplayerentity.field_71093_bK).bridge$getType(), WorldInfo.func_227498_c_((long)worldinfo.func_76063_b()), worldinfo.func_76067_t(), serverplayerentity.field_71134_c.func_73081_b()));
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SUpdateViewDistancePacket(((WorldBridge)serverworld).bridge$spigotConfig().viewDistance));
        BlockPos blockpos1 = serverworld.func_175694_M();
        serverplayerentity.field_71135_a.func_147364_a(serverplayerentity.field_70165_t, serverplayerentity.field_70163_u, serverplayerentity.field_70161_v, serverplayerentity.field_70177_z, serverplayerentity.field_70125_A);
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSpawnPositionPacket(blockpos1));
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(serverplayerentity.field_71106_cc, serverplayerentity.field_71067_cb, serverplayerentity.field_71068_ca));
        this.func_72354_b(serverplayerentity, serverworld);
        this.func_187243_f(serverplayerentity);
        if (!((ServerPlayNetHandlerBridge)serverplayerentity.field_71135_a).bridge$isDisconnected()) {
            serverworld.func_217433_d(serverplayerentity);
            this.addPlayer(serverplayerentity);
            this.field_177454_f.put(serverplayerentity.func_110124_au(), serverplayerentity);
        }
        serverplayerentity.func_71116_b();
        serverplayerentity.func_70606_j(serverplayerentity.func_110143_aJ());
        this.func_72385_f(serverplayerentity);
        serverplayerentity.func_71016_p();
        serverplayerentity.func_213846_b(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity(), fromWorld);
            Bukkit.getPluginManager().callEvent(event);
        }
        BasicEventHooks.firePlayerRespawnEvent((PlayerEntity)serverplayerentity, (boolean)conqueredEnd);
        return serverplayerentity;
    }

    public void sendAll(IPacket<?> packet, PlayerEntity entityhuman) {
        for (ServerPlayerEntity entityplayer : this.field_72404_b) {
            if (entityhuman instanceof ServerPlayerEntity && !((ServerPlayerEntityBridge)entityplayer).bridge$getBukkitEntity().canSee(((ServerPlayerEntityBridge)entityhuman).bridge$getBukkitEntity())) continue;
            entityplayer.field_71135_a.func_147359_a(packet);
        }
    }

    public void sendAll(IPacket<?> packet, World world) {
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            ((ServerPlayerEntity)world.func_217369_A().get((int)i)).field_71135_a.func_147359_a(packet);
        }
    }

    @Inject(method={"sendPlayerPermissionLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCommandManager()Lnet/minecraft/command/Commands;")})
    private void arclight$calculatePerms(ServerPlayerEntity player, int permLevel, CallbackInfo ci) {
        ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity().recalculatePermissions();
    }

    @Redirect(method={"sendInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;setPlayerHealthUpdated()V"))
    private void arclight$useScaledHealth(ServerPlayerEntity playerEntity) {
        ((ServerPlayerEntityBridge)playerEntity).bridge$getBukkitEntity().updateScaledHealth();
        int i = playerEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223612_o) ? 22 : 23;
        playerEntity.field_71135_a.func_147359_a((IPacket)new SEntityStatusPacket((Entity)playerEntity, (byte)i));
        if (ArclightVersion.atLeast(ArclightVersion.v1_15)) {
            float immediateRespawn = playerEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226683_z_) ? 1.0f : 0.0f;
            playerEntity.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(11, immediateRespawn));
        }
    }

    @Redirect(method={"sendMessage(Lnet/minecraft/util/text/ITextComponent;Z)V"}, at=@At(value="NEW", target="net/minecraft/network/play/server/SChatPacket"))
    private SChatPacket arclight$addWebLinks(ITextComponent message, ChatType type) {
        return new SChatPacket(CraftChatMessage.fixComponent(message), type);
    }

    @Inject(method={"initializeConnectionToPlayer"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V")})
    private void arclight$playerJoinKick(NetworkManager netManager, ServerPlayerEntity playerIn, CallbackInfo ci) {
        if (!playerIn.field_71135_a.field_147371_a.func_150724_d()) {
            ci.cancel();
        }
    }

    @Redirect(method={"initializeConnectionToPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V"))
    private void arclight$playerJoin(PlayerList playerList, ITextComponent component, NetworkManager netManager, ServerPlayerEntity playerIn) {
        ITextComponent[] postMessage;
        String joinMessage = CraftChatMessage.fromComponent(component);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent(this.cserver.getPlayer(playerIn), joinMessage);
        this.field_72404_b.add(playerIn);
        this.field_177454_f.put(playerIn.func_110124_au(), playerIn);
        this.cserver.getPluginManager().callEvent(playerJoinEvent);
        if (!playerIn.field_71135_a.field_147371_a.func_150724_d()) {
            return;
        }
        this.field_72404_b.remove(playerIn);
        for (ITextComponent textComponent : postMessage = CraftChatMessage.fromString(playerJoinEvent.getJoinMessage())) {
            this.func_148544_a(textComponent, true);
        }
    }

    @Inject(method={"playerLoggedOut"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;writePlayerData(Lnet/minecraft/entity/player/ServerPlayerEntity;)V")})
    public void arclight$playerQuitPre(ServerPlayerEntity playerIn, CallbackInfo ci) {
        CraftEventFactory.handleInventoryCloseEvent((PlayerEntity)playerIn);
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent(this.cserver.getPlayer(playerIn), "\u00a7e" + playerIn.func_200200_C_().func_150254_d() + " left the game");
        this.cserver.getPluginManager().callEvent(playerQuitEvent);
        ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        playerIn.func_71127_g();
        ArclightCaptures.captureQuitMessage(playerQuitEvent.getQuitMessage());
    }
}

