/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world;

import io.izzel.arclight.api.ArclightVersion;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.border.WorldBorderBridge;
import io.izzel.arclight.common.bridge.world.dimension.DimensionTypeBridge;
import io.izzel.arclight.common.bridge.world.storage.DerivedWorldInfoBridge;
import io.izzel.arclight.common.mod.server.world.WrappedWorlds;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_15_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={World.class})
public abstract class WorldMixin
implements WorldBridge,
IWorldWriter {
    @Shadow
    public Dimension field_73011_w;
    @Shadow
    @Final
    public WorldInfo field_72986_A;
    @Shadow
    @Final
    private WorldBorder field_175728_M;
    protected CraftWorld world;
    public boolean pvpMode;
    public boolean keepSpawnInMemory = true;
    public long ticksPerAnimalSpawns;
    public long ticksPerMonsterSpawns;
    public long ticksPerWaterSpawns;
    public long ticksPerAmbientSpawns;
    public boolean populating;
    public ChunkGenerator generator;
    protected World.Environment environment;
    public SpigotWorldConfig spigotConfig;

    @Shadow
    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return null;
    }

    @Shadow
    public abstract BlockState func_180495_p(BlockPos var1);

    @Shadow
    public abstract void func_175690_a(BlockPos var1, @Nullable TileEntity var2);

    @Shadow
    public abstract WorldInfo func_72912_H();

    @Shadow
    public abstract Dimension func_201675_m();

    @Shadow
    public abstract long func_72905_C();

    @Shadow
    public abstract WorldBorder func_175723_af();

    @Shadow
    public abstract long func_72820_D();

    @Accessor(value="mainThread")
    public abstract Thread arclight$getMainThread();

    @Inject(method={"<init>(Lnet/minecraft/world/storage/WorldInfo;Lnet/minecraft/world/dimension/DimensionType;Ljava/util/function/BiFunction;Lnet/minecraft/profiler/IProfiler;Z)V"}, at={@At(value="RETURN")})
    private void arclight$init(WorldInfo info, DimensionType dimType, BiFunction<World, Dimension, AbstractChunkProvider> provider, IProfiler profilerIn, boolean remote, CallbackInfo ci) {
        if (info instanceof DerivedWorldInfoBridge) {
            ((DerivedWorldInfoBridge)info).bridge$setDimension(dimType);
        }
        this.spigotConfig = new SpigotWorldConfig(info.func_76065_j());
        ((WorldBorderBridge)this.field_175728_M).bridge$setWorld((World)this);
        this.ticksPerAnimalSpawns = this.getServer().getTicksPerAnimalSpawns();
        this.ticksPerMonsterSpawns = this.getServer().getTicksPerMonsterSpawns();
        if (ArclightVersion.atLeast(ArclightVersion.v1_15)) {
            this.ticksPerWaterSpawns = this.getServer().getTicksPerWaterSpawns();
            this.ticksPerAmbientSpawns = this.getServer().getTicksPerAmbientSpawns();
        } else {
            this.ticksPerWaterSpawns = 1L;
            this.ticksPerAmbientSpawns = 1L;
        }
    }

    @Override
    public long bridge$ticksPerAnimalSpawns() {
        return this.ticksPerAnimalSpawns;
    }

    @Override
    public long bridge$ticksPerMonsterSpawns() {
        return this.ticksPerMonsterSpawns;
    }

    @Override
    public long bridge$ticksPerWaterSpawns() {
        return this.ticksPerWaterSpawns;
    }

    @Override
    public long bridge$ticksPerAmbientSpawns() {
        return this.ticksPerAmbientSpawns;
    }

    public void arclight$constructor(WorldInfo info, DimensionType dimType, BiFunction<World, Dimension, AbstractChunkProvider> provider, IProfiler profilerIn, boolean remote) {
        throw new RuntimeException();
    }

    public void arclight$constructor(WorldInfo info, DimensionType dimType, BiFunction<World, Dimension, AbstractChunkProvider> provider, IProfiler profilerIn, boolean remote, ChunkGenerator gen, World.Environment env) {
        this.arclight$constructor(info, dimType, provider, profilerIn, remote);
        this.generator = gen;
        this.environment = env;
        this.bridge$getWorld();
    }

    @Override
    public SpigotWorldConfig bridge$spigotConfig() {
        return this.spigotConfig;
    }

    @Inject(method={"setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void arclight$hooks(BlockPos pos, BlockState newState, int flags, CallbackInfoReturnable<Boolean> cir) {
        if (!this.processCaptures(pos, newState, flags)) {
            cir.setReturnValue((Object)false);
        }
    }

    private boolean processCaptures(BlockPos pos, BlockState newState, int flags) {
        Entity entityChangeBlock = ArclightCaptures.getEntityChangeBlock();
        return entityChangeBlock == null || !CraftEventFactory.callEntityChangeBlockEvent(entityChangeBlock, pos, newState).isCancelled();
    }

    @Inject(method={"markAndNotifyBlock"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;updateNeighbors(Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;I)V")})
    private void arclight$callBlockPhysics(BlockPos pos, Chunk chunk, BlockState blockstate, BlockState newState, int flags, CallbackInfo ci) {
        if (this.world != null) {
            BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at((IWorld)this, pos), CraftBlockData.fromData(newState));
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"notifyNeighbors"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;notifyNeighborsOfStateChange(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;)V")})
    private void arclight$noPhysicsPopulating(BlockPos pos, Block blockIn, CallbackInfo ci) {
        if (this.populating) {
            ci.cancel();
        }
    }

    @Inject(method={"neighborChanged"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;neighborChanged(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/util/math/BlockPos;Z)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void arclight$callBlockPhysics2(BlockPos pos, Block blockIn, BlockPos fromPos, CallbackInfo ci, BlockState blockState) {
        if (this.world != null) {
            IWorld iWorld = (IWorld)this;
            BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at(iWorld, pos), CraftBlockData.fromData(blockState), CraftBlock.at(iWorld, fromPos));
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Redirect(method={"isNightTime"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/dimension/Dimension;getType()Lnet/minecraft/world/dimension/DimensionType;"))
    private DimensionType arclight$nightTimeType(Dimension dimension) {
        return ((DimensionTypeBridge)dimension.func_186058_p()).bridge$getType();
    }

    public CraftServer getServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public CraftWorld getWorld() {
        if (this.world == null) {
            Optional<Field> delegate = WrappedWorlds.getDelegate(this.getClass());
            if (delegate.isPresent()) {
                try {
                    return ((WorldBridge)delegate.get().get(this)).bridge$getWorld();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.generator == null) {
                this.generator = this.getServer().getGenerator(this.func_72912_H().func_76065_j());
            }
            if (this.environment == null) {
                this.environment = World.Environment.getEnvironment(this.func_201675_m().func_186058_p().func_186068_a());
            }
            this.world = new CraftWorld((ServerWorld)this, this.generator, this.environment);
            this.getServer().addWorld(this.world);
        }
        return this.world;
    }

    public TileEntity getTileEntity(BlockPos pos, boolean validate) {
        return this.func_175625_s(pos);
    }

    @Override
    public TileEntity bridge$getTileEntity(BlockPos pos, boolean validate) {
        return this.getTileEntity(pos, validate);
    }

    @Override
    public CraftServer bridge$getServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public CraftWorld bridge$getWorld() {
        return this.getWorld();
    }

    @Override
    public boolean bridge$isPvpMode() {
        return this.pvpMode;
    }

    @Override
    public boolean bridge$isKeepSpawnInMemory() {
        return this.keepSpawnInMemory;
    }

    @Override
    public boolean bridge$isPopulating() {
        return this.populating;
    }

    @Override
    public void bridge$setPopulating(boolean populating) {
        this.populating = populating;
    }

    @Override
    public ChunkGenerator bridge$getGenerator() {
        return this.generator;
    }

    @Override
    public boolean bridge$addEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            return ((WorldBridge)this.getWorld().getHandle()).bridge$addEntity(entity, reason);
        }
        return this.func_217376_c(entity);
    }

    @Override
    public void bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            ((WorldBridge)this.getWorld().getHandle()).bridge$pushAddEntityReason(reason);
        }
    }
}

