/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.server;

import com.google.common.collect.Lists;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.inventory.IInventoryBridge;
import io.izzel.arclight.common.bridge.world.ExplosionBridge;
import io.izzel.arclight.common.bridge.world.dimension.DimensionTypeBridge;
import io.izzel.arclight.common.bridge.world.server.ServerWorldBridge;
import io.izzel.arclight.common.bridge.world.storage.MapDataBridge;
import io.izzel.arclight.common.bridge.world.storage.WorldInfoBridge;
import io.izzel.arclight.common.mixin.core.world.WorldMixin;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_15_R1.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.ChunkGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerWorld.class})
@Implements(value={@Interface(iface=ServerWorldBridge.Hack.class, prefix="hack$")})
public abstract class ServerWorldMixin
extends WorldMixin
implements ServerWorldBridge {
    @Shadow
    @Final
    private List<ServerPlayerEntity> field_217491_A;
    @Shadow
    @Final
    public Int2ObjectMap<Entity> field_217498_x;
    @Shadow
    @Final
    @Mutable
    @Nullable
    private WanderingTraderSpawner field_217496_L;
    @Shadow
    private boolean field_73068_P;
    private transient boolean arclight$force;
    private transient LightningStrikeEvent.Cause arclight$cause;
    private transient CreatureSpawnEvent.SpawnReason arclight$reason;
    private transient boolean arclight$timeSkipCancelled;

    @Shadow
    public abstract boolean func_217376_c(Entity var1);

    @Shadow
    public abstract boolean func_217470_d(Entity var1);

    @Shadow
    public abstract void func_217468_a(LightningBoltEntity var1);

    @Shadow
    public abstract <T extends IParticleData> int func_195598_a(T var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    @Shadow
    protected abstract boolean func_195601_a(ServerPlayerEntity var1, boolean var2, double var3, double var5, double var7, IPacket<?> var9);

    @Shadow
    @Nonnull
    public abstract MinecraftServer shadow$func_73046_m();

    @Shadow
    public abstract ServerChunkProvider func_72863_F();

    @Shadow
    protected abstract void func_229856_ab_();

    public void arclight$constructor(MinecraftServer serverIn, Executor executor, SaveHandler saveHandler, WorldInfo worldInfo, DimensionType dimType, IProfiler profiler, IChunkStatusListener listener) {
        throw new RuntimeException();
    }

    public void arclight$constructor(MinecraftServer serverIn, Executor executor, SaveHandler saveHandler, WorldInfo worldInfo, DimensionType dimType, IProfiler profiler, IChunkStatusListener listener, World.Environment env, ChunkGenerator gen) {
        this.arclight$constructor(serverIn, executor, saveHandler, worldInfo, dimType, profiler, listener);
        this.generator = gen;
        this.environment = env;
        this.bridge$getWorld();
    }

    public <T extends IParticleData> int sendParticles(ServerPlayerEntity sender, T t0, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6, boolean force) {
        SSpawnParticlePacket packet = new SSpawnParticlePacket(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i);
        int j = 0;
        for (ServerPlayerEntity entity : this.field_217491_A) {
            if (sender != null && !((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity().canSee(((ServerPlayerEntityBridge)sender).bridge$getBukkitEntity()) || !this.func_195601_a(entity, force, d0, d1, d2, (IPacket<?>)packet)) continue;
            ++j;
        }
        return j;
    }

    @Inject(method={"onEntityAdded"}, at={@At(value="RETURN")})
    private void arclight$validEntity(Entity entityIn, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$setValid(true);
    }

    @Inject(method={"updateEntity"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/Entity;tick()V")})
    private void arclight$tickPortal(Entity entityIn, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$postTick();
    }

    @Inject(method={"tickPassenger"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/Entity;updateRidden()V")})
    private void arclight$tickPortalPassenger(Entity ridingEntity, Entity passengerEntity, CallbackInfo ci) {
        ((EntityBridge)passengerEntity).bridge$postTick();
    }

    @Inject(method={"removeEntityComplete"}, remap=false, at={@At(value="RETURN")})
    private void arclight$invalidEntity(Entity entityIn, boolean keepData, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$setValid(false);
    }

    @Inject(method={"tickEnvironment"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;addEntity(Lnet/minecraft/entity/Entity;)Z")})
    public void arclight$thunder(Chunk chunkIn, int randomTickSpeed, CallbackInfo ci) {
        this.bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.LIGHTNING);
    }

    @Redirect(method={"tickEnvironment"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    public boolean arclight$snowForm(ServerWorld serverWorld, BlockPos pos, BlockState state) {
        return CraftEventFactory.handleBlockFormEvent((World)serverWorld, pos, state, null);
    }

    @Inject(method={"createSpawnPosition"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/biome/provider/BiomeProvider;getBiomesToSpawnIn()Ljava/util/List;")})
    public void arclight$spawnPoint(WorldSettings settings, CallbackInfo ci) {
        if (this.generator != null) {
            Random rand = new Random(this.func_72905_C());
            Location spawn = this.generator.getFixedSpawnLocation(this.bridge$getWorld(), rand);
            if (spawn != null) {
                if (spawn.getWorld() != this.bridge$getWorld()) {
                    throw new IllegalStateException("Cannot set spawn point for " + this.field_72986_A.func_76065_j() + " to be in another world (" + spawn.getWorld().getName() + ")");
                }
                this.field_72986_A.func_176143_a(new BlockPos(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()));
                ci.cancel();
            }
        }
    }

    @Inject(method={"save"}, at={@At(value="JUMP", ordinal=0, opcode=198)})
    public void arclight$worldSave(IProgressUpdate progress, boolean flush, boolean skipSave, CallbackInfo ci) {
        Bukkit.getPluginManager().callEvent(new WorldSaveEvent(this.bridge$getWorld()));
    }

    @Inject(method={"onChunkUnloading"}, at={@At(value="HEAD")})
    public void arclight$closeOnChunkUnloading(Chunk chunkIn, CallbackInfo ci) {
        for (TileEntity tileentity : chunkIn.func_177434_r().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventoryBridge)tileentity).getViewers())) {
                if (!(h2 instanceof CraftHumanEntity)) continue;
                ((CraftHumanEntity)h2).getHandle().func_71053_j();
            }
        }
    }

    @Overwrite
    @Nullable
    public MapData func_217406_a(String mapName) {
        return (MapData)this.shadow$func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215753_b(() -> {
            MapData newMap = new MapData(mapName);
            MapInitializeEvent event = new MapInitializeEvent(((MapDataBridge)newMap).bridge$getMapView());
            Bukkit.getServer().getPluginManager().callEvent(event);
            return newMap;
        }, mapName);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$init(MinecraftServer serverIn, Executor executor, SaveHandler saveHandler, WorldInfo worldInfo, DimensionType dimType, IProfiler profiler, IChunkStatusListener listener, CallbackInfo ci) {
        this.pvpMode = serverIn.func_71219_W();
        ((WorldInfoBridge)worldInfo).bridge$setWorld((World)((ServerWorld)this));
        if (this.field_217496_L == null && ((DimensionTypeBridge)this.field_73011_w.func_186058_p()).bridge$getType() == DimensionType.field_223227_a_) {
            this.field_217496_L = new WanderingTraderSpawner((ServerWorld)this);
        }
    }

    @Redirect(method={"spawnParticle(Lnet/minecraft/particles/IParticleData;DDDIDDDD)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;sendPacketWithinDistance(Lnet/minecraft/entity/player/ServerPlayerEntity;ZDDDLnet/minecraft/network/IPacket;)Z"))
    public boolean arclight$particleVisible(ServerWorld serverWorld, ServerPlayerEntity player, boolean longDistance, double posX, double posY, double posZ, IPacket<?> packet) {
        return this.func_195601_a(player, this.arclight$force, posX, posY, posZ, packet);
    }

    public <T extends IParticleData> int sendParticles(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, boolean force) {
        this.arclight$force = force;
        return this.func_195598_a(type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
    }

    @Override
    public <T extends IParticleData> int bridge$sendParticles(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, boolean force) {
        return this.sendParticles(type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed, force);
    }

    @Inject(method={"addLightningBolt"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$lightningEvent(LightningBoltEntity entityIn, CallbackInfo ci) {
        LightningStrikeEvent event = new LightningStrikeEvent(this.getWorld(), (LightningStrike)((Object)((EntityBridge)entityIn).bridge$getBukkitEntity()), this.arclight$cause);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
        this.arclight$cause = null;
    }

    @Override
    public void bridge$pushStrikeLightningCause(LightningStrikeEvent.Cause cause) {
        this.arclight$cause = cause;
    }

    public void strikeLightning(LightningBoltEntity entity, LightningStrikeEvent.Cause cause) {
        this.bridge$pushStrikeLightningCause(cause);
        this.func_217468_a(entity);
    }

    @Override
    public void bridge$strikeLightning(LightningBoltEntity entity, LightningStrikeEvent.Cause cause) {
        this.strikeLightning(entity, cause);
    }

    @Inject(method={"addEntity0"}, cancellable=true, at={@At(value="INVOKE", remap=false, target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z")})
    public void arclight$addEntityEvent(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        if (this.arclight$reason == null) {
            this.arclight$reason = CreatureSpawnEvent.SpawnReason.DEFAULT;
        }
        if (!CraftEventFactory.doEntityAddEventCalling((World)((ServerWorld)this), entityIn, this.arclight$reason)) {
            cir.setReturnValue((Object)false);
        }
        this.arclight$reason = null;
    }

    @Inject(method={"addEntity0"}, at={@At(value="RETURN")})
    public void arclight$resetReason(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$reason = null;
    }

    @Override
    public void bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason reason) {
        this.arclight$reason = reason;
    }

    public boolean addEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.bridge$pushAddEntityReason(reason);
        return this.func_217376_c(entity);
    }

    @Override
    public boolean bridge$addEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean addEntitySerialized(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.bridge$pushAddEntityReason(reason);
        return this.func_217470_d(entity);
    }

    @Override
    public boolean bridge$addEntitySerialized(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntitySerialized(entity, reason);
    }

    @Inject(method={"createExplosion"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/Explosion;doExplosionB(Z)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void arclight$doExplosion(Entity entityIn, DamageSource damageSourceIn, double xIn, double yIn, double zIn, float explosionRadius, boolean causesFire, Explosion.Mode modeIn, CallbackInfoReturnable<Explosion> cir, Explosion explosion) {
        if (((ExplosionBridge)explosion).bridge$wasCancelled()) {
            cir.setReturnValue((Object)explosion);
        }
    }

    @Override
    public TileEntity bridge$getTileEntity(BlockPos blockPos) {
        return this.func_175625_s(blockPos);
    }

    public TileEntity hack$getTileEntity(BlockPos pos) {
        return this.func_175625_s(pos);
    }

    @Override
    public TileEntity func_175625_s(BlockPos pos) {
        return this.getTileEntity(pos, true);
    }

    @Override
    public TileEntity getTileEntity(BlockPos pos, boolean validate) {
        TileEntity result = super.func_175625_s(pos);
        if (!validate || Thread.currentThread() != this.arclight$getMainThread()) {
            return result;
        }
        BlockState state = this.func_180495_p(pos);
        Block type = state.func_177230_c();
        if (result != null && type != Blocks.field_150350_a && !result.func_200662_C().func_223045_a(type)) {
            result = this.fixTileEntity(pos, state, type, result);
        }
        return result;
    }

    private TileEntity fixTileEntity(BlockPos pos, Block type, TileEntity found) {
        return this.fixTileEntity(pos, this.func_180495_p(pos), type, found);
    }

    private TileEntity fixTileEntity(BlockPos pos, BlockState state, Block type, TileEntity found) {
        ResourceLocation registryName = found.func_200662_C().getRegistryName();
        if (registryName == null || !registryName.func_110624_b().equals("minecraft")) {
            return found;
        }
        ResourceLocation blockType = type.getRegistryName();
        if (blockType == null || !blockType.func_110624_b().equals("minecraft")) {
            return found;
        }
        this.getServer().getLogger().log(Level.SEVERE, "Block at {0}, {1}, {2} is {3} but has {4}. Bukkit will attempt to fix this, but there may be additional damage that we cannot recover.", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), type, found});
        if (type.hasTileEntity(state)) {
            TileEntity replacement = type.createTileEntity(state, (IBlockReader)this);
            if (replacement == null) {
                return found;
            }
            replacement.field_145850_b = (World)this;
            this.func_175690_a(pos, replacement);
            return replacement;
        }
        return found;
    }

    @Overwrite
    public Object2IntMap<EntityClassification> func_217450_l() {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Entity entity : this.field_217498_x.values()) {
            EntityClassification classification;
            MobEntity mobEntity;
            if (entity instanceof MobEntity && (mobEntity = (MobEntity)entity).func_213397_c(0.0) && mobEntity.func_104002_bU() || (classification = entity.func_200600_R().func_220339_d()) == EntityClassification.MISC || !this.func_72863_F().func_223435_b(entity)) continue;
            map.mergeInt((Object)classification, 1, Integer::sum);
        }
        return map;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setDayTime(J)V"))
    private void arclight$timeSkip(ServerWorld world, long time) {
        TimeSkipEvent event = new TimeSkipEvent(this.bridge$getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, time - time % 24000L - this.func_72820_D());
        Bukkit.getPluginManager().callEvent(event);
        this.arclight$timeSkipCancelled = event.isCancelled();
        if (!event.isCancelled()) {
            world.func_72877_b(this.func_72820_D() + event.getSkipAmount());
            this.field_73068_P = this.field_217491_A.stream().allMatch(LivingEntity::func_70608_bn);
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;wakeUpAllPlayers()V"))
    private void arclight$notWakeIfCancelled(ServerWorld world) {
        if (!this.arclight$timeSkipCancelled) {
            this.func_229856_ab_();
        }
        this.arclight$timeSkipCancelled = false;
    }
}

