/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.storage;

import io.izzel.arclight.common.bridge.world.dimension.DimensionTypeBridge;
import io.izzel.arclight.common.bridge.world.storage.MapDataBridge;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.OverworldDimension;
import net.minecraft.world.storage.MapData;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.map.CraftMapView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapData.class})
public abstract class MapDataMixin
implements MapDataBridge {
    @Shadow
    public DimensionType field_76200_c;
    public CraftMapView mapView;
    private CraftServer server;
    private UUID uniqueId;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$init(String mapname, CallbackInfo ci) {
        this.mapView = new CraftMapView((MapData)this);
        this.server = (CraftServer)Bukkit.getServer();
    }

    @Redirect(method={"read"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/dimension/DimensionType;getById(I)Lnet/minecraft/world/dimension/DimensionType;"))
    public DimensionType arclight$customDimension(int id, CompoundNBT nbt) {
        DimensionType type;
        long least = nbt.func_74763_f("UUIDLeast");
        long most = nbt.func_74763_f("UUIDMost");
        if (least != 0L && most != 0L) {
            this.uniqueId = new UUID(most, least);
            CraftWorld world = (CraftWorld)this.server.getWorld(this.uniqueId);
            if (world == null) {
                type = DimensionType.func_186069_a((int)id);
                if (type == null) {
                    type = new DimensionType(-1564403385, "", "", OverworldDimension::new, false, null, null, null);
                    ((DimensionTypeBridge)type).bridge$setType(DimensionType.field_223227_a_);
                }
            } else {
                type = world.getHandle().field_73011_w.func_186058_p();
            }
        } else {
            type = DimensionType.func_186069_a((int)id);
        }
        return type;
    }

    @Inject(method={"write"}, at={@At(value="HEAD")})
    public void arclight$storeDimension(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> cir) {
        if (this.field_76200_c.func_186068_a() >= 10) {
            if (this.uniqueId == null) {
                for (World world : this.server.getWorlds()) {
                    CraftWorld cWorld = (CraftWorld)world;
                    if (cWorld.getHandle().field_73011_w.func_186058_p() != this.field_76200_c) continue;
                    this.uniqueId = cWorld.getUID();
                    break;
                }
            }
            if (this.uniqueId != null) {
                compound.func_74772_a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
                compound.func_74772_a("UUIDMost", this.uniqueId.getMostSignificantBits());
            }
        }
    }

    @Override
    public CraftMapView bridge$getMapView() {
        return this.mapView;
    }
}

