/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server;

import com.mojang.authlib.GameProfile;
import io.izzel.arclight.common.bridge.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.context.IContext;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.permissions.DefaultPermissions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArclightPermissionHandler
implements IPermissionHandler {
    public static final ArclightPermissionHandler INSTANCE = new ArclightPermissionHandler();
    private final List<Perm> list = new LinkedList<Perm>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void initialize() {
        if (!this.initialized.getAndSet(true)) {
            for (Perm permission : this.list) {
                DefaultPermissions.registerPermission(permission.toBukkit());
            }
            this.list.clear();
        }
    }

    public void registerNode(@NotNull String node, @NotNull DefaultPermissionLevel level, @NotNull String desc) {
        PermissionDefault bukkit = level == DefaultPermissionLevel.ALL ? PermissionDefault.TRUE : (level == DefaultPermissionLevel.OP ? PermissionDefault.OP : PermissionDefault.FALSE);
        if (this.initialized.get()) {
            DefaultPermissions.registerPermission(node, desc, bukkit);
        } else {
            this.list.add(new Perm(node, desc, bukkit));
        }
    }

    @NotNull
    public Collection<String> getRegisteredNodes() {
        if (this.initialized.get()) {
            return Bukkit.getPluginManager().getPermissions().stream().map(Permission::getName).collect(Collectors.toList());
        }
        return this.list.stream().map(it -> ((Perm)it).node).collect(Collectors.toList());
    }

    public boolean hasPermission(@NotNull GameProfile profile, @NotNull String node, @Nullable IContext context) {
        Object player;
        if (context != null && (player = context.getPlayer()) != null) {
            return ((PlayerEntityBridge)player).bridge$getBukkitEntity().hasPermission(node);
        }
        player = Bukkit.getPlayer(profile.getId());
        if (player != null) {
            return player.hasPermission(node);
        }
        Permission perm = Bukkit.getServer().getPluginManager().getPermission(node);
        boolean isOp = ArclightServer.getMinecraftServer().func_184103_al().func_152596_g(profile);
        if (perm != null) {
            return perm.getDefault().getValue(isOp);
        }
        return Permission.DEFAULT_PERMISSION.getValue(isOp);
    }

    @NotNull
    public String getNodeDescription(@NotNull String node) {
        if (!this.initialized.get()) {
            return "";
        }
        Permission permission = Bukkit.getPluginManager().getPermission(node);
        return permission == null ? "" : permission.getDescription();
    }

    private static class Perm {
        private final String node;
        private final String desc;
        private final PermissionDefault level;

        public Perm(String node, String desc, PermissionDefault level) {
            this.node = node;
            this.desc = desc;
            this.level = level;
        }

        public Permission toBukkit() {
            return new Permission(this.node, this.desc, this.level);
        }
    }
}

