/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.util.log;

import java.util.Enumeration;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class ArclightLazyLogManager
extends LogManager {
    private volatile LogManager delegate;

    @Override
    public boolean addLogger(Logger logger) {
        this.tryGet();
        if (this.delegate != null) {
            return this.delegate.addLogger(logger);
        }
        return super.addLogger(logger);
    }

    @Override
    public Logger getLogger(String name) {
        this.tryGet();
        if (this.delegate != null) {
            return this.delegate.getLogger(name);
        }
        return super.getLogger(name);
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        this.tryGet();
        if (this.delegate != null) {
            return this.delegate.getLoggerNames();
        }
        return super.getLoggerNames();
    }

    private void tryGet() {
        if (this.delegate != null) {
            return;
        }
        try {
            Class<?> name = Class.forName("org.apache.logging.log4j.jul.LogManager");
            this.delegate = (LogManager)name.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

