/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameters;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final net.minecraft.world.storage.loot.LootTable handle;
    private final NamespacedKey key;

    public CraftLootTable(NamespacedKey key, net.minecraft.world.storage.loot.LootTable handle) {
        this.handle = handle;
        this.key = key;
    }

    public net.minecraft.world.storage.loot.LootTable getHandle() {
        return this.handle;
    }

    @Override
    public Collection<ItemStack> populateLoot(Random random, org.bukkit.loot.LootContext context) {
        LootContext nmsContext = this.convertContext(context);
        List nmsItems = this.handle.func_216113_a(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (net.minecraft.item.ItemStack item : nmsItems) {
            if (item.func_190926_b()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    @Override
    public void fillInventory(Inventory inventory, Random random, org.bukkit.loot.LootContext context) {
        LootContext nmsContext = this.convertContext(context);
        CraftInventory craftInventory = (CraftInventory)inventory;
        IInventory handle = craftInventory.getInventory();
        this.getHandle().func_216118_a(handle, nmsContext);
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    private LootContext convertContext(org.bukkit.loot.LootContext context) {
        Location loc = context.getLocation();
        ServerWorld handle = ((CraftWorld)loc.getWorld()).getHandle();
        LootContext.Builder builder = new LootContext.Builder(handle);
        if (this.getHandle() != net.minecraft.world.storage.loot.LootTable.field_186464_a) {
            if (context.getLootedEntity() != null) {
                Entity nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                builder.func_216015_a(LootParameters.field_216281_a, (Object)nmsLootedEntity);
                builder.func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76377_j);
                builder.func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos(nmsLootedEntity));
            }
            if (context.getKiller() != null) {
                PlayerEntity nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                builder.func_216015_a(LootParameters.field_216284_d, (Object)nmsKiller);
                builder.func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.func_76365_a((PlayerEntity)nmsKiller));
                builder.func_216015_a(LootParameters.field_216282_b, (Object)nmsKiller);
            }
            if (context.getLootingModifier() != -1) {
                builder.func_216015_a(LootParameters.LOOTING_MOD, (Object)context.getLootingModifier());
            }
        }
        LootParameterSet.Builder nmsBuilder = new LootParameterSet.Builder();
        for (LootParameter param : this.getHandle().func_216122_a().func_216277_a()) {
            nmsBuilder.func_216269_a(param);
        }
        for (LootParameter param : this.getHandle().func_216122_a().func_216276_b()) {
            if (this.getHandle().func_216122_a().func_216277_a().contains(param)) continue;
            nmsBuilder.func_216271_b(param);
        }
        nmsBuilder.func_216271_b(LootParameters.LOOTING_MOD);
        return builder.func_216022_a(nmsBuilder.func_216270_a());
    }

    public static org.bukkit.loot.LootContext convertContext(LootContext info) {
        CraftEntity killer;
        BlockPos position = (BlockPos)info.func_216031_c(LootParameters.field_216286_f);
        Location location = new Location(info.func_202879_g().getWorld(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.func_216033_a(LootParameters.field_216284_d) && (killer = ((Entity)info.func_216031_c(LootParameters.field_216284_d)).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((CraftHumanEntity)killer);
        }
        if (info.func_216033_a(LootParameters.field_216281_a)) {
            contextBuilder.lootedEntity(((Entity)info.func_216031_c(LootParameters.field_216281_a)).getBukkitEntity());
        }
        if (info.func_216033_a(LootParameters.LOOTING_MOD)) {
            contextBuilder.lootingModifier((Integer)info.func_216031_c(LootParameters.LOOTING_MOD));
        }
        contextBuilder.luck(info.func_186491_f());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals(this.getKey());
    }
}

