/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_15_R1.CraftProfileBanEntry;

public class CraftProfileBanList
implements BanList {
    private final net.minecraft.server.management.BanList list;

    public CraftProfileBanList(net.minecraft.server.management.BanList list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        ProfileBanEntry entry = (ProfileBanEntry)this.list.func_152683_b((Object)profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        ProfileBanEntry entry = new ProfileBanEntry(profile, new Date(), StringUtils.isBlank((String)source) ? null : source, expires, StringUtils.isBlank((String)reason) ? null : reason);
        this.list.func_152687_a((UserListEntry)entry);
        try {
            this.list.func_152678_f();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-players.json, {0}", ex.getMessage());
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (UserListEntry entry : this.list.getValues()) {
            GameProfile profile = (GameProfile)entry.func_152640_f();
            builder.add(new CraftProfileBanEntry(profile, (ProfileBanEntry)entry, this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return false;
        }
        return this.list.func_152702_a(profile);
    }

    @Override
    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        this.list.func_152684_c((Object)profile);
    }

    private GameProfile getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuid != null ? MinecraftServer.getServer().func_152358_ax().func_152652_a(uuid) : MinecraftServer.getServer().func_152358_ax().func_152655_a(target);
    }
}

