/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.attribute;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;

public class CraftAttributeInstance
implements AttributeInstance {
    private final IAttributeInstance handle;
    private final Attribute attribute;

    public CraftAttributeInstance(IAttributeInstance handle, Attribute attribute) {
        this.handle = handle;
        this.attribute = attribute;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public double getBaseValue() {
        return this.handle.func_111125_b();
    }

    @Override
    public void setBaseValue(double d) {
        this.handle.func_111128_a(d);
    }

    @Override
    public Collection<AttributeModifier> getModifiers() {
        ArrayList<AttributeModifier> result = new ArrayList<AttributeModifier>();
        for (net.minecraft.entity.ai.attributes.AttributeModifier nms : this.handle.func_225505_c_()) {
            result.add(CraftAttributeInstance.convert(nms));
        }
        return result;
    }

    @Override
    public void addModifier(AttributeModifier modifier) {
        Preconditions.checkArgument(modifier != null, "modifier");
        this.handle.func_111121_a(CraftAttributeInstance.convert(modifier));
    }

    @Override
    public void removeModifier(AttributeModifier modifier) {
        Preconditions.checkArgument(modifier != null, "modifier");
        this.handle.func_111124_b(CraftAttributeInstance.convert(modifier));
    }

    @Override
    public double getValue() {
        return this.handle.func_111126_e();
    }

    @Override
    public double getDefaultValue() {
        return this.handle.func_111123_a().func_111110_b();
    }

    public static net.minecraft.entity.ai.attributes.AttributeModifier convert(AttributeModifier bukkit) {
        return new net.minecraft.entity.ai.attributes.AttributeModifier(bukkit.getUniqueId(), bukkit.getName(), bukkit.getAmount(), AttributeModifier.Operation.values()[bukkit.getOperation().ordinal()]);
    }

    public static AttributeModifier convert(net.minecraft.entity.ai.attributes.AttributeModifier nms) {
        return new AttributeModifier(nms.func_111167_a(), nms.func_111166_b(), nms.func_111164_d(), AttributeModifier.Operation.values()[nms.func_220375_c().ordinal()]);
    }
}

