/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.attribute;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import org.apache.commons.lang3.EnumUtils;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_15_R1.attribute.CraftAttributeInstance;

public class CraftAttributeMap
implements Attributable {
    private final AbstractAttributeMap handle;

    public CraftAttributeMap(AbstractAttributeMap handle) {
        this.handle = handle;
    }

    @Override
    public AttributeInstance getAttribute(Attribute attribute) {
        Preconditions.checkArgument(attribute != null, "attribute");
        IAttributeInstance nms = this.handle.func_111152_a(CraftAttributeMap.toMinecraft(attribute.name()));
        return nms == null ? null : new CraftAttributeInstance(nms, attribute);
    }

    public static String toMinecraft(String bukkit) {
        int first = bukkit.indexOf(95);
        int second = bukkit.indexOf(95, first + 1);
        StringBuilder sb = new StringBuilder(bukkit.toLowerCase(Locale.ENGLISH));
        sb.setCharAt(first, '.');
        if (second != -1) {
            sb.deleteCharAt(second);
            sb.setCharAt(second, bukkit.charAt(second + 1));
        }
        return sb.toString();
    }

    public static String toMinecraft(Attribute attribute) {
        return CraftAttributeMap.toMinecraft(attribute.name());
    }

    public static Attribute fromMinecraft(String nms) {
        String[] split = nms.split("\\.", 2);
        String generic = split[0];
        String descriptor = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, split[1]);
        String fin = String.valueOf(generic) + "_" + descriptor;
        return (Attribute)EnumUtils.getEnum(Attribute.class, (String)fin.toUpperCase(Locale.ROOT));
    }
}

