/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.ResourceLocation;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlockEntityState;

public class CraftCreatureSpawner
extends CraftBlockEntityState<MobSpawnerTileEntity>
implements CreatureSpawner {
    public CraftCreatureSpawner(Block block) {
        super(block, MobSpawnerTileEntity.class);
    }

    public CraftCreatureSpawner(Material material, MobSpawnerTileEntity te) {
        super(material, te);
    }

    @Override
    public org.bukkit.entity.EntityType getSpawnedType() {
        ResourceLocation key = ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().func_190895_g();
        return key == null ? org.bukkit.entity.EntityType.PIG : org.bukkit.entity.EntityType.fromName(key.func_110623_a());
    }

    @Override
    public void setSpawnedType(org.bukkit.entity.EntityType entityType) {
        if (entityType == null || entityType.getName() == null) {
            throw new IllegalArgumentException("Can't spawn EntityType " + entityType + " from mobspawners!");
        }
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().func_200876_a((EntityType)EntityType.func_220327_a((String)entityType.getName()).get());
    }

    @Override
    public String getCreatureTypeName() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().func_190895_g().func_110623_a();
    }

    @Override
    public void setCreatureTypeByName(String creatureType) {
        org.bukkit.entity.EntityType type = org.bukkit.entity.EntityType.fromName(creatureType);
        if (type == null) {
            return;
        }
        this.setSpawnedType(type);
    }

    @Override
    public int getDelay() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98286_b;
    }

    @Override
    public void setDelay(int delay) {
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98286_b = delay;
    }

    @Override
    public int getMinSpawnDelay() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98283_g;
    }

    @Override
    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument(spawnDelay <= this.getMaxSpawnDelay(), "Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98283_g = spawnDelay;
    }

    @Override
    public int getMaxSpawnDelay() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98293_h;
    }

    @Override
    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument(spawnDelay > 0, "Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument(spawnDelay >= this.getMinSpawnDelay(), "Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98293_h = spawnDelay;
    }

    @Override
    public int getMaxNearbyEntities() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98292_k;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98292_k = maxNearbyEntities;
    }

    @Override
    public int getSpawnCount() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98294_i;
    }

    @Override
    public void setSpawnCount(int count) {
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98294_i = count;
    }

    @Override
    public int getRequiredPlayerRange() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98289_l;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98289_l = requiredPlayerRange;
    }

    @Override
    public int getSpawnRange() {
        return ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98290_m;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        ((MobSpawnerTileEntity)this.getSnapshot()).func_145881_a().field_98290_m = spawnRange;
    }
}

