/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.block;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;

public class CraftJukebox
extends CraftBlockEntityState<JukeboxTileEntity>
implements Jukebox {
    public CraftJukebox(Block block) {
        super(block, JukeboxTileEntity.class);
    }

    public CraftJukebox(Material material, JukeboxTileEntity te) {
        super(material, te);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            CraftWorld world = (CraftWorld)this.getWorld();
            Material record = this.getPlaying();
            if (record == Material.AIR) {
                world.getHandle().func_180501_a(this.getPosition(), (BlockState)Blocks.field_150421_aI.func_176223_P().func_206870_a((IProperty)JukeboxBlock.field_176432_a, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                world.getHandle().func_180501_a(this.getPosition(), (BlockState)Blocks.field_150421_aI.func_176223_P().func_206870_a((IProperty)JukeboxBlock.field_176432_a, (Comparable)Boolean.valueOf(true)), 3);
            }
            world.playEffect(this.getLocation(), Effect.RECORD_PLAY, record);
        }
        return result;
    }

    @Override
    public Material getPlaying() {
        return this.getRecord().getType();
    }

    @Override
    public void setPlaying(Material record) {
        if (record == null || CraftMagicNumbers.getItem(record) == null) {
            record = Material.AIR;
        }
        this.setRecord(new ItemStack(record));
    }

    @Override
    public ItemStack getRecord() {
        net.minecraft.item.ItemStack record = ((JukeboxTileEntity)this.getSnapshot()).func_195537_c();
        return CraftItemStack.asBukkitCopy(record);
    }

    @Override
    public void setRecord(ItemStack record) {
        net.minecraft.item.ItemStack nms = CraftItemStack.asNMSCopy(record);
        ((JukeboxTileEntity)this.getSnapshot()).func_195535_a(nms);
        this.data = nms.func_190926_b() ? (BlockState)this.data.func_206870_a((IProperty)JukeboxBlock.field_176432_a, (Comparable)Boolean.valueOf(false)) : (BlockState)this.data.func_206870_a((IProperty)JukeboxBlock.field_176432_a, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public boolean isPlaying() {
        return (Boolean)this.getHandle().func_177229_b((IProperty)JukeboxBlock.field_176432_a);
    }

    @Override
    public boolean eject() {
        this.requirePlaced();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof JukeboxTileEntity)) {
            return false;
        }
        JukeboxTileEntity jukebox = (JukeboxTileEntity)tileEntity;
        boolean result = !jukebox.func_195537_c().func_190926_b();
        CraftWorld world = (CraftWorld)this.getWorld();
        ((JukeboxBlock)Blocks.field_150421_aI).func_203419_a((World)world.getHandle(), this.getPosition());
        return result;
    }
}

