/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.block;

import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;

public class CraftSign
extends CraftBlockEntityState<SignTileEntity>
implements Sign {
    private String[] lines;
    private boolean editable;

    public CraftSign(Block block) {
        super(block, SignTileEntity.class);
    }

    public CraftSign(Material material, SignTileEntity te) {
        super(material, te);
    }

    @Override
    public void load(SignTileEntity sign) {
        super.load(sign);
        this.lines = new String[sign.field_145915_a.length];
        System.arraycopy(CraftSign.revertComponents(sign.field_145915_a), 0, this.lines, 0, this.lines.length);
        this.editable = sign.field_145916_j;
    }

    @Override
    public String[] getLines() {
        return this.lines;
    }

    @Override
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    @Override
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.lines[index] = line;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)((SignTileEntity)this.getSnapshot()).func_214066_f().func_196059_a());
    }

    @Override
    public void setColor(DyeColor color) {
        ((SignTileEntity)this.getSnapshot()).func_214068_a(net.minecraft.item.DyeColor.func_196056_a((int)color.getWoolData()));
    }

    @Override
    public void applyTo(SignTileEntity sign) {
        super.applyTo(sign);
        ITextComponent[] newLines = CraftSign.sanitizeLines(this.lines);
        System.arraycopy(newLines, 0, sign.field_145915_a, 0, 4);
        sign.field_145916_j = this.editable;
    }

    public static ITextComponent[] sanitizeLines(String[] lines) {
        ITextComponent[] components = new ITextComponent[4];
        int i = 0;
        while (i < 4) {
            components[i] = i < lines.length && lines[i] != null ? CraftChatMessage.fromString(lines[i])[0] : new StringTextComponent("");
            ++i;
        }
        return components;
    }

    public static String[] revertComponents(ITextComponent[] components) {
        String[] lines = new String[components.length];
        int i = 0;
        while (i < lines.length) {
            lines[i] = CraftSign.revertComponent(components[i]);
            ++i;
        }
        return lines;
    }

    private static String revertComponent(ITextComponent component) {
        return CraftChatMessage.fromComponent(component);
    }
}

