/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class CraftBossBar
implements BossBar {
    private final ServerBossInfo handle;
    private Map<BarFlag, FlagContainer> flags;

    public CraftBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.handle = new ServerBossInfo(CraftChatMessage.fromString(title, true)[0], this.convertColor(color), this.convertStyle(style));
        this.initialize();
        BarFlag[] barFlagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            BarFlag flag = barFlagArray[n2];
            this.addFlag(flag);
            ++n2;
        }
        this.setColor(color);
        this.setStyle(style);
    }

    public CraftBossBar(ServerBossInfo bossBattleServer) {
        this.handle = bossBattleServer;
        this.initialize();
    }

    private void initialize() {
        this.flags = new HashMap<BarFlag, FlagContainer>();
        this.flags.put(BarFlag.DARKEN_SKY, new FlagContainer(() -> ((ServerBossInfo)this.handle).func_186734_i(), arg_0 -> ((ServerBossInfo)this.handle).func_186741_a(arg_0)));
        this.flags.put(BarFlag.PLAY_BOSS_MUSIC, new FlagContainer(() -> ((ServerBossInfo)this.handle).func_186747_j(), arg_0 -> ((ServerBossInfo)this.handle).func_186742_b(arg_0)));
        this.flags.put(BarFlag.CREATE_FOG, new FlagContainer(() -> ((ServerBossInfo)this.handle).func_186748_k(), arg_0 -> ((ServerBossInfo)this.handle).func_186743_c(arg_0)));
    }

    private BarColor convertColor(BossInfo.Color color) {
        BarColor bukkitColor = BarColor.valueOf(color.name());
        return bukkitColor == null ? BarColor.WHITE : bukkitColor;
    }

    private BossInfo.Color convertColor(BarColor color) {
        BossInfo.Color nmsColor = BossInfo.Color.valueOf((String)color.name());
        return nmsColor == null ? BossInfo.Color.WHITE : nmsColor;
    }

    private BossInfo.Overlay convertStyle(BarStyle style) {
        switch (style) {
            default: {
                return BossInfo.Overlay.PROGRESS;
            }
            case SEGMENTED_6: {
                return BossInfo.Overlay.NOTCHED_6;
            }
            case SEGMENTED_10: {
                return BossInfo.Overlay.NOTCHED_10;
            }
            case SEGMENTED_12: {
                return BossInfo.Overlay.NOTCHED_12;
            }
            case SEGMENTED_20: 
        }
        return BossInfo.Overlay.NOTCHED_20;
    }

    private BarStyle convertStyle(BossInfo.Overlay style) {
        switch (style) {
            default: {
                return BarStyle.SOLID;
            }
            case NOTCHED_6: {
                return BarStyle.SEGMENTED_6;
            }
            case NOTCHED_10: {
                return BarStyle.SEGMENTED_10;
            }
            case NOTCHED_12: {
                return BarStyle.SEGMENTED_12;
            }
            case NOTCHED_20: 
        }
        return BarStyle.SEGMENTED_20;
    }

    @Override
    public String getTitle() {
        return CraftChatMessage.fromComponent(this.handle.field_186749_a);
    }

    @Override
    public void setTitle(String title) {
        this.handle.field_186749_a = CraftChatMessage.fromString(title, true)[0];
        this.handle.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_NAME);
    }

    @Override
    public BarColor getColor() {
        return this.convertColor(this.handle.field_186751_c);
    }

    @Override
    public void setColor(BarColor color) {
        this.handle.field_186751_c = this.convertColor(color);
        this.handle.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    @Override
    public BarStyle getStyle() {
        return this.convertStyle(this.handle.field_186752_d);
    }

    @Override
    public void setStyle(BarStyle style) {
        this.handle.field_186752_d = this.convertStyle(style);
        this.handle.func_186759_a(SUpdateBossInfoPacket.Operation.UPDATE_STYLE);
    }

    @Override
    public void addFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get((Object)flag);
        if (flagContainer != null) {
            flagContainer.set.accept(true);
        }
    }

    @Override
    public void removeFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get((Object)flag);
        if (flagContainer != null) {
            flagContainer.set.accept(false);
        }
    }

    @Override
    public boolean hasFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get((Object)flag);
        if (flagContainer != null) {
            return (Boolean)flagContainer.get.get();
        }
        return false;
    }

    @Override
    public void setProgress(double progress) {
        Preconditions.checkArgument(progress >= 0.0 && progress <= 1.0, "Progress must be between 0.0 and 1.0 (%s)", (Object)progress);
        this.handle.func_186735_a((float)progress);
    }

    @Override
    public double getProgress() {
        return this.handle.func_186738_f();
    }

    @Override
    public void addPlayer(Player player) {
        Preconditions.checkArgument(player != null, "player == null");
        Preconditions.checkArgument(((CraftPlayer)player).getHandle().field_71135_a != null, "player is not fully connected (wait for PlayerJoinEvent)");
        this.handle.func_186760_a(((CraftPlayer)player).getHandle());
    }

    @Override
    public void removePlayer(Player player) {
        Preconditions.checkArgument(player != null, "player == null");
        this.handle.func_186761_b(((CraftPlayer)player).getHandle());
    }

    @Override
    public List<Player> getPlayers() {
        ImmutableList.Builder players = ImmutableList.builder();
        for (ServerPlayerEntity p : this.handle.func_186757_c()) {
            players.add(p.getBukkitEntity());
        }
        return players.build();
    }

    @Override
    public void setVisible(boolean visible) {
        this.handle.func_186758_d(visible);
    }

    @Override
    public boolean isVisible() {
        return this.handle.field_186764_j;
    }

    @Override
    public void show() {
        this.handle.func_186758_d(true);
    }

    @Override
    public void hide() {
        this.handle.func_186758_d(false);
    }

    @Override
    public void removeAll() {
        for (Player player : this.getPlayers()) {
            this.removePlayer(player);
        }
    }

    public ServerBossInfo getHandle() {
        return this.handle;
    }

    private final class FlagContainer {
        private Supplier<Boolean> get;
        private Consumer<Boolean> set;

        private FlagContainer(Supplier<Boolean> get, Consumer<Boolean> set) {
            this.get = get;
            this.set = set;
        }
    }
}

