/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import java.util.UUID;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.inventory.IInventory;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryAbstractHorse;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;

public abstract class CraftAbstractHorse
extends CraftAnimals
implements AbstractHorse {
    public CraftAbstractHorse(CraftServer server, AbstractHorseEntity entity) {
        super(server, (AnimalEntity)entity);
    }

    public AbstractHorseEntity getHandle() {
        return (AbstractHorseEntity)this.entity;
    }

    @Override
    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getDomestication() {
        return this.getHandle().func_110252_cg();
    }

    @Override
    public void setDomestication(int value) {
        Validate.isTrue((value >= 0 ? 1 : 0) != 0, (String)"Domestication cannot be less than zero");
        Validate.isTrue((value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication cannot be greater than the max domestication");
        this.getHandle().func_110238_s(value);
    }

    @Override
    public int getMaxDomestication() {
        return this.getHandle().func_190676_dC();
    }

    @Override
    public void setMaxDomestication(int value) {
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"Max domestication cannot be zero or less");
        this.getHandle().maxDomestication = value;
    }

    @Override
    public double getJumpStrength() {
        return this.getHandle().func_110215_cj();
    }

    @Override
    public void setJumpStrength(double strength) {
        Validate.isTrue((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength cannot be less than zero");
        this.getHandle().func_110148_a(HorseEntity.field_110271_bv).func_111128_a(strength);
    }

    @Override
    public boolean isTamed() {
        return this.getHandle().func_110248_bS();
    }

    @Override
    public void setTamed(boolean tamed) {
        this.getHandle().func_110234_j(tamed);
    }

    @Override
    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    @Override
    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().setGoalTarget(null, null, false);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUUID() {
        return this.getHandle().func_184780_dh();
    }

    public void setOwnerUUID(UUID uuid) {
        this.getHandle().func_184779_b(uuid);
    }

    @Override
    public AbstractHorseInventory getInventory() {
        return new CraftInventoryAbstractHorse((IInventory)this.getHandle().field_110296_bG);
    }
}

