/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftComplexLivingEntity;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;

public class CraftEnderDragon
extends CraftComplexLivingEntity
implements EnderDragon {
    public CraftEnderDragon(CraftServer server, EnderDragonEntity entity) {
        super(server, (LivingEntity)entity);
    }

    @Override
    public Set<ComplexEntityPart> getParts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        EnderDragonPartEntity[] enderDragonPartEntityArray = this.getHandle().field_70977_g;
        int n = this.getHandle().field_70977_g.length;
        int n2 = 0;
        while (n2 < n) {
            EnderDragonPartEntity part = enderDragonPartEntityArray[n2];
            builder.add((ComplexEntityPart)((Object)part.getBukkitEntity()));
            ++n2;
        }
        return builder.build();
    }

    public EnderDragonEntity getHandle() {
        return (EnderDragonEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderDragon";
    }

    @Override
    public EntityType getType() {
        return EntityType.ENDER_DRAGON;
    }

    @Override
    public EnderDragon.Phase getPhase() {
        return EnderDragon.Phase.values()[(Integer)this.getHandle().func_184212_Q().func_187225_a(EnderDragonEntity.field_184674_a)];
    }

    @Override
    public void setPhase(EnderDragon.Phase phase) {
        this.getHandle().func_184670_cT().func_188758_a(CraftEnderDragon.getMinecraftPhase(phase));
    }

    public static EnderDragon.Phase getBukkitPhase(PhaseType phase) {
        return EnderDragon.Phase.values()[phase.func_188740_b()];
    }

    public static PhaseType getMinecraftPhase(EnderDragon.Phase phase) {
        return PhaseType.func_188738_a((int)phase.ordinal());
    }

    @Override
    public BossBar getBossBar() {
        return this.getDragonBattle().getBossBar();
    }

    @Override
    public DragonBattle getDragonBattle() {
        return new CraftDragonBattle(this.getHandle().func_184664_cU());
    }

    @Override
    public int getDeathAnimationTicks() {
        return this.getHandle().field_70995_bG;
    }
}

