/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EyeOfEnderEntity;
import net.minecraft.util.math.BlockPos;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.EntityType;

public class CraftEnderSignal
extends CraftEntity
implements EnderSignal {
    public CraftEnderSignal(CraftServer server, EyeOfEnderEntity entity) {
        super(server, (Entity)entity);
    }

    public EyeOfEnderEntity getHandle() {
        return (EyeOfEnderEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderSignal";
    }

    @Override
    public EntityType getType() {
        return EntityType.ENDER_SIGNAL;
    }

    @Override
    public Location getTargetLocation() {
        return new Location(this.getWorld(), this.getHandle().field_70224_b, this.getHandle().field_70225_c, this.getHandle().field_70222_d, this.getHandle().field_70177_z, this.getHandle().field_70125_A);
    }

    @Override
    public void setTargetLocation(Location location) {
        Preconditions.checkArgument(this.getWorld().equals(location.getWorld()), "Cannot target EnderSignal across worlds");
        this.getHandle().func_180465_a(new BlockPos(location.getX(), location.getY(), location.getZ()));
    }

    @Override
    public boolean getDropItem() {
        return this.getHandle().field_70221_f;
    }

    @Override
    public void setDropItem(boolean shouldDropItem) {
        this.getHandle().field_70221_f = shouldDropItem;
    }

    @Override
    public int getDespawnTimer() {
        return this.getHandle().field_70223_e;
    }

    @Override
    public void setDespawnTimer(int time) {
        this.getHandle().field_70223_e = time;
    }
}

