/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_15_R1.CraftServer;
import org.bukkit.craftbukkit.v1_15_R1.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftLivingEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class CraftFireball
extends AbstractProjectile
implements Fireball {
    public CraftFireball(CraftServer server, DamagingProjectileEntity entity) {
        super(server, (Entity)entity);
    }

    @Override
    public float getYield() {
        return this.getHandle().bukkitYield;
    }

    @Override
    public boolean isIncendiary() {
        return this.getHandle().isIncendiary;
    }

    @Override
    public void setIsIncendiary(boolean isIncendiary) {
        this.getHandle().isIncendiary = isIncendiary;
    }

    @Override
    public void setYield(float yield) {
        this.getHandle().bukkitYield = yield;
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        this.getHandle().field_70235_a = shooter instanceof CraftLivingEntity ? ((CraftLivingEntity)shooter).getHandle() : null;
        this.getHandle().projectileSource = shooter;
    }

    @Override
    public Vector getDirection() {
        return new Vector(this.getHandle().field_70232_b, this.getHandle().field_70233_c, this.getHandle().field_70230_d);
    }

    @Override
    public void setDirection(Vector direction) {
        Validate.notNull((Object)direction, (String)"Direction can not be null");
        double x = direction.getX();
        double y = direction.getY();
        double z = direction.getZ();
        double magnitude = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        this.getHandle().field_70232_b = x / magnitude * 0.1;
        this.getHandle().field_70233_c = y / magnitude * 0.1;
        this.getHandle().field_70230_d = z / magnitude * 0.1;
    }

    public DamagingProjectileEntity getHandle() {
        return (DamagingProjectileEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFireball";
    }

    @Override
    public EntityType getType() {
        return EntityType.UNKNOWN;
    }
}

