/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import org.bukkit.craftbukkit.v1_15_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEntityEquipment
implements EntityEquipment {
    private final CraftLivingEntity entity;

    public CraftEntityEquipment(CraftLivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public void setItem(EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument(slot != null, "slot must not be null");
        EquipmentSlotType nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item);
    }

    @Override
    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument(slot != null, "slot must not be null");
        EquipmentSlotType nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    @Override
    public ItemStack getItemInMainHand() {
        return this.getEquipment(EquipmentSlotType.MAINHAND);
    }

    @Override
    public void setItemInMainHand(ItemStack item) {
        this.setEquipment(EquipmentSlotType.MAINHAND, item);
    }

    @Override
    public ItemStack getItemInOffHand() {
        return this.getEquipment(EquipmentSlotType.OFFHAND);
    }

    @Override
    public void setItemInOffHand(ItemStack item) {
        this.setEquipment(EquipmentSlotType.OFFHAND, item);
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Override
    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @Override
    public ItemStack getHelmet() {
        return this.getEquipment(EquipmentSlotType.HEAD);
    }

    @Override
    public void setHelmet(ItemStack helmet) {
        this.setEquipment(EquipmentSlotType.HEAD, helmet);
    }

    @Override
    public ItemStack getChestplate() {
        return this.getEquipment(EquipmentSlotType.CHEST);
    }

    @Override
    public void setChestplate(ItemStack chestplate) {
        this.setEquipment(EquipmentSlotType.CHEST, chestplate);
    }

    @Override
    public ItemStack getLeggings() {
        return this.getEquipment(EquipmentSlotType.LEGS);
    }

    @Override
    public void setLeggings(ItemStack leggings) {
        this.setEquipment(EquipmentSlotType.LEGS, leggings);
    }

    @Override
    public ItemStack getBoots() {
        return this.getEquipment(EquipmentSlotType.FEET);
    }

    @Override
    public void setBoots(ItemStack boots) {
        this.setEquipment(EquipmentSlotType.FEET, boots);
    }

    @Override
    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(EquipmentSlotType.FEET), this.getEquipment(EquipmentSlotType.LEGS), this.getEquipment(EquipmentSlotType.CHEST), this.getEquipment(EquipmentSlotType.HEAD)};
        return armor;
    }

    @Override
    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(EquipmentSlotType.FEET, items.length >= 1 ? items[0] : null);
        this.setEquipment(EquipmentSlotType.LEGS, items.length >= 2 ? items[1] : null);
        this.setEquipment(EquipmentSlotType.CHEST, items.length >= 3 ? items[2] : null);
        this.setEquipment(EquipmentSlotType.HEAD, items.length >= 4 ? items[3] : null);
    }

    private ItemStack getEquipment(EquipmentSlotType slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().func_184582_a(slot));
    }

    private void setEquipment(EquipmentSlotType slot, ItemStack stack) {
        this.entity.getHandle().func_184201_a(slot, CraftItemStack.asNMSCopy(stack));
    }

    @Override
    public void clear() {
        EquipmentSlotType[] equipmentSlotTypeArray = EquipmentSlotType.values();
        int n = equipmentSlotTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EquipmentSlotType slot = equipmentSlotTypeArray[n2];
            this.setEquipment(slot, null);
            ++n2;
        }
    }

    @Override
    public Entity getHolder() {
        return this.entity;
    }

    @Override
    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    @Override
    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    @Override
    public float getItemInMainHandDropChance() {
        return this.getDropChance(EquipmentSlotType.MAINHAND);
    }

    @Override
    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(EquipmentSlotType.MAINHAND, chance);
    }

    @Override
    public float getItemInOffHandDropChance() {
        return this.getDropChance(EquipmentSlotType.OFFHAND);
    }

    @Override
    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(EquipmentSlotType.OFFHAND, chance);
    }

    @Override
    public float getHelmetDropChance() {
        return this.getDropChance(EquipmentSlotType.HEAD);
    }

    @Override
    public void setHelmetDropChance(float chance) {
        this.setDropChance(EquipmentSlotType.HEAD, chance);
    }

    @Override
    public float getChestplateDropChance() {
        return this.getDropChance(EquipmentSlotType.CHEST);
    }

    @Override
    public void setChestplateDropChance(float chance) {
        this.setDropChance(EquipmentSlotType.CHEST, chance);
    }

    @Override
    public float getLeggingsDropChance() {
        return this.getDropChance(EquipmentSlotType.LEGS);
    }

    @Override
    public void setLeggingsDropChance(float chance) {
        this.setDropChance(EquipmentSlotType.LEGS, chance);
    }

    @Override
    public float getBootsDropChance() {
        return this.getDropChance(EquipmentSlotType.FEET);
    }

    @Override
    public void setBootsDropChance(float chance) {
        this.setDropChance(EquipmentSlotType.FEET, chance);
    }

    private void setDropChance(EquipmentSlotType slot, float chance) {
        if (slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND) {
            ((MobEntity)this.entity.getHandle()).field_82174_bp[slot.func_188454_b()] = chance;
        } else {
            ((MobEntity)this.entity.getHandle()).field_184655_bs[slot.func_188454_b()] = chance;
        }
    }

    private float getDropChance(EquipmentSlotType slot) {
        if (slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND) {
            return ((MobEntity)this.entity.getHandle()).field_82174_bp[slot.func_188454_b()];
        }
        return ((MobEntity)this.entity.getHandle()).field_184655_bs[slot.func_188454_b()];
    }
}

