/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class CraftInventoryCustom
extends CraftInventory {
    public CraftInventoryCustom(InventoryHolder owner, InventoryType type) {
        super(new MinecraftInventory(owner, type));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, String title) {
        super(new MinecraftInventory(owner, type, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size) {
        super(new MinecraftInventory(owner, size));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size, String title) {
        super(new MinecraftInventory(owner, size, title));
    }

    static class MinecraftInventory
    implements IInventory {
        private final NonNullList<ItemStack> items;
        private int maxStack = 64;
        private final List<HumanEntity> viewers;
        private final String title;
        private InventoryType type;
        private final InventoryHolder owner;

        public MinecraftInventory(InventoryHolder owner, InventoryType type) {
            this(owner, type.getDefaultSize(), type.getDefaultTitle());
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, InventoryType type, String title) {
            this(owner, type.getDefaultSize(), title);
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, int size) {
            this(owner, size, "Chest");
        }

        public MinecraftInventory(InventoryHolder owner, int size, String title) {
            Validate.notNull((Object)title, (String)"Title cannot be null");
            this.items = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
            this.title = title;
            this.viewers = new ArrayList<HumanEntity>();
            this.owner = owner;
            this.type = InventoryType.CHEST;
        }

        public int func_70302_i_() {
            return this.items.size();
        }

        public ItemStack func_70301_a(int i) {
            return (ItemStack)this.items.get(i);
        }

        public ItemStack func_70298_a(int i, int j) {
            ItemStack result;
            ItemStack stack = this.func_70301_a(i);
            if (stack == ItemStack.field_190927_a) {
                return stack;
            }
            if (stack.func_190916_E() <= j) {
                this.func_70299_a(i, ItemStack.field_190927_a);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, j);
                stack.func_190918_g(j);
            }
            this.func_70296_d();
            return result;
        }

        public ItemStack func_70304_b(int i) {
            ItemStack result;
            ItemStack stack = this.func_70301_a(i);
            if (stack == ItemStack.field_190927_a) {
                return stack;
            }
            if (stack.func_190916_E() <= 1) {
                this.func_70299_a(i, null);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, 1);
                stack.func_190918_g(1);
            }
            return result;
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            this.items.set(i, (Object)itemstack);
            if (itemstack != ItemStack.field_190927_a && this.func_70297_j_() > 0 && itemstack.func_190916_E() > this.func_70297_j_()) {
                itemstack.func_190920_e(this.func_70297_j_());
            }
        }

        public int func_70297_j_() {
            return this.maxStack;
        }

        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(PlayerEntity entityhuman) {
            return true;
        }

        public List<ItemStack> getContents() {
            return this.items;
        }

        public void onOpen(CraftHumanEntity who) {
            this.viewers.add(who);
        }

        public void onClose(CraftHumanEntity who) {
            this.viewers.remove(who);
        }

        public List<HumanEntity> getViewers() {
            return this.viewers;
        }

        public InventoryType getType() {
            return this.type;
        }

        public InventoryHolder getOwner() {
            return this.owner;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return true;
        }

        public void func_174889_b(PlayerEntity entityHuman) {
        }

        public void func_174886_c(PlayerEntity entityHuman) {
        }

        public void func_174888_l() {
            this.items.clear();
        }

        public Location getLocation() {
            return null;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean func_191420_l() {
            ItemStack itemstack;
            Iterator iterator = this.items.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((itemstack = (ItemStack)iterator.next()).func_190926_b());
            return false;
        }
    }
}

