/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.BookMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaBookSigned
extends CraftMetaBook
implements BookMeta {
    public CraftMetaBookSigned(CraftMetaItem meta) {
        super(meta);
    }

    CraftMetaBookSigned(CompoundNBT tag) {
        super(tag, false);
        boolean resolved = true;
        if (tag.func_74764_b(CraftMetaBookSigned.RESOLVED.NBT)) {
            resolved = tag.func_74767_n(CraftMetaBookSigned.RESOLVED.NBT);
        }
        if (tag.func_74764_b(CraftMetaBookSigned.BOOK_PAGES.NBT)) {
            ListNBT pages = tag.func_150295_c(CraftMetaBookSigned.BOOK_PAGES.NBT, 8);
            int i = 0;
            while (i < Math.min(pages.size(), 100)) {
                block6: {
                    String page = pages.func_150307_f(i);
                    if (resolved) {
                        try {
                            this.pages.add(ITextComponent.Serializer.func_150699_a((String)page));
                            break block6;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.addPage(page);
                }
                ++i;
            }
        }
    }

    CraftMetaBookSigned(Map<String, Object> map) {
        super(map);
    }

    @Override
    void applyToItem(CompoundNBT itemData) {
        super.applyToItem(itemData, false);
        if (this.hasTitle()) {
            itemData.func_74778_a(CraftMetaBookSigned.BOOK_TITLE.NBT, this.title);
        }
        if (this.hasAuthor()) {
            itemData.func_74778_a(CraftMetaBookSigned.BOOK_AUTHOR.NBT, this.author);
        }
        if (this.hasPages()) {
            ListNBT list = new ListNBT();
            for (ITextComponent page : this.pages) {
                list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)page)));
            }
            itemData.func_218657_a(CraftMetaBookSigned.BOOK_PAGES.NBT, (INBT)list);
        }
        itemData.func_74757_a(CraftMetaBookSigned.RESOLVED.NBT, true);
        if (this.generation != null) {
            itemData.func_74768_a(CraftMetaBookSigned.GENERATION.NBT, this.generation.intValue());
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case WRITABLE_BOOK: 
            case WRITTEN_BOOK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CraftMetaBookSigned clone() {
        CraftMetaBookSigned meta = (CraftMetaBookSigned)super.clone();
        return meta;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        return original != hash ? CraftMetaBookSigned.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        return super.equalsCommon(meta);
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBookSigned || this.isBookEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        return builder;
    }
}

