/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.inventory;

import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class CraftShapedRecipe
extends ShapedRecipe
implements CraftRecipe {
    private net.minecraft.item.crafting.ShapedRecipe recipe;

    public CraftShapedRecipe(NamespacedKey key, ItemStack result) {
        super(key, result);
    }

    public CraftShapedRecipe(ItemStack result, net.minecraft.item.crafting.ShapedRecipe recipe) {
        this(CraftNamespacedKey.fromMinecraft(recipe.func_199560_c()), result);
        this.recipe = recipe;
    }

    public static CraftShapedRecipe fromBukkitRecipe(ShapedRecipe recipe) {
        if (recipe instanceof CraftShapedRecipe) {
            return (CraftShapedRecipe)recipe;
        }
        CraftShapedRecipe ret = new CraftShapedRecipe(recipe.getKey(), recipe.getResult());
        ret.setGroup(recipe.getGroup());
        String[] shape = recipe.getShape();
        ret.shape(shape);
        Map<Character, RecipeChoice> ingredientMap = recipe.getChoiceMap();
        for (char c : ingredientMap.keySet()) {
            RecipeChoice stack = ingredientMap.get(Character.valueOf(c));
            if (stack == null) continue;
            ret.setIngredient(c, stack);
        }
        return ret;
    }

    @Override
    public void addToCraftingManager() {
        String[] shape = this.getShape();
        Map<Character, RecipeChoice> ingred = this.getChoiceMap();
        int width = shape[0].length();
        NonNullList data = NonNullList.func_191197_a((int)(shape.length * width), (Object)Ingredient.field_193370_a);
        int i = 0;
        while (i < shape.length) {
            String row = shape[i];
            int j = 0;
            while (j < row.length()) {
                data.set(i * width + j, (Object)this.toNMS(ingred.get(Character.valueOf(row.charAt(j))), false));
                ++j;
            }
            ++i;
        }
        MinecraftServer.getServer().func_199529_aN().addRecipe((IRecipe)new net.minecraft.item.crafting.ShapedRecipe(CraftNamespacedKey.toMinecraft(this.getKey()), this.getGroup(), width, shape.length, data, CraftItemStack.asNMSCopy(this.getResult())));
    }
}

