/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.legacy;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.BlockStateFlatteningMap;
import net.minecraft.util.datafix.fixes.ItemIntIDToString;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.Registry;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.material.MaterialData;

@Deprecated
public final class CraftLegacy {
    private static final Map<Byte, Material> SPAWN_EGGS = new HashMap<Byte, Material>();
    private static final Set<String> whitelistedStates = new HashSet<String>(Arrays.asList("explode", "check_decay", "decayable", "facing"));
    private static final Map<MaterialData, Item> materialToItem = new HashMap<MaterialData, Item>(16384);
    private static final Map<Item, MaterialData> itemToMaterial = new HashMap<Item, MaterialData>(1024);
    private static final Map<MaterialData, BlockState> materialToData = new HashMap<MaterialData, BlockState>(4096);
    private static final Map<BlockState, MaterialData> dataToMaterial = new HashMap<BlockState, MaterialData>(4096);
    private static final Map<MaterialData, Block> materialToBlock = new HashMap<MaterialData, Block>(4096);
    private static final Map<Block, MaterialData> blockToMaterial = new HashMap<Block, MaterialData>(1024);

    static {
        System.err.println("Initializing Legacy Material Support. Unless you have legacy plugins and/or data this is a bug!");
        if (MinecraftServer.getServer() != null && MinecraftServer.getServer().func_71239_B()) {
            new Exception().printStackTrace();
        }
        SPAWN_EGGS.put((byte)0, Material.PIG_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.BAT.getTypeId(), Material.BAT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.BLAZE.getTypeId(), Material.BLAZE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.CAVE_SPIDER.getTypeId(), Material.CAVE_SPIDER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.CHICKEN.getTypeId(), Material.CHICKEN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.COD.getTypeId(), Material.COD_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.COW.getTypeId(), Material.COW_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.CREEPER.getTypeId(), Material.CREEPER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.DOLPHIN.getTypeId(), Material.DOLPHIN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.DONKEY.getTypeId(), Material.DONKEY_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ELDER_GUARDIAN.getTypeId(), Material.ELDER_GUARDIAN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ENDERMAN.getTypeId(), Material.ENDERMAN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ENDERMITE.getTypeId(), Material.ENDERMITE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.EVOKER.getTypeId(), Material.EVOKER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.GHAST.getTypeId(), Material.GHAST_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.GUARDIAN.getTypeId(), Material.GUARDIAN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.HORSE.getTypeId(), Material.HORSE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.HUSK.getTypeId(), Material.HUSK_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.LLAMA.getTypeId(), Material.LLAMA_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.MAGMA_CUBE.getTypeId(), Material.MAGMA_CUBE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.MUSHROOM_COW.getTypeId(), Material.MOOSHROOM_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.MULE.getTypeId(), Material.MULE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.OCELOT.getTypeId(), Material.OCELOT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PARROT.getTypeId(), Material.PARROT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PIG.getTypeId(), Material.PIG_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PHANTOM.getTypeId(), Material.PHANTOM_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.POLAR_BEAR.getTypeId(), Material.POLAR_BEAR_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PUFFERFISH.getTypeId(), Material.PUFFERFISH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.RABBIT.getTypeId(), Material.RABBIT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SALMON.getTypeId(), Material.SALMON_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SHEEP.getTypeId(), Material.SHEEP_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SHULKER.getTypeId(), Material.SHULKER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SILVERFISH.getTypeId(), Material.SILVERFISH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SKELETON.getTypeId(), Material.SKELETON_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SKELETON_HORSE.getTypeId(), Material.SKELETON_HORSE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SLIME.getTypeId(), Material.SLIME_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SPIDER.getTypeId(), Material.SPIDER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SQUID.getTypeId(), Material.SQUID_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.STRAY.getTypeId(), Material.STRAY_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.TROPICAL_FISH.getTypeId(), Material.TROPICAL_FISH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.TURTLE.getTypeId(), Material.TURTLE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.VEX.getTypeId(), Material.VEX_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.VILLAGER.getTypeId(), Material.VILLAGER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.VINDICATOR.getTypeId(), Material.VINDICATOR_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.WITCH.getTypeId(), Material.WITCH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.WITHER_SKELETON.getTypeId(), Material.WITHER_SKELETON_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.WOLF.getTypeId(), Material.WOLF_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ZOMBIE.getTypeId(), Material.ZOMBIE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ZOMBIE_HORSE.getTypeId(), Material.ZOMBIE_HORSE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PIG_ZOMBIE.getTypeId(), Material.ZOMBIE_PIGMAN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ZOMBIE_VILLAGER.getTypeId(), Material.ZOMBIE_VILLAGER_SPAWN_EGG);
        Bootstrap.func_151354_b();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material material = materialArray[n2];
            if (material.isLegacy()) {
                byte maxData;
                if (material.isBlock()) {
                    byte data = 0;
                    while (data < 16) {
                        String name;
                        Block block;
                        MaterialData matData = new MaterialData(material, data);
                        Dynamic blockTag = BlockStateFlatteningMap.func_210049_b((int)(material.getId() << 4 | data));
                        blockTag = DataFixesManager.func_210901_a().update(TypeReferences.field_211296_l, blockTag, 100, CraftMagicNumbers.INSTANCE.getDataVersion());
                        if (!blockTag.get("Name").asString("").contains("%%FILTER_ME%%") && (block = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(name = blockTag.get("Name").asString("")))) != null) {
                            BlockState blockData = block.func_176223_P();
                            StateContainer states = block.func_176194_O();
                            Optional propMap = blockTag.getElement("Properties");
                            if (propMap.isPresent()) {
                                CompoundNBT properties = (CompoundNBT)propMap.get();
                                for (String dataKey : properties.func_150296_c()) {
                                    IProperty state = states.func_185920_a(dataKey);
                                    if (state == null) {
                                        if (whitelistedStates.contains(dataKey)) continue;
                                        throw new IllegalStateException("No state for " + dataKey);
                                    }
                                    Preconditions.checkState(!properties.func_74779_i(dataKey).isEmpty(), "Empty data string");
                                    Optional opt = state.func_185929_b(properties.func_74779_i(dataKey));
                                    if (!opt.isPresent()) {
                                        throw new IllegalStateException("No state value " + properties.func_74779_i(dataKey) + " for " + dataKey);
                                    }
                                    blockData = (BlockState)blockData.func_206870_a(state, (Comparable)opt.get());
                                }
                            }
                            if (block != Blocks.field_150350_a) {
                                materialToData.put(matData, blockData);
                                if (!dataToMaterial.containsKey(blockData)) {
                                    dataToMaterial.put(blockData, matData);
                                }
                                materialToBlock.put(matData, block);
                                if (!blockToMaterial.containsKey(block)) {
                                    blockToMaterial.put(block, matData);
                                }
                            }
                        }
                        data = (byte)(data + 1);
                    }
                }
                byte by = maxData = material.getMaxDurability() == 0 ? (byte)16 : 1;
                if (material == Material.LEGACY_MONSTER_EGG) {
                    maxData = 121;
                }
                byte data = 0;
                while (data < maxData) {
                    if (material != Material.LEGACY_MONSTER_EGG && ItemIntIDToString.func_199173_a((int)material.getId()) != null) {
                        Item newMaterial;
                        MaterialData matData = new MaterialData(material, data);
                        CompoundNBT stack = new CompoundNBT();
                        stack.func_74768_a("id", material.getId());
                        stack.func_74777_a("Damage", (short)data);
                        Dynamic converted = DataFixesManager.func_210901_a().update(TypeReferences.field_211295_k, new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)stack), -1, CraftMagicNumbers.INSTANCE.getDataVersion());
                        String newId = converted.get("id").asString("");
                        if (newId.equals("minecraft:spawn_egg")) {
                            newId = "minecraft:pig_spawn_egg";
                        }
                        if ((newMaterial = (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(newId))) != Items.field_190931_a) {
                            materialToItem.put(matData, newMaterial);
                            if (!itemToMaterial.containsKey(newMaterial)) {
                                itemToMaterial.put(newMaterial, matData);
                            }
                        }
                    }
                    data = (byte)(data + 1);
                }
                for (Map.Entry<Byte, Material> entry : SPAWN_EGGS.entrySet()) {
                    MaterialData matData = new MaterialData(Material.LEGACY_MONSTER_EGG, entry.getKey());
                    Item newMaterial = CraftMagicNumbers.getItem(entry.getValue());
                    materialToItem.put(matData, newMaterial);
                    itemToMaterial.put(newMaterial, matData);
                }
            }
            ++n2;
        }
    }

    private CraftLegacy() {
    }

    public static Material toLegacy(Material material) {
        if (material == null || material.isLegacy()) {
            return material;
        }
        return CraftLegacy.toLegacyData(material).getItemType();
    }

    public static MaterialData toLegacyData(Material material) {
        MaterialData mappedData;
        Preconditions.checkArgument(!material.isLegacy(), "toLegacy on legacy Material");
        if (material.isBlock()) {
            Block block = CraftMagicNumbers.getBlock(material);
            BlockState blockData = block.func_176223_P();
            mappedData = dataToMaterial.get(blockData);
            if (mappedData == null && (mappedData = blockToMaterial.get(block)) == null) {
                mappedData = itemToMaterial.get(block.func_199767_j());
            }
        } else {
            Item item = CraftMagicNumbers.getItem(material);
            mappedData = itemToMaterial.get(item);
        }
        return mappedData == null ? new MaterialData(Material.LEGACY_AIR) : mappedData;
    }

    public static BlockState fromLegacyData(Material material, byte data) {
        Preconditions.checkArgument(material.isLegacy(), "fromLegacyData on modern Material");
        MaterialData materialData = new MaterialData(material, data);
        BlockState converted = materialToData.get(materialData);
        if (converted != null) {
            return converted;
        }
        Block convertedBlock = materialToBlock.get(materialData);
        if (convertedBlock != null) {
            return convertedBlock.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static Item fromLegacyData(Material material, short data) {
        Preconditions.checkArgument(material.isLegacy(), "fromLegacyData on modern Material. Did you forget to define a modern (1.13+) api-version in your plugin.yml?");
        MaterialData materialData = new MaterialData(material, (byte)data);
        Item convertedItem = materialToItem.get(materialData);
        if (convertedItem != null) {
            return convertedItem;
        }
        if (material.isBlock()) {
            BlockState converted = materialToData.get(materialData);
            if (converted != null) {
                return converted.func_177230_c().func_199767_j();
            }
            Block convertedBlock = materialToBlock.get(materialData);
            if (convertedBlock != null) {
                return convertedBlock.func_199767_j();
            }
        }
        return Items.field_190931_a;
    }

    public static byte toLegacyData(BlockState blockData) {
        return CraftLegacy.toLegacy(blockData).getData();
    }

    public static Material toLegacyMaterial(BlockState blockData) {
        return CraftLegacy.toLegacy(blockData).getItemType();
    }

    public static MaterialData toLegacy(BlockState blockData) {
        MaterialData mappedData = dataToMaterial.get(blockData);
        if (mappedData == null) {
            mappedData = blockToMaterial.get(blockData.func_177230_c());
        }
        return mappedData == null ? new MaterialData(Material.LEGACY_AIR) : mappedData;
    }

    public static Material fromLegacy(Material material) {
        if (material == null || !material.isLegacy()) {
            return material;
        }
        return CraftLegacy.fromLegacy(new MaterialData(material));
    }

    public static Material fromLegacy(MaterialData materialData) {
        return CraftLegacy.fromLegacy(materialData, false);
    }

    public static Material fromLegacy(MaterialData materialData, boolean itemPriority) {
        Item item;
        Material material = materialData.getItemType();
        if (material == null || !material.isLegacy()) {
            return material;
        }
        Material mappedData = null;
        if (itemPriority && (item = materialToItem.get(materialData)) != null) {
            mappedData = CraftMagicNumbers.getMaterial(item);
        }
        if (mappedData == null && material.isBlock()) {
            Block block;
            BlockState iblock = materialToData.get(materialData);
            if (iblock != null) {
                mappedData = CraftMagicNumbers.getMaterial(iblock.func_177230_c());
            }
            if (mappedData == null && (block = materialToBlock.get(materialData)) != null) {
                mappedData = CraftMagicNumbers.getMaterial(block);
            }
        }
        if (!itemPriority && mappedData == null && (item = materialToItem.get(materialData)) != null) {
            mappedData = CraftMagicNumbers.getMaterial(item);
        }
        return mappedData == null ? Material.AIR : mappedData;
    }

    public static Material[] values() {
        Material[] values = Material.values();
        return Arrays.copyOfRange(values, Material.LEGACY_AIR.ordinal(), values.length);
    }

    public static Material valueOf(String name) {
        return name.startsWith("LEGACY_") ? Material.valueOf(name) : Material.valueOf("LEGACY_" + name);
    }

    public static Material getMaterial(String name) {
        return name.startsWith("LEGACY_") ? Material.getMaterial(name) : Material.getMaterial("LEGACY_" + name);
    }

    public static Material matchMaterial(String name) {
        return name.startsWith("LEGACY_") ? Material.matchMaterial(name) : Material.matchMaterial("LEGACY_" + name);
    }

    public static int ordinal(Material material) {
        Preconditions.checkArgument(material.isLegacy(), "ordinal on modern Material");
        return material.ordinal() - Material.LEGACY_AIR.ordinal();
    }

    public static String name(Material material) {
        return material.name().substring("LEGACY_".length());
    }

    public static String toString(Material material) {
        return CraftLegacy.name(material);
    }

    public static void init() {
    }

    public static void main(String[] args) {
        System.err.println("");
    }
}

