/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.persistence;

import com.google.common.primitives.Primitives;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_15_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.persistence.PersistentDataContainer;

public final class CraftPersistentDataTypeRegistry {
    private final Function<Class, TagAdapter> CREATE_ADAPTER = this::createAdapter;
    private final Map<Class, TagAdapter> adapters = new HashMap<Class, TagAdapter>();

    private <T> TagAdapter createAdapter(Class<T> type) {
        if (!Primitives.isWrapperType(type)) {
            type = Primitives.wrap(type);
        }
        if (Objects.equals(Byte.class, type)) {
            return this.createAdapter(Byte.class, ByteNBT.class, ByteNBT::func_229671_a_, ByteNBT::func_150290_f);
        }
        if (Objects.equals(Short.class, type)) {
            return this.createAdapter(Short.class, ShortNBT.class, ShortNBT::func_229701_a_, ShortNBT::func_150289_e);
        }
        if (Objects.equals(Integer.class, type)) {
            return this.createAdapter(Integer.class, IntNBT.class, IntNBT::func_229692_a_, IntNBT::func_150287_d);
        }
        if (Objects.equals(Long.class, type)) {
            return this.createAdapter(Long.class, LongNBT.class, LongNBT::func_229698_a_, LongNBT::func_150291_c);
        }
        if (Objects.equals(Float.class, type)) {
            return this.createAdapter(Float.class, FloatNBT.class, FloatNBT::func_229689_a_, FloatNBT::func_150288_h);
        }
        if (Objects.equals(Double.class, type)) {
            return this.createAdapter(Double.class, DoubleNBT.class, DoubleNBT::func_229684_a_, DoubleNBT::func_150286_g);
        }
        if (Objects.equals(String.class, type)) {
            return this.createAdapter(String.class, StringNBT.class, StringNBT::func_229705_a_, StringNBT::func_150285_a_);
        }
        if (Objects.equals(byte[].class, type)) {
            return this.createAdapter(byte[].class, ByteArrayNBT.class, array -> new ByteArrayNBT(Arrays.copyOf(array, ((byte[])array).length)), n -> Arrays.copyOf(n.func_150292_c(), n.size()));
        }
        if (Objects.equals(int[].class, type)) {
            return this.createAdapter(int[].class, IntArrayNBT.class, array -> new IntArrayNBT(Arrays.copyOf(array, ((int[])array).length)), n -> Arrays.copyOf(n.func_150302_c(), n.size()));
        }
        if (Objects.equals(long[].class, type)) {
            return this.createAdapter(long[].class, LongArrayNBT.class, array -> new LongArrayNBT(Arrays.copyOf(array, ((long[])array).length)), n -> Arrays.copyOf(n.func_197652_h(), n.size()));
        }
        if (Objects.equals(PersistentDataContainer.class, type)) {
            return this.createAdapter(CraftPersistentDataContainer.class, CompoundNBT.class, CraftPersistentDataContainer::toTagCompound, tag -> {
                CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                for (String key : tag.func_150296_c()) {
                    container.put(key, tag.func_74781_a(key));
                }
                return container;
            });
        }
        throw new IllegalArgumentException("Could not find a valid TagAdapter implementation for the requested type " + type.getSimpleName());
    }

    private <T, Z extends INBT> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, Function<T, Z> builder, Function<Z, T> extractor) {
        return new TagAdapter<T, Z>(primitiveType, nbtBaseType, builder, extractor);
    }

    public <T> INBT wrap(Class<T> type, T value) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).build(value);
    }

    public <T> boolean isInstanceOf(Class<T> type, INBT base) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).isInstance(base);
    }

    public <T> T extract(Class<T> type, INBT tag) throws ClassCastException, IllegalArgumentException {
        TagAdapter adapter = this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER);
        Validate.isTrue((boolean)adapter.isInstance(tag), (String)"`The found tag instance cannot store %s as it is a %s", (Object[])new Object[]{type.getSimpleName(), tag.getClass().getSimpleName()});
        Object foundValue = adapter.extract(tag);
        Validate.isInstanceOf(type, foundValue, (String)"The found object is of the type %s. Expected type %s", (Object[])new Object[]{foundValue.getClass().getSimpleName(), type.getSimpleName()});
        return type.cast(foundValue);
    }

    private class TagAdapter<T, Z extends INBT> {
        private final Function<T, Z> builder;
        private final Function<Z, T> extractor;
        private final Class<T> primitiveType;
        private final Class<Z> nbtBaseType;

        public TagAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, Function<T, Z> builder, Function<Z, T> extractor) {
            this.primitiveType = primitiveType;
            this.nbtBaseType = nbtBaseType;
            this.builder = builder;
            this.extractor = extractor;
        }

        T extract(INBT base) {
            Validate.isInstanceOf(this.nbtBaseType, (Object)base, (String)"The provided NBTBase was of the type %s. Expected type %s", (Object[])new Object[]{base.getClass().getSimpleName(), this.nbtBaseType.getSimpleName()});
            return this.extractor.apply((INBT)this.nbtBaseType.cast(base));
        }

        Z build(Object value) {
            Validate.isInstanceOf(this.primitiveType, (Object)value, (String)"The provided value was of the type %s. Expected type %s", (Object[])new Object[]{value.getClass().getSimpleName(), this.primitiveType.getSimpleName()});
            return (Z)((INBT)this.builder.apply(this.primitiveType.cast(value)));
        }

        boolean isInstance(INBT base) {
            return this.nbtBaseType.isInstance(base);
        }
    }
}

