/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.scoreboard;

import java.util.Map;
import net.minecraft.scoreboard.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_15_R1.scoreboard.CraftScoreboard;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;

final class CraftScore
implements Score {
    private final String entry;
    private final CraftObjective objective;

    CraftScore(CraftObjective objective, String entry) {
        this.objective = objective;
        this.entry = entry;
    }

    @Override
    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer(this.entry);
    }

    @Override
    public String getEntry() {
        return this.entry;
    }

    @Override
    public Objective getObjective() {
        return this.objective;
    }

    @Override
    public int getScore() throws IllegalStateException {
        Map scores;
        net.minecraft.scoreboard.Score score;
        Scoreboard board = this.objective.checkState().board;
        if (board.func_96526_d().contains(this.entry) && (score = (net.minecraft.scoreboard.Score)(scores = board.func_96510_d(this.entry)).get(this.objective.getHandle())) != null) {
            return score.func_96652_c();
        }
        return 0;
    }

    @Override
    public void setScore(int score) throws IllegalStateException {
        this.objective.checkState().board.func_96529_a(this.entry, this.objective.getHandle()).func_96647_c(score);
    }

    @Override
    public boolean isScoreSet() throws IllegalStateException {
        Scoreboard board = this.objective.checkState().board;
        return board.func_96526_d().contains(this.entry) && board.func_96510_d(this.entry).containsKey(this.objective.getHandle());
    }

    @Override
    public CraftScoreboard getScoreboard() {
        return this.objective.getScoreboard();
    }
}

