/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, TextFormatting> formatMap;

    static {
        ImmutableMap.Builder<Character, TextFormatting> builder = ImmutableMap.builder();
        TextFormatting[] textFormattingArray = TextFormatting.values();
        int n = textFormattingArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextFormatting format = textFormattingArray[n2];
            builder.put(Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), format);
            ++n2;
        }
        formatMap = builder.build();
    }

    public static TextFormatting getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(TextFormatting format) {
        return ChatColor.getByChar(format.field_96329_z);
    }

    public static ITextComponent wrapOrNull(String message) {
        return message == null || message.isEmpty() ? null : new StringTextComponent(message);
    }

    public static ITextComponent wrapOrEmpty(String message) {
        return message == null ? new StringTextComponent("") : new StringTextComponent(message);
    }

    public static ITextComponent fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static ITextComponent fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static ITextComponent[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static ITextComponent[] fromString(String message, boolean keepNewlines) {
        return new StringMessage(message, keepNewlines).getOutput();
    }

    public static String toJSON(ITextComponent component) {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)component);
    }

    public static String fromComponent(ITextComponent component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (ITextComponent c : component) {
            Style modi = c.func_150256_b();
            TextFormatting color = modi.func_150215_a();
            if (!c.func_150261_e().isEmpty() || color != null) {
                if (color != null) {
                    out.append(color);
                    if (color != TextFormatting.RESET) {
                        hadFormat = true;
                    }
                } else if (hadFormat) {
                    out.append((Object)ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.func_150223_b()) {
                out.append(TextFormatting.BOLD);
            }
            if (modi.func_150242_c()) {
                out.append(TextFormatting.ITALIC);
            }
            if (modi.func_150234_e()) {
                out.append(TextFormatting.UNDERLINE);
            }
            if (modi.func_150236_d()) {
                out.append(TextFormatting.STRIKETHROUGH);
            }
            if (modi.func_150233_f()) {
                out.append(TextFormatting.OBFUSCATED);
            }
            out.append(c.func_150261_e());
        }
        return out.toString();
    }

    public static ITextComponent fixComponent(ITextComponent component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static ITextComponent fixComponent(ITextComponent component, Matcher matcher) {
        StringTextComponent text;
        String msg;
        if (component instanceof StringTextComponent && matcher.reset(msg = (text = (StringTextComponent)component).func_150261_e()).find()) {
            matcher.reset();
            Style modifier = text.func_150256_b() != null ? text.func_150256_b() : new Style();
            ArrayList<Object> extras = new ArrayList<Object>();
            ArrayList extrasOld = new ArrayList(text.func_150253_a());
            text = new StringTextComponent("");
            component = text;
            int pos = 0;
            while (matcher.find()) {
                String match = matcher.group();
                if (!match.startsWith("http://") && !match.startsWith("https://")) {
                    match = "http://" + match;
                }
                StringTextComponent stringTextComponent = new StringTextComponent(msg.substring(pos, matcher.start()));
                stringTextComponent.func_150255_a(modifier);
                extras.add(stringTextComponent);
                StringTextComponent link = new StringTextComponent(matcher.group());
                Style linkModi = modifier.func_150232_l();
                linkModi.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, match));
                link.func_150255_a(linkModi);
                extras.add(link);
                pos = matcher.end();
            }
            StringTextComponent prev = new StringTextComponent(msg.substring(pos));
            prev.func_150255_a(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (ITextComponent iTextComponent : extras) {
                text.func_150257_a(iTextComponent);
            }
        }
        List extras = component.func_150253_a();
        int i = 0;
        while (i < extras.size()) {
            ITextComponent comp = (ITextComponent)extras.get(i);
            if (comp.func_150256_b() != null && comp.func_150256_b().func_150235_h() == null) {
                extras.set(i, CraftChatMessage.fixComponent(comp, matcher));
            }
            ++i;
        }
        if (component instanceof TranslationTextComponent) {
            Object[] subs = ((TranslationTextComponent)component).func_150271_j();
            int i2 = 0;
            while (i2 < subs.length) {
                Object comp = subs[i2];
                if (comp instanceof ITextComponent) {
                    ITextComponent c = (ITextComponent)comp;
                    if (c.func_150256_b() != null && c.func_150256_b().func_150235_h() == null) {
                        subs[i2] = CraftChatMessage.fixComponent(c, matcher);
                    }
                } else if (comp instanceof String && matcher.reset((String)comp).find()) {
                    subs[i2] = CraftChatMessage.fixComponent((ITextComponent)new StringTextComponent((String)comp), matcher);
                }
                ++i2;
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    static /* synthetic */ Map access$0() {
        return formatMap;
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-or])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-or])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private final List<ITextComponent> list = new ArrayList<ITextComponent>();
        private ITextComponent currentChatComponent = new StringTextComponent("");
        private Style modifier = new Style();
        private final ITextComponent[] output;
        private int currentIndex;
        private final String message;
        private static /* synthetic */ int[] $SWITCH_TABLE$net$minecraft$server$EnumChatFormat;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new ITextComponent[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        format = (TextFormatting)CraftChatMessage.access$0().get(Character.valueOf(match.toLowerCase(Locale.ENGLISH).charAt(1)));
                        if (!format.func_96301_b() || format == TextFormatting.RESET) ** GOTO lbl49
                        switch (StringMessage.$SWITCH_TABLE$net$minecraft$server$EnumChatFormat()[format.ordinal()]) {
                            case 18: {
                                this.modifier.func_150227_a(Boolean.TRUE);
                                ** GOTO lbl50
                            }
                            case 21: {
                                this.modifier.func_150217_b(Boolean.TRUE);
                                ** GOTO lbl50
                            }
                            case 19: {
                                this.modifier.func_150225_c(Boolean.TRUE);
                                ** GOTO lbl50
                            }
                            case 20: {
                                this.modifier.func_150228_d(Boolean.TRUE);
                                ** GOTO lbl50
                            }
                            case 17: {
                                this.modifier.func_150237_e(Boolean.TRUE);
                                ** GOTO lbl50
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl49:
                        // 1 sources

                        this.modifier = new Style().func_150238_a(format);
lbl50:
                        // 6 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + match;
                        }
                        this.modifier.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, match));
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier.func_150241_a(null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new ITextComponent[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            ITextComponent addition = new StringTextComponent(this.message.substring(this.currentIndex, index)).func_150255_a(this.modifier);
            this.currentIndex = index;
            this.modifier = this.modifier.func_150232_l();
            if (this.modifier.func_150215_a() == TextFormatting.RESET) {
                this.modifier.func_150238_a(null);
            }
            if (this.currentChatComponent == null) {
                this.currentChatComponent = new StringTextComponent("");
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.func_150257_a(addition);
        }

        private ITextComponent[] getOutput() {
            return this.output;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$net$minecraft$server$EnumChatFormat() {
            if ($SWITCH_TABLE$net$minecraft$server$EnumChatFormat != null) {
                return $SWITCH_TABLE$net$minecraft$server$EnumChatFormat;
            }
            int[] nArray = new int[TextFormatting.values().length];
            try {
                nArray[TextFormatting.AQUA.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.BLACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.BLUE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.BOLD.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.DARK_AQUA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.DARK_BLUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.DARK_GRAY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.DARK_GREEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.DARK_PURPLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.DARK_RED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.GOLD.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.GRAY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.GREEN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.ITALIC.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.LIGHT_PURPLE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.OBFUSCATED.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.RED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.RESET.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.STRIKETHROUGH.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.UNDERLINE.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.WHITE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextFormatting.YELLOW.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$net$minecraft$server$EnumChatFormat = nArray;
            return nArray;
        }
    }
}

