/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_15_R1.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)?i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final JsonToNBT MOJANGSON_PARSER = new JsonToNBT(new StringReader(""));

    public static Object serialize(INBT base) {
        if (base instanceof CompoundNBT) {
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            for (String key : ((CompoundNBT)base).func_150296_c()) {
                innerMap.put(key, CraftNBTTagConfigSerializer.serialize(((CompoundNBT)base).func_74781_a(key)));
            }
            return innerMap;
        }
        if (base instanceof ListNBT) {
            ArrayList<Object> baseList = new ArrayList<Object>();
            int i = 0;
            while (i < ((CollectionNBT)base).size()) {
                baseList.add(CraftNBTTagConfigSerializer.serialize((INBT)((CollectionNBT)base).get(i)));
                ++i;
            }
            return baseList;
        }
        if (base instanceof StringNBT) {
            return base.func_150285_a_();
        }
        if (base instanceof IntNBT) {
            return String.valueOf(base.toString()) + "i";
        }
        return base.toString();
    }

    public static INBT deserialize(Object object) {
        if (object instanceof Map) {
            CompoundNBT compound = new CompoundNBT();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.func_218657_a((String)entry.getKey(), CraftNBTTagConfigSerializer.deserialize(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new ListNBT();
            }
            ListNBT tagList = new ListNBT();
            for (Object tag : list) {
                tagList.add((Object)CraftNBTTagConfigSerializer.deserialize(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return new JsonToNBT(new StringReader(string)).func_193606_k();
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException("Could not deserialize found list ", e);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return IntNBT.func_229692_a_((int)Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return DoubleNBT.func_229684_a_((double)Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            INBT nbtBase = MOJANGSON_PARSER.func_193596_c(string);
            if (nbtBase instanceof IntNBT) {
                return StringNBT.func_229705_a_((String)nbtBase.func_150285_a_());
            }
            if (nbtBase instanceof DoubleNBT) {
                return StringNBT.func_229705_a_((String)String.valueOf(((DoubleNBT)nbtBase).func_150286_g()));
            }
            return nbtBase;
        }
        throw new RuntimeException("Could not deserialize NBTBase");
    }
}

