/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandBlockBlock
extends ContainerBlock {
    private static final Logger field_193388_c = LogManager.getLogger();
    public static final DirectionProperty field_185564_a = DirectionalBlock.field_176387_N;
    public static final BooleanProperty field_185565_b = BlockStateProperties.field_208176_c;

    public CommandBlockBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185564_a, Direction.NORTH)).func_206870_a(field_185565_b, false));
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        CommandBlockTileEntity commandBlockTileEntity = new CommandBlockTileEntity();
        commandBlockTileEntity.func_184253_b(this == Blocks.field_185777_dd);
        return commandBlockTileEntity;
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof CommandBlockTileEntity)) {
            return;
        }
        CommandBlockTileEntity \u26032 = (CommandBlockTileEntity)tileEntity;
        boolean \u26033 = world.func_175640_z(blockPos);
        boolean \u26034 = \u26032.func_184255_d();
        \u26032.func_184250_a(\u26033);
        if (\u26034 || \u26032.func_184254_e() || \u26032.func_184251_i() == CommandBlockTileEntity.Mode.SEQUENCE) {
            return;
        }
        if (\u26033) {
            \u26032.func_184249_c();
            world.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world));
        }
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        TileEntity tileEntity = serverWorld.func_175625_s(blockPos);
        if (tileEntity instanceof CommandBlockTileEntity) {
            CommandBlockTileEntity commandBlockTileEntity = (CommandBlockTileEntity)tileEntity;
            CommandBlockLogic \u26032 = commandBlockTileEntity.func_145993_a();
            boolean \u26033 = !StringUtils.func_151246_b(\u26032.func_145753_i());
            CommandBlockTileEntity.Mode \u26034 = commandBlockTileEntity.func_184251_i();
            boolean \u26035 = commandBlockTileEntity.func_184256_g();
            if (\u26034 == CommandBlockTileEntity.Mode.AUTO) {
                commandBlockTileEntity.func_184249_c();
                if (\u26035) {
                    this.func_193387_a(blockState, serverWorld, blockPos, \u26032, \u26033);
                } else if (commandBlockTileEntity.func_184258_j()) {
                    \u26032.func_184167_a(0);
                }
                if (commandBlockTileEntity.func_184255_d() || commandBlockTileEntity.func_184254_e()) {
                    serverWorld.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(serverWorld));
                }
            } else if (\u26034 == CommandBlockTileEntity.Mode.REDSTONE) {
                if (\u26035) {
                    this.func_193387_a(blockState, serverWorld, blockPos, \u26032, \u26033);
                } else if (commandBlockTileEntity.func_184258_j()) {
                    \u26032.func_184167_a(0);
                }
            }
            serverWorld.func_175666_e(blockPos, this);
        }
    }

    private void func_193387_a(BlockState blockState, World world, BlockPos blockPos, CommandBlockLogic commandBlockLogic, boolean bl) {
        if (bl) {
            commandBlockLogic.func_145755_a(world);
        } else {
            commandBlockLogic.func_184167_a(0);
        }
        CommandBlockBlock.func_193386_c(world, blockPos, blockState.func_177229_b(field_185564_a));
    }

    @Override
    public int func_149738_a(IWorldReader iWorldReader) {
        return 1;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof CommandBlockTileEntity && playerEntity.func_195070_dx()) {
            playerEntity.func_184824_a((CommandBlockTileEntity)tileEntity);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof CommandBlockTileEntity) {
            return ((CommandBlockTileEntity)tileEntity).func_145993_a().func_145760_g();
        }
        return 0;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof CommandBlockTileEntity)) {
            return;
        }
        CommandBlockTileEntity \u26032 = (CommandBlockTileEntity)tileEntity;
        CommandBlockLogic \u26033 = \u26032.func_145993_a();
        if (itemStack.func_82837_s()) {
            \u26033.func_207405_b(itemStack.func_200301_q());
        }
        if (!world.field_72995_K) {
            if (itemStack.func_179543_a("BlockEntityTag") == null) {
                \u26033.func_175573_a(world.func_82736_K().func_223586_b(GameRules.field_223611_n));
                \u26032.func_184253_b(this == Blocks.field_185777_dd);
            }
            if (\u26032.func_184251_i() == CommandBlockTileEntity.Mode.SEQUENCE) {
                boolean bl = world.func_175640_z(blockPos);
                \u26032.func_184250_a(bl);
            }
        }
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_185564_a, rotation.func_185831_a(blockState.func_177229_b(field_185564_a)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_185564_a)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_185564_a, field_185565_b);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (BlockState)this.func_176223_P().func_206870_a(field_185564_a, blockItemUseContext.func_196010_d().func_176734_d());
    }

    private static void func_193386_c(World world, BlockPos blockPos, Direction \u260352) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(blockPos);
        GameRules \u26032 = world.func_82736_K();
        int \u26033 = \u26032.func_223592_c(GameRules.field_223619_v);
        while (\u26033-- > 0) {
            mutable.func_189536_c(\u260352);
            BlockState blockState = world.func_180495_p(mutable);
            Block \u26034 = blockState.func_177230_c();
            if (\u26034 != Blocks.field_185777_dd || !((\u2603 = world.func_175625_s(mutable)) instanceof CommandBlockTileEntity) || (\u2603 = (CommandBlockTileEntity)\u2603).func_184251_i() != CommandBlockTileEntity.Mode.SEQUENCE) break;
            if (\u2603.func_184255_d() || \u2603.func_184254_e()) {
                CommandBlockLogic commandBlockLogic = \u2603.func_145993_a();
                if (\u2603.func_184249_c()) {
                    if (!commandBlockLogic.func_145755_a(world)) break;
                    world.func_175666_e(mutable, \u26034);
                } else if (\u2603.func_184258_j()) {
                    commandBlockLogic.func_184167_a(0);
                }
            }
            Direction \u260352 = blockState.func_177229_b(field_185564_a);
        }
        if (\u26033 <= 0) {
            int \u26036 = Math.max(\u26032.func_223592_c(GameRules.field_223619_v), 0);
            field_193388_c.warn("Command Block chain tried to execute more than {} steps!", (Object)\u26036);
        }
    }
}

