/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RedstoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> field_176348_a = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> field_176347_b = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> field_176349_M = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> field_176350_N = BlockStateProperties.field_208162_O;
    public static final IntegerProperty field_176351_O = BlockStateProperties.field_208136_ak;
    public static final Map<Direction, EnumProperty<RedstoneSide>> field_196498_A = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, field_176348_a, (Object)Direction.EAST, field_176347_b, (Object)Direction.SOUTH, field_176349_M, (Object)Direction.WEST, field_176350_N));
    protected static final VoxelShape[] field_196499_B = new VoxelShape[]{Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0)};
    private boolean field_150181_a = true;
    private final Set<BlockPos> field_150179_b = Sets.newHashSet();

    public RedstoneWireBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176348_a, RedstoneSide.NONE)).func_206870_a(field_176347_b, RedstoneSide.NONE)).func_206870_a(field_176349_M, RedstoneSide.NONE)).func_206870_a(field_176350_N, RedstoneSide.NONE)).func_206870_a(field_176351_O, 0));
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return field_196499_B[RedstoneWireBlock.func_185699_x(blockState)];
    }

    private static int func_185699_x(BlockState blockState) {
        int n = 0;
        boolean \u26032 = blockState.func_177229_b(field_176348_a) != RedstoneSide.NONE;
        boolean \u26033 = blockState.func_177229_b(field_176347_b) != RedstoneSide.NONE;
        boolean \u26034 = blockState.func_177229_b(field_176349_M) != RedstoneSide.NONE;
        boolean bl = \u2603 = blockState.func_177229_b(field_176350_N) != RedstoneSide.NONE;
        if (\u26032 || \u26034 && !\u26032 && !\u26033 && !\u2603) {
            n |= 1 << Direction.NORTH.func_176736_b();
        }
        if (\u26033 || \u2603 && !\u26032 && !\u26033 && !\u26034) {
            n |= 1 << Direction.EAST.func_176736_b();
        }
        if (\u26034 || \u26032 && !\u26033 && !\u26034 && !\u2603) {
            n |= 1 << Direction.SOUTH.func_176736_b();
        }
        if (\u2603 || \u26033 && !\u26032 && !\u26034 && !\u2603) {
            n |= 1 << Direction.WEST.func_176736_b();
        }
        return n;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        World world = blockItemUseContext.func_195991_k();
        BlockPos \u26032 = blockItemUseContext.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176350_N, this.func_208074_a(world, \u26032, Direction.WEST))).func_206870_a(field_176347_b, this.func_208074_a(world, \u26032, Direction.EAST))).func_206870_a(field_176348_a, this.func_208074_a(world, \u26032, Direction.NORTH))).func_206870_a(field_176349_M, this.func_208074_a(world, \u26032, Direction.SOUTH));
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN) {
            return blockState;
        }
        if (direction == Direction.UP) {
            return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176350_N, this.func_208074_a(iWorld, blockPos, Direction.WEST))).func_206870_a(field_176347_b, this.func_208074_a(iWorld, blockPos, Direction.EAST))).func_206870_a(field_176348_a, this.func_208074_a(iWorld, blockPos, Direction.NORTH))).func_206870_a(field_176349_M, this.func_208074_a(iWorld, blockPos, Direction.SOUTH));
        }
        return (BlockState)blockState.func_206870_a(field_196498_A.get(direction), this.func_208074_a(iWorld, blockPos, direction));
    }

    @Override
    public void func_196248_b(BlockState blockState, IWorld iWorld, BlockPos blockPos, int n) {
        try (BlockPos.PooledMutable pooledMutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Object \u26033;
                RedstoneSide redstoneSide = (RedstoneSide)blockState.func_177229_b(field_196498_A.get(direction));
                if (redstoneSide == RedstoneSide.NONE || iWorld.func_180495_p(pooledMutable.func_189533_g(blockPos).func_189536_c(direction)).func_177230_c() == this) continue;
                pooledMutable.func_189536_c(Direction.DOWN);
                BlockState \u26032 = iWorld.func_180495_p(pooledMutable);
                if (\u26032.func_177230_c() != Blocks.field_190976_dk) {
                    \u26033 = pooledMutable.func_177972_a(direction.func_176734_d());
                    \u26034 = \u26032.func_196956_a(direction.func_176734_d(), iWorld.func_180495_p((BlockPos)\u26033), iWorld, pooledMutable, (BlockPos)\u26033);
                    RedstoneWireBlock.func_196263_a(\u26032, (BlockState)\u26034, iWorld, pooledMutable, n);
                }
                pooledMutable.func_189533_g(blockPos).func_189536_c(direction).func_189536_c(Direction.UP);
                \u26033 = iWorld.func_180495_p(pooledMutable);
                if (((BlockState)\u26033).func_177230_c() == Blocks.field_190976_dk) continue;
                Object \u26034 = pooledMutable.func_177972_a(direction.func_176734_d());
                BlockState \u26035 = ((BlockState)\u26033).func_196956_a(direction.func_176734_d(), iWorld.func_180495_p((BlockPos)\u26034), iWorld, pooledMutable, (BlockPos)\u26034);
                RedstoneWireBlock.func_196263_a((BlockState)\u26033, \u26035, iWorld, pooledMutable, n);
            }
        }
    }

    private RedstoneSide func_208074_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.func_177972_a(direction);
        BlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
        \u2603 = blockPos.func_177984_a();
        BlockState \u26033 = iBlockReader.func_180495_p(\u2603);
        if (!\u26033.func_215686_e(iBlockReader, \u2603)) {
            boolean bl = \u2603 = \u26032.func_224755_d(iBlockReader, blockPos2, Direction.UP) || \u26032.func_177230_c() == Blocks.field_150438_bZ;
            if (\u2603 && RedstoneWireBlock.func_176346_d(iBlockReader.func_180495_p(blockPos2.func_177984_a()))) {
                if (\u26032.func_224756_o(iBlockReader, blockPos2)) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        if (RedstoneWireBlock.func_176343_a(\u26032, direction) || !\u26032.func_215686_e(iBlockReader, blockPos2) && RedstoneWireBlock.func_176346_d(iBlockReader.func_180495_p(blockPos2.func_177977_b()))) {
            return RedstoneSide.SIDE;
        }
        return RedstoneSide.NONE;
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        BlockState blockState2 = iWorldReader.func_180495_p(\u2603);
        return blockState2.func_224755_d(iWorldReader, \u2603, Direction.UP) || blockState2.func_177230_c() == Blocks.field_150438_bZ;
    }

    private BlockState func_176338_e(World world, BlockPos blockPos, BlockState blockState2) {
        BlockState blockState2;
        blockState2 = this.func_212568_b(world, blockPos, blockState2);
        ArrayList arrayList = Lists.newArrayList(this.field_150179_b);
        this.field_150179_b.clear();
        for (BlockPos blockPos2 : arrayList) {
            world.func_195593_d(blockPos2, this);
        }
        return blockState2;
    }

    private BlockState func_212568_b(World world, BlockPos blockPos, BlockState blockState2) {
        int n2;
        BlockState blockState = blockState2;
        int n = blockState.func_177229_b(field_176351_O);
        this.field_150181_a = false;
        int \u26035 = world.func_175687_A(blockPos);
        this.field_150181_a = true;
        int \u26033 = 0;
        if (\u26035 < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockPos2 = blockPos.func_177972_a(direction);
                BlockState \u26032 = world.func_180495_p(blockPos2);
                \u26033 = this.func_212567_a(\u26033, \u26032);
                BlockPos blockPos3 = blockPos.func_177984_a();
                if (\u26032.func_215686_e(world, blockPos2) && !world.func_180495_p(blockPos3).func_215686_e(world, blockPos3)) {
                    \u26033 = this.func_212567_a(\u26033, world.func_180495_p(blockPos2.func_177984_a()));
                    continue;
                }
                if (\u26032.func_215686_e(world, blockPos2)) continue;
                \u26033 = this.func_212567_a(\u26033, world.func_180495_p(blockPos2.func_177977_b()));
            }
        }
        if (\u26035 > (n2 = \u26033 - 1)) {
            n2 = \u26035;
        }
        if (n != n2) {
            blockState2 = (BlockState)blockState2.func_206870_a(field_176351_O, n2);
            if (world.func_180495_p(blockPos) == blockState) {
                world.func_180501_a(blockPos, blockState2, 2);
            }
            this.field_150179_b.add(blockPos);
            for (Direction direction : Direction.values()) {
                this.field_150179_b.add(blockPos.func_177972_a(direction));
            }
        }
        return blockState2;
    }

    private void func_176344_d(World world, BlockPos blockPos) {
        if (world.func_180495_p(blockPos).func_177230_c() != this) {
            return;
        }
        world.func_195593_d(blockPos, this);
        for (Direction direction : Direction.values()) {
            world.func_195593_d(blockPos.func_177972_a(direction), this);
        }
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState2.func_177230_c() == blockState.func_177230_c() || world.field_72995_K) {
            return;
        }
        this.func_176338_e(world, blockPos, blockState);
        for (Direction direction : Direction.Plane.VERTICAL) {
            world.func_195593_d(blockPos.func_177972_a(direction), this);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.func_176344_d(world, blockPos.func_177972_a(direction));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            if (world.func_180495_p(blockPos2).func_215686_e(world, blockPos2)) {
                this.func_176344_d(world, blockPos2.func_177984_a());
                continue;
            }
            this.func_176344_d(world, blockPos2.func_177977_b());
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world2, BlockPos blockPos, BlockState blockState2, boolean bl) {
        World world2;
        if (bl || blockState.func_177230_c() == blockState2.func_177230_c()) {
            return;
        }
        super.func_196243_a(blockState, world2, blockPos, blockState2, bl);
        if (world2.field_72995_K) {
            return;
        }
        for (Direction direction : Direction.values()) {
            world2.func_195593_d(blockPos.func_177972_a(direction), this);
        }
        this.func_176338_e(world2, blockPos, blockState);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.func_176344_d(world2, blockPos.func_177972_a(direction));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            if (world2.func_180495_p(blockPos2).func_215686_e(world2, blockPos2)) {
                this.func_176344_d(world2, blockPos2.func_177984_a());
                continue;
            }
            this.func_176344_d(world2, blockPos2.func_177977_b());
        }
    }

    private int func_212567_a(int n, BlockState blockState) {
        if (blockState.func_177230_c() != this) {
            return n;
        }
        int n2 = blockState.func_177229_b(field_176351_O);
        if (n2 > n) {
            return n2;
        }
        return n;
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (world.field_72995_K) {
            return;
        }
        if (blockState.func_196955_c(world, blockPos)) {
            this.func_176338_e(world, blockPos, blockState);
        } else {
            RedstoneWireBlock.func_220075_c(blockState, world, blockPos);
            world.func_217377_a(blockPos, false);
        }
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (!this.field_150181_a) {
            return 0;
        }
        return blockState.func_185911_a(iBlockReader, blockPos, direction);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction2) {
        Direction direction2;
        if (!this.field_150181_a) {
            return 0;
        }
        int n = blockState.func_177229_b(field_176351_O);
        if (n == 0) {
            return 0;
        }
        if (direction2 == Direction.UP) {
            return n;
        }
        EnumSet<Direction> \u26032 = EnumSet.noneOf(Direction.class);
        for (Direction direction3 : Direction.Plane.HORIZONTAL) {
            if (!this.func_176339_d(iBlockReader, blockPos, direction3)) continue;
            \u26032.add(direction3);
        }
        if (direction2.func_176740_k().func_176722_c() && \u26032.isEmpty()) {
            return n;
        }
        if (\u26032.contains(direction2) && !\u26032.contains(direction2.func_176735_f()) && !\u26032.contains(direction2.func_176746_e())) {
            return n;
        }
        return 0;
    }

    private boolean func_176339_d(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.func_177972_a(direction);
        BlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
        boolean \u26033 = \u26032.func_215686_e(iBlockReader, blockPos2);
        \u2603 = blockPos.func_177984_a();
        boolean \u26034 = iBlockReader.func_180495_p(\u2603).func_215686_e(iBlockReader, \u2603);
        if (!\u26034 && \u26033 && RedstoneWireBlock.func_176340_e(iBlockReader, blockPos2.func_177984_a())) {
            return true;
        }
        if (RedstoneWireBlock.func_176343_a(\u26032, direction)) {
            return true;
        }
        if (\u26032.func_177230_c() == Blocks.field_196633_cV && \u26032.func_177229_b(RedstoneDiodeBlock.field_196348_c).booleanValue() && \u26032.func_177229_b(RedstoneDiodeBlock.field_185512_D) == direction) {
            return true;
        }
        return !\u26033 && RedstoneWireBlock.func_176340_e(iBlockReader, blockPos2.func_177977_b());
    }

    protected static boolean func_176340_e(IBlockReader iBlockReader, BlockPos blockPos) {
        return RedstoneWireBlock.func_176346_d(iBlockReader.func_180495_p(blockPos));
    }

    protected static boolean func_176346_d(BlockState blockState) {
        return RedstoneWireBlock.func_176343_a(blockState, null);
    }

    protected static boolean func_176343_a(BlockState blockState2, @Nullable Direction direction) {
        BlockState blockState2;
        Block block = blockState2.func_177230_c();
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (blockState2.func_177230_c() == Blocks.field_196633_cV) {
            Direction direction2 = blockState2.func_177229_b(RepeaterBlock.field_185512_D);
            return direction2 == direction || direction2.func_176734_d() == direction;
        }
        if (Blocks.field_190976_dk == blockState2.func_177230_c()) {
            return direction == blockState2.func_177229_b(ObserverBlock.field_176387_N);
        }
        return blockState2.func_185897_m() && direction != null;
    }

    @Override
    public boolean func_149744_f(BlockState blockState) {
        return this.field_150181_a;
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176349_M))).func_206870_a(field_176347_b, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176348_a))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176347_b));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176347_b))).func_206870_a(field_176347_b, blockState.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176348_a));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176347_b, blockState.func_177229_b(field_176348_a))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176347_b))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176349_M));
            }
        }
        return blockState;
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176348_a));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState.func_206870_a(field_176347_b, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176347_b));
            }
        }
        return super.func_185471_a(blockState, mirror);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176348_a, field_176347_b, field_176349_M, field_176350_N, field_176351_O);
    }
}

